/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.fileio.LinkPosition;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import com.sap.ip.me.persist.fileio.PersistentIntStack;
import com.sap.ip.me.persist.fileio.RandomAccessFileUser;
import com.sap.ip.me.persist.fileio.TypeConverter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

final class MultipleLinkTable
extends RandomAccessFileUser {
    static final int OBJECT_HAS_NO_LINK_VECTOR = -1;
    private static final int FILE_META_LEN = 128;
    private static final int KEYS_PER_PAGE = 10;
    private static final int NEXT_PAGE_IDX_LEN = 4;
    private static final String LINK_KEY_PAGE_FILE_POSTFIX = ".l00";
    private static final String FREE_PAGE_IDX_FILE_POSTFIX = ".fl0";
    private static final int VERSION = 0;
    private final LinkDescriptor ldes;
    private final PersistentIntStack freeLinkBlocks;
    private final LinkPosition lpos;

    private int getMaxLinkBlock() throws PersistenceException {
        return this.freeLinkBlocks.getCustomValue();
    }

    private void setMaxLinkBlock(int max) throws PersistenceException {
        this.freeLinkBlocks.setCustomValue(max);
    }

    MultipleLinkTable(String fileNameBase, LinkDescriptor ldes, LinkPosition lpos) throws PersistenceException {
        super(fileNameBase + ldes.getName() + LINK_KEY_PAGE_FILE_POSTFIX);
        this.freeLinkBlocks = new PersistentIntStack(fileNameBase + ldes.getName() + FREE_PAGE_IDX_FILE_POSTFIX);
        this.ldes = ldes;
        this.lpos = lpos;
        try {
            this.initializeFileData();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private int getSingleKeyByteLength() {
        return this.lpos.keyByteLength;
    }

    private int getTotalKeysByteLength() {
        return 10 * this.getSingleKeyByteLength();
    }

    private int getSucceedingBytePosition() {
        return this.getTotalKeysByteLength();
    }

    private int getPageByteLength() {
        return this.getSucceedingBytePosition() + 4;
    }

    private int getPageIsEmptyValue() {
        return -this.getPageByteLength();
    }

    private int getPageIsCompeleteWithoutSuccessorValue() {
        return this.getPageIsEmptyValue() - 1;
    }

    void reinitialize() throws PersistenceException {
        try {
            this.initializeFileData();
            this.freeLinkBlocks.reinitialize();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private boolean pageHasSuccessor(int firstKeyByteOffset) {
        return firstKeyByteOffset >= 0;
    }

    private Vector getKeysFromEntities(MeIterator entities) {
        Vector<String> keys = new Vector<String>();
        while (entities.hasNext()) {
            Object entity = entities.next();
            String key = entity instanceof Entity ? ((Entity)entity).getEntityKey() : ((PersistableEntity)entity).getPersistedObject().getKey();
            keys.addElement(key);
        }
        return keys;
    }

    private void delete(PersistedObjectImpl object) throws IOException, PersistenceException {
        int firstY = object.getLinkVectorStart(this.lpos);
        if (this.pageHasSuccessor(firstY)) {
            this.delete(firstY);
            object.setLinkVectorStart(this.lpos, -1);
        }
    }

    private void insert(PersistedObjectImpl object) throws IOException, PersistenceException {
        MeIterator v = object.getMultipleLink(this.lpos.pos);
        if (v != null && v.hasNext()) {
            int firstY = this.insert(this.getKeysFromEntities(v));
            object.setLinkVectorStart(this.lpos, firstY);
        } else {
            object.setLinkVectorStart(this.lpos, -1);
        }
    }

    private void modify(PersistedObjectImpl object) throws IOException, PersistenceException {
        MeIterator v;
        if (!object.isModified(this.lpos.pos)) {
            return;
        }
        int firstY = object.getLinkVectorStart(this.lpos);
        if (this.pageHasSuccessor(firstY)) {
            this.delete(firstY);
        }
        if ((v = object.getMultipleLink(this.lpos.pos)) != null && v.hasNext()) {
            firstY = this.insert(this.getKeysFromEntities(v));
            object.setLinkVectorStart(this.lpos, firstY);
        } else {
            object.setLinkVectorStart(this.lpos, -1);
        }
    }

    void commit(MeIterator objIt) throws PersistenceException {
        try {
            objIt.reset();
            while (objIt.hasNext()) {
                PersistedObjectImpl o = (PersistedObjectImpl)objIt.next();
                if (o.getOperation() == PersistenceOperationType.DELETE) {
                    this.delete(o);
                    continue;
                }
                if (o.getOperation() == PersistenceOperationType.INSERT) {
                    this.insert(o);
                    continue;
                }
                if (o.getOperation() != PersistenceOperationType.MODIFY) continue;
                this.modify(o);
            }
            this.freeLinkBlocks.write();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private void verifyReadSize(int size, int required) throws PersistenceException {
        if (size != required) {
            throw new PersistenceException("file corrput");
        }
    }

    Vector get(int y) throws PersistenceException {
        byte[] tmpBuffer = new byte[this.getPageByteLength()];
        RandomAccessFile file = super.getFile();
        Vector<String> res = new Vector<String>();
        while (this.pageHasSuccessor(y)) {
            try {
                file.seek(128 + this.getPageByteLength() * y);
                this.verifyReadSize(file.read(tmpBuffer), tmpBuffer.length);
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
            y = TypeConverter.toInt(tmpBuffer, this.getSucceedingBytePosition());
            int readKeys = this.pageHasSuccessor(y) || y == this.getPageIsCompeleteWithoutSuccessorValue() ? 10 : (this.getPageByteLength() + y) / this.getSingleKeyByteLength();
            int i = 0;
            while (i < readKeys) {
                String key = TypeConverter.toString(tmpBuffer, this.getSingleKeyByteLength() * i, this.getSingleKeyByteLength());
                res.addElement(key);
                ++i;
            }
        }
        return res;
    }

    private void initializeFileData() throws IOException, PersistenceException {
        RandomAccessFile file = super.getFile();
        if (file.length() >= 128L) {
            this.initialRead();
        } else {
            this.setMaxLinkBlock(0);
            this.initialWrite();
        }
    }

    private void initialRead() throws IOException, PersistenceException {
        RandomAccessFile file = super.getFile();
        int len = (int)file.length();
        if ((len - 128) % this.getPageByteLength() != 0) {
            throw new PersistenceException("Corrupt file");
        }
        byte[] meta = new byte[128];
        file.seek(0L);
        this.verifyReadSize(file.read(meta), meta.length);
        if (TypeConverter.toInt(meta, 0) != 0) {
            throw new PersistenceException("Incompatible file");
        }
    }

    private void initialWrite() throws IOException {
        byte[] meta = new byte[128];
        TypeConverter.intoByte(0, meta, 0);
        RandomAccessFile file = super.getFile();
        file.seek(0L);
        file.write(meta);
    }

    private int insert(Vector targetKeys) throws IOException, PersistenceException {
        int firstY = -1;
        if (targetKeys.size() > 0) {
            int pageIndex;
            byte[] page = new byte[this.getPageByteLength()];
            int nextY = pageIndex = this.getFreePageIndex();
            firstY = pageIndex;
            Enumeration enumeration = targetKeys.elements();
            while (enumeration.hasMoreElements()) {
                int i = 0;
                while (i < 10 && enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    TypeConverter.intoByte(key, page, i * this.getSingleKeyByteLength(), this.getSingleKeyByteLength());
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    nextY = this.getFreePageIndex();
                    TypeConverter.intoByte(nextY, page, this.getSucceedingBytePosition());
                } else if (i < 10) {
                    TypeConverter.intoByte(-(10 - i) * this.getSingleKeyByteLength(), page, this.getSucceedingBytePosition());
                } else {
                    TypeConverter.intoByte(this.getPageIsCompeleteWithoutSuccessorValue(), page, this.getSucceedingBytePosition());
                }
                RandomAccessFile file = super.getFile();
                file.seek(128 + pageIndex * this.getPageByteLength());
                file.write(page);
                pageIndex = nextY;
            }
        }
        return firstY;
    }

    private void delete(int y) throws IOException, PersistenceException {
        byte[] page = new byte[this.getPageByteLength()];
        byte[] next = new byte[4];
        RandomAccessFile file = super.getFile();
        while (this.pageHasSuccessor(y)) {
            file.seek(128 + this.getPageByteLength() * y + this.getSucceedingBytePosition());
            this.verifyReadSize(file.read(next), next.length);
            file.seek(128 + this.getPageByteLength() * y + this.getSucceedingBytePosition());
            file.writeInt(this.getPageIsEmptyValue());
            this.releasePageIndex(y);
            y = TypeConverter.toInt(next, 0);
        }
    }

    private void releasePageIndex(int y) throws PersistenceException {
        this.freeLinkBlocks.push(y);
    }

    private int getFreePageIndex() throws PersistenceException {
        int y;
        if (!this.freeLinkBlocks.isEmpty()) {
            y = this.freeLinkBlocks.pop();
        } else {
            y = this.getMaxLinkBlock() + 1;
            this.setMaxLinkBlock(y);
        }
        return y;
    }
}

