/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.fileio.TypeConverter;

final class LinkPosition {
    private static final int LENGTH_AS_VECTOR = 4;
    final int offset;
    final int keyByteLength;
    final int byteLengthInObjTab;
    final MultiplicityType mult;
    final AttributeType keyAttType;
    final int pos;

    LinkPosition(LinkDescriptor ldes, AttributeDescriptor keyDes, int pos, int offset) {
        this.offset = offset;
        this.mult = ldes.getMultiplicity();
        this.keyAttType = keyDes.getType();
        this.keyByteLength = this.keyAttType.toByteLen(keyDes.getLength(), keyDes.getDecimals());
        this.byteLengthInObjTab = this.mult == MultiplicityType.SINGLE ? this.keyByteLength : 4;
        this.pos = pos;
    }

    void toByte(byte[] b, Object linkKey, int offset) {
        if (this.mult == MultiplicityType.SINGLE) {
            this.keyAttType.toByte(b, offset + this.offset, linkKey, this.keyByteLength, 0);
        } else if (linkKey != null) {
            TypeConverter.intoByte((int)((Integer)linkKey), b, offset + this.offset);
        } else {
            TypeConverter.intoByte(-1, b, offset + this.offset);
        }
    }

    Object toValue(byte[] b) {
        if (this.mult == MultiplicityType.SINGLE) {
            return this.keyAttType.toValue(b, this.offset);
        }
        return new Integer(TypeConverter.toInt(b, this.offset));
    }
}

