/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeBitSet;
import com.sap.ip.me.persist.fileio.AttributePosition;
import com.sap.ip.me.persist.fileio.Constants;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import com.sap.ip.me.persist.fileio.RandomAccessFileUser;
import com.sap.ip.me.persist.fileio.TypeConverter;
import java.io.IOException;
import java.io.RandomAccessFile;

abstract class IndexTree
extends RandomAccessFileUser {
    static final int INVALID_NODE = -1;
    static final int END_OF_TREE = -2;
    static final int ROOT_NODE = 0;
    static final int FIRST_NODE_IDX = 0;
    static final int INVALID_ROW_IDX = -1;
    final AttributeDescriptor ATT_DES;
    final AttributePosition KEY_ATT_POS;
    final AttributeType keyType;
    final int keyLen;
    final int lNodePos;
    final int rNodePos;
    private static final int VERSION = 0;
    private static final String IDX_FILE_POSTFIX = ".i00";
    private static final int IDX_FILE_META_LEN = 128;
    private static final int IDX_LEN = 4;
    private static final int NODE_LEN = 4;
    private static final int IDX_POS = 0;
    private static final int INITIAL_SIZE = 10;
    private static final int KEY_POS = 4;
    private static final int MAX_BLOCK_BUF = 10;
    private final MeBitSet VALID_ROWS = new MeBitSet();
    private final MeBitSet MODIFIED_NODES = new MeBitSet();
    private final int recLen;
    int maxNode;
    int[] idx;
    Object[] key;
    int[] lNode;
    int[] rNode;
    private int[] rowToNode;
    private boolean isInitial;
    private boolean isModified;
    private static byte[] buffer = new byte[10000];

    IndexTree(String fileNameBase, AttributeDescriptor keyAtt, AttributePosition keyAttPos) throws PersistenceException {
        super(fileNameBase + IDX_FILE_POSTFIX);
        this.keyType = keyAtt.getType();
        this.ATT_DES = keyAtt;
        this.KEY_ATT_POS = keyAttPos;
        this.keyLen = keyAttPos.singleByteLen;
        this.lNodePos = 4 + this.keyLen;
        this.rNodePos = this.lNodePos + 4;
        this.recLen = this.rNodePos + 4;
        if (buffer == null || this.recLen * 10 > buffer.length) {
            buffer = new byte[(4 + this.recLen + 8) * 10];
        }
        this.key = new Object[10];
        this.idx = new int[10];
        this.lNode = new int[10];
        this.rNode = new int[10];
        this.rowToNode = new int[10];
        int x = 0;
        while (x < 10) {
            this.idx[x] = -1;
            this.lNode[x] = -2;
            this.rNode[x] = -2;
            this.rowToNode[x] = -1;
            ++x;
        }
        this.initializeFileData();
    }

    final void reinitialize() throws PersistenceException {
        this.idx = null;
        this.key = null;
        this.rNode = null;
        this.lNode = null;
        this.initializeFileData();
    }

    final void commit(MeIterator opIt) throws PersistenceException {
        this.transientDeleteIndexes(opIt);
        this.transientInsertIndexes(opIt);
        this.persistIndexFile();
    }

    abstract boolean isPrimary();

    final MeBitSet getValidRows() {
        return this.VALID_ROWS;
    }

    private final void ensureCapacity(int require) {
        if (require > this.idx.length) {
            int newCapa = Math.max(require, this.idx.length * 2);
            Object[] oldKey = this.key;
            int[] oldIdx = this.idx;
            int[] oldLNode = this.lNode;
            int[] oldRNode = this.rNode;
            int[] oldRowToNode = this.rowToNode;
            this.key = new Object[newCapa];
            this.idx = new int[newCapa];
            this.lNode = new int[newCapa];
            this.rNode = new int[newCapa];
            this.rowToNode = new int[newCapa];
            System.arraycopy(oldKey, 0, this.key, 0, oldKey.length);
            System.arraycopy(oldIdx, 0, this.idx, 0, oldIdx.length);
            System.arraycopy(oldLNode, 0, this.lNode, 0, oldLNode.length);
            System.arraycopy(oldRNode, 0, this.rNode, 0, oldRNode.length);
            System.arraycopy(oldRowToNode, 0, this.rowToNode, 0, oldRowToNode.length);
            int x = oldIdx.length;
            while (x < newCapa) {
                this.idx[x] = -1;
                this.lNode[x] = -2;
                this.rNode[x] = -2;
                this.rowToNode[x] = -1;
                ++x;
            }
        }
    }

    final Object getKey(int rowIdx) {
        int nodeIdx = this.rowToNode[rowIdx];
        return nodeIdx > -1 ? this.key[nodeIdx] : null;
    }

    private int getLeftNodeIdx(int nodeIdx) {
        return this.lNode[nodeIdx];
    }

    private int getRightNodeIdx(int nodeIdx) {
        return this.rNode[nodeIdx];
    }

    private final void initializeFileData() throws PersistenceException {
        try {
            if (this.getFile().length() >= 128L) {
                this.isInitial = false;
                this.readIndexTreeFromFile();
            } else {
                this.isInitial = true;
                this.maxNode = -1;
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private final void transientDeleteIndexes(MeIterator opIt) throws PersistenceException {
        boolean isSecondary = !this.isPrimary();
        opIt.reset();
        while (opIt.hasNext()) {
            PersistedObjectImpl op = (PersistedObjectImpl)opIt.next();
            PersistenceOperationType type = op.getOperation();
            if (type != PersistenceOperationType.DELETE && (!isSecondary || type != PersistenceOperationType.MODIFY)) continue;
            int node = this.rowToNode[op.getRowIdx()];
            this.rowToNode[this.idx[node]] = -1;
            this.VALID_ROWS.clear(this.idx[node]);
            this.idx[node] = -1;
            this.MODIFIED_NODES.set(node);
            this.isModified = true;
        }
    }

    private final void transientInsertIndexes(MeIterator opIt) throws PersistenceException {
        int cmp = 0;
        boolean isSecondary = !this.isPrimary();
        opIt.reset();
        while (opIt.hasNext()) {
            PersistedObjectImpl op = (PersistedObjectImpl)opIt.next();
            if (op.getOperation() != PersistenceOperationType.INSERT && (!isSecondary || op.getOperation() != PersistenceOperationType.MODIFY)) continue;
            Object key = op.getAttribute(op.getClassDescriptor().getPosition(this.ATT_DES));
            int nodeIdx = 0;
            if (this.maxNode < 0) {
                this.maxNode = 0;
            } else {
                int parentNode = -1;
                while (true) {
                    if (nodeIdx == -2) {
                        nodeIdx = ++this.maxNode;
                        this.ensureCapacity(this.maxNode + 1);
                        if (parentNode <= -1) break;
                        if (cmp <= 0) {
                            this.lNode[parentNode] = nodeIdx;
                        } else {
                            this.rNode[parentNode] = nodeIdx;
                        }
                        this.MODIFIED_NODES.set(parentNode);
                        break;
                    }
                    cmp = this.keyType.compare(key, this.key[nodeIdx]);
                    parentNode = nodeIdx;
                    if (this.isPrimary()) {
                        if (cmp < 0) {
                            nodeIdx = this.lNode[nodeIdx];
                            continue;
                        }
                        if (cmp > 0) {
                            nodeIdx = this.rNode[nodeIdx];
                            continue;
                        }
                        if (this.idx[nodeIdx] == -1) break;
                        throw new PersistenceException("Duplicate key");
                    }
                    if (cmp <= 0) {
                        nodeIdx = this.lNode[nodeIdx];
                        continue;
                    }
                    nodeIdx = this.rNode[nodeIdx];
                }
            }
            this.key[nodeIdx] = key;
            this.idx[nodeIdx] = op.getRowIdx();
            this.rowToNode[this.idx[nodeIdx]] = nodeIdx;
            this.MODIFIED_NODES.set(nodeIdx);
            this.VALID_ROWS.set(this.idx[nodeIdx]);
            this.isModified = true;
        }
    }

    private final void readIndexTreeFromFile() throws PersistenceException {
        try {
            try {
                RandomAccessFile file = this.getFile();
                int len = (int)file.length();
                if ((len - 128) % this.recLen != 0) {
                    throw new PersistenceException("Corrupt file");
                }
                byte[] b = new byte[len];
                file.seek(0L);
                file.read(b);
                int fileVersion = TypeConverter.toInt(b, 0);
                if (fileVersion != 0) {
                    throw new PersistenceException("Incompatible file");
                }
                this.maxNode = TypeConverter.toInt(b, 4);
                this.ensureCapacity(this.maxNode + 1);
                int bpos = 128;
                int x = 0;
                while (x <= this.maxNode) {
                    this.idx[x] = TypeConverter.toInt(b, bpos);
                    this.key[x] = this.KEY_ATT_POS.toValue(b, bpos += 4);
                    this.lNode[x] = TypeConverter.toInt(b, bpos += this.keyLen);
                    this.rNode[x] = TypeConverter.toInt(b, bpos += 4);
                    bpos += 4;
                    if (this.idx[x] != -1) {
                        this.rowToNode[this.idx[x]] = x;
                        this.VALID_ROWS.set(this.idx[x]);
                    }
                    ++x;
                }
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
            Object var12_8 = null;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            throw throwable;
        }
    }

    private final void persistIndexFile() throws PersistenceException {
        try {
            if (this.isModified) {
                if (this.isInitial) {
                    byte[] b = new byte[128];
                    TypeConverter.intoByte(0, b, 0);
                    TypeConverter.intoByte(this.maxNode, b, 4);
                    try {
                        RandomAccessFile file = this.getFile();
                        file.seek(0L);
                        file.write(b);
                    }
                    catch (IOException ex) {
                        throw new PersistenceException(ex);
                    }
                    this.isInitial = false;
                } else {
                    try {
                        RandomAccessFile file = this.getFile();
                        file.seek(4L);
                        file.writeInt(this.maxNode);
                    }
                    catch (IOException ex) {
                        throw new PersistenceException(ex);
                    }
                }
                int bufPos = 0;
                boolean writeBuf = false;
                RandomAccessFile file = this.getFile();
                int x = 0;
                while (x <= this.maxNode) {
                    if (this.MODIFIED_NODES.get(x)) {
                        TypeConverter.intoByte(this.idx[x], buffer, bufPos);
                        this.KEY_ATT_POS.toByte(this.key[x], buffer, bufPos += 4);
                        TypeConverter.intoByte(this.lNode[x], buffer, bufPos += this.keyLen);
                        TypeConverter.intoByte(this.rNode[x], buffer, bufPos += 4);
                        int nextBufPos = (bufPos += 4) + 4 + this.keyLen + 8;
                        if (nextBufPos >= buffer.length) {
                            try {
                                writeBuf = true;
                                file.seek(128 + (x + 1) * this.recLen - bufPos);
                            }
                            catch (IOException ex) {
                                throw new PersistenceException(ex);
                            }
                        }
                    } else if (bufPos > 0) {
                        writeBuf = true;
                        try {
                            file.seek(128 + x * this.recLen - bufPos);
                        }
                        catch (IOException ex) {
                            throw new PersistenceException(ex);
                        }
                    }
                    if (writeBuf) {
                        try {
                            file.write(buffer, 0, bufPos);
                        }
                        catch (IOException ex) {
                            throw new PersistenceException(ex);
                        }
                        bufPos = 0;
                        writeBuf = false;
                    }
                    ++x;
                }
                if (bufPos > 0) {
                    try {
                        file.seek(128 + (this.maxNode + 1) * this.recLen - bufPos);
                        file.write(buffer, 0, bufPos);
                    }
                    catch (IOException ex) {
                        throw new PersistenceException(ex);
                    }
                }
                this.MODIFIED_NODES.clear();
            }
            this.isModified = false;
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            throw throwable;
        }
    }

    private final void initIndexTreeFile() throws IOException {
        RandomAccessFile file = this.getFile();
        file.writeInt(0);
        file.write(Constants.NULLBYTES, 4, 128);
    }
}

