/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PackageEntityFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.Transaction;
import com.sap.ip.me.api.persist.core.TransactionManager;
import com.sap.ip.me.api.persist.core.TransactionType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.persist.fileio.AbstractEntityTable;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.EntityTable;
import com.sap.ip.me.persist.fileio.FileTransaction;
import com.sap.ip.me.persist.fileio.PersistenceRuntimeImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FileTransactionManager
extends AbstractFileTransactionManager
implements TransactionManager {
    private final Hashtable entityFactories = new Hashtable();
    FileTransaction currentTransaction;

    public final void reset() throws PersistenceException {
        if (this.currentTransaction != null) {
            throw new PersistenceException("cannot reset with open transaction");
        }
        super.reset();
    }

    protected void finalize() {
        this.currentTransaction = null;
        super.finalize();
    }

    void reinitialize() throws PersistenceException {
        if (this.currentTransaction != null) {
            throw new PersistenceException("cannot reinitialize with open transaction");
        }
        super.reinitialize();
    }

    public FileTransactionManager(ConversationId convId, PersistenceRuntimeImpl runtime) throws PersistenceException {
        super(convId, runtime);
    }

    public void deleteAll(String classtype, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            MeIterator allEnt = this.getAll(classtype, treeOption);
            while (allEnt.hasNext()) {
                this.delete((Entity)allEnt.next(), treeOption);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.deleteAll(String, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.deleteAll(String, TreeOptionType)");
        }
    }

    public void delete(String[] entityKey, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            int x = 0;
            while (x < entityKey.length) {
                this.delete(entityKey[x], treeOption);
                ++x;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.delete(String[], TreeOptionType) - DEPRECATED");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.delete(String[], TreeOptionType) - DEPRECATED");
        }
    }

    public final Transaction begin(TransactionType type) throws PersistenceException {
        if (this.currentTransaction != null) {
            throw new PersistenceException("nested transaction not supported by TransactionManager");
        }
        this.currentTransaction = new FileTransaction(this, type);
        return this.currentTransaction;
    }

    public final Transaction getTransaction() {
        return this.currentTransaction;
    }

    void rollback() {
        try {
            if (this.currentTransaction.getType() == TransactionType.WRITE) {
                Enumeration e = this.entityTables.elements();
                while (e.hasMoreElements()) {
                    ((AbstractEntityTable)e.nextElement()).rollback();
                }
            }
            this.currentTransaction = null;
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e.toString());
        }
    }

    void commit() throws PersistenceException {
        if (this.currentTransaction.getType() == TransactionType.WRITE) {
            Enumeration e = this.entityTables.elements();
            while (e.hasMoreElements()) {
                ((AbstractEntityTable)e.nextElement()).commit();
            }
        }
        this.currentTransaction = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(String entityKey) throws PersistenceException {
        boolean bl;
        block3: {
            boolean bl2;
            PerformanceLog.methodStarted();
            try {
                MeIterator it = super.getEntityTables();
                do {
                    if (it.hasNext()) continue;
                    bl = false;
                    break block3;
                } while (!((AbstractEntityTable)it.next()).contains(entityKey));
                bl2 = true;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!PerformanceLog.isOn()) throw throwable;
                PerformanceLog.methodFinished("FileTransactionManager.contains(String) - DEPRECATED");
                throw throwable;
            }
            if (!PerformanceLog.isOn()) return bl2;
            PerformanceLog.methodFinished("FileTransactionManager.contains(String) - DEPRECATED");
            return bl2;
        }
        Object var5_6 = null;
        if (!PerformanceLog.isOn()) return bl;
        PerformanceLog.methodFinished("FileTransactionManager.contains(String) - DEPRECATED");
        return bl;
    }

    public void insert(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            String type = entity.getClasstype();
            String key = entity.getEntityKey();
            if (this.contains(type, key)) {
                throw new PersistenceException("No insertion possible; entity with key {0} has already been inserted", new Object[]{entity.getEntityKey()});
            }
            this.prepareChange(type, key, entity, treeOption, PersistenceOperationType.INSERT, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.insert(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.insert(Entity, TreeOptionType)");
        }
    }

    public void insert(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            int x = 0;
            while (x < entity.length) {
                this.insert(entity[x], treeOption);
                ++x;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.insert(Entity[], TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.insert(Entity[], TreeOptionType)");
        }
    }

    public void modify(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            String type = entity.getClasstype();
            String key = entity.getEntityKey();
            if (!this.contains(type, key)) {
                throw new PersistenceException("No insertion possible; entity with key {0} has already been inserted", new Object[]{key});
            }
            this.prepareChange(type, key, entity, treeOption, PersistenceOperationType.MODIFY, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.modify(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.modify(Entity, TreeOptionType)");
        }
    }

    public void modify(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            int x = 0;
            while (x < entity.length) {
                this.modify(entity[x], treeOption);
                ++x;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.modify(Entity[], TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.modify(Entity[], TreeOptionType)");
        }
    }

    public void update(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            String type = entity.getClasstype();
            String key = entity.getEntityKey();
            this.prepareChange(type, key, entity, treeOption, PersistenceOperationType.INSERT, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.update(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.update(Entity, TreeOptionType)");
        }
    }

    public void update(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            int x = 0;
            while (x < entity.length) {
                this.update(entity[x], treeOption);
                ++x;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.update(Entity[], TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.update(Entity[], TreeOptionType)");
        }
    }

    public void delete(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            String type = entity.getClasstype();
            String key = entity.getEntityKey();
            if (!this.contains(type, key)) {
                throw new PersistenceException("No deletion possible; entity with key {0} has not yet been inserted", new Object[]{key});
            }
            this.prepareChange(type, key, entity, treeOption, PersistenceOperationType.DELETE, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.delete(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.delete(Entity, TreeOptionType)");
        }
    }

    public void delete(String key, TreeOptionType t) throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            Entity e = this.get(key, t);
            String type = e.getClasstype();
            this.prepareChange(type, key, e, t, PersistenceOperationType.DELETE, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.delete(String, TreeOptionType) - DEPRECATED");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.delete(String, TreeOptionType) - DEPRECATED");
        }
    }

    public MeIterator getAll(String classtype, TreeOptionType treeOption) throws PersistenceException {
        return super.getEntityTable(classtype).getAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(String classtype, String entityKey) throws PersistenceException {
        boolean bl;
        PerformanceLog.methodStarted();
        try {
            bl = super.getEntityTable(classtype).contains(entityKey);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.contains(String, String)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return bl;
        PerformanceLog.methodFinished("FileTransactionManager.contains(String, String)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCount(Query q) throws PersistenceException {
        int n;
        PerformanceLog.methodStarted();
        try {
            n = super.getEntityTable(q.getClasstype()).getCount(q);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return n;
        PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity get(String classtype, String entityKey) throws PersistenceException {
        Entity entity;
        PerformanceLog.methodStarted();
        try {
            Entity e = (Entity)super.getEntityTable(classtype).getUntyped(entityKey);
            if (e == null) throw new PersistenceException("not found");
            entity = e;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(String,String)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return entity;
        PerformanceLog.methodFinished("FileTransactionManager.get(String,String)");
        return entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MeIterator get(Query q, TreeOptionType t) throws PersistenceException {
        MeIterator meIterator;
        PerformanceLog.methodStarted();
        try {
            meIterator = super.getEntityTable(q.getClasstype()).get(q);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return meIterator;
        PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
        return meIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity get(String s, TreeOptionType t) throws PersistenceException {
        Entity entity;
        PerformanceLog.methodStarted();
        try {
            Entity e;
            MeIterator it = super.getEntityTables();
            do {
                if (it.hasNext()) continue;
                throw new PersistenceException("No entry found for key");
            } while ((e = ((EntityTable)it.next()).get(s)) == null);
            entity = e;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(String, TreeOptionType)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return entity;
        PerformanceLog.methodFinished("FileTransactionManager.get(String, TreeOptionType)");
        return entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MeIterator get(String[] s, TreeOptionType t) throws PersistenceException {
        MeIteratorArrayImpl meIteratorArrayImpl;
        PerformanceLog.methodStarted();
        try {
            Object[] result = new Entity[s.length];
            int x = 0;
            while (x < s.length) {
                result[x] = this.get(s[x], t);
                ++x;
            }
            meIteratorArrayImpl = new MeIteratorArrayImpl(result);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.modify(String[], TreeOptionType) - DEPRECATED");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return meIteratorArrayImpl;
        PerformanceLog.methodFinished("FileTransactionManager.modify(String[], TreeOptionType) - DEPRECATED");
        return meIteratorArrayImpl;
    }

    public void registerEntityFactory(PackageEntityFactory entityFactory) {
        PerformanceLog.methodStarted();
        try {
            String[] classtypes = entityFactory.getPersistenceMaster().getClasstypes();
            int x = 0;
            while (x < classtypes.length) {
                this.entityFactories.put(classtypes[x], entityFactory);
                ++x;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.register(EntityFactory)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.register(EntityFactory)");
        }
    }

    private final void prepareChange(String type, String key, Entity e, TreeOptionType t, PersistenceOperationType op, boolean dynamicallyDefineThisEntityOp) throws PersistenceException {
        ClassDescriptor cdes = this.runtime.getClassDescriptor(type);
        this.prepareChange(cdes, key, (Object)e, t, op, dynamicallyDefineThisEntityOp);
    }

    Entity get(ClassDescriptor cdes, String entityKey) throws PersistenceException {
        Entity entity;
        try {
            entity = ((EntityTable)super.getEntityTable(cdes)).get(entityKey);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (PerformanceLog.isOn()) {
                // empty if block
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            // empty if block
        }
        return entity;
    }

    AbstractEntityTable createEntityTable(ClassDescriptor cdes, File fileBase) {
        PackageEntityFactory entityFactory = (PackageEntityFactory)this.entityFactories.get(cdes.getClasstype());
        return new EntityTable(this, cdes, fileBase, entityFactory);
    }
}

