/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.Transaction;
import com.sap.ip.me.api.persist.core.TransactionType;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.persist.fileio.FileTransactionManager;

final class FileTransaction
implements Transaction {
    private final FileTransactionManager transactionManager;
    private boolean isActive;
    private TransactionType type;

    FileTransaction(FileTransactionManager transactionManager, TransactionType type) {
        this.transactionManager = transactionManager;
        this.type = type;
        this.isActive = true;
    }

    public void commit() throws PersistenceException {
        if (!this.isActive) {
            throw new PersistenceException("Transaction not active");
        }
        this.transactionManager.commit();
        this.isActive = false;
    }

    public void rollback() throws PersistenceException {
        PerformanceLog.methodStarted();
        try {
            if (!this.isActive) {
                throw new PersistenceException("Transaction not active");
            }
            this.transactionManager.rollback();
            this.isActive = false;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransaction.rollback()");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransaction.rollback()");
        }
    }

    TransactionType getType() {
        return this.type;
    }
}

