/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObjectFactory;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.persist.fileio.AbstractEntityTable;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.EntityTable2;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import com.sap.ip.me.persist.fileio.PersistenceRuntimeImpl;
import java.io.File;
import java.util.Enumeration;

public final class FilePersistenceManager
extends AbstractFileTransactionManager
implements PersistenceManager,
PersistedObjectFactory {
    private static final Configuration CONFIG = Configuration.getInstance();
    private EntityFactory entityFactory;
    private boolean errorFlag = false;

    public FilePersistenceManager(ConversationId convId, PersistenceRuntimeImpl runtime) throws PersistenceException {
        super(convId, runtime);
    }

    public PersistedObjectFactory getPersistedObjectFactory() {
        return this;
    }

    public void delete(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        boolean success = false;
        try {
            this.prepareChange(entity, treeOption, PersistenceOperationType.DELETE);
            success = true;
            Object var5_4 = null;
            boolean bl = this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boolean bl = this.errorFlag = !success;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.delete(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.delete(Entity, TreeOptionType)");
        }
    }

    public void modify(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        boolean success = false;
        try {
            this.prepareChange(entity, treeOption, PersistenceOperationType.MODIFY);
            success = true;
            Object var5_4 = null;
            boolean bl = this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boolean bl = this.errorFlag = !success;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.modify(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.modify(Entity, TreeOptionType)");
        }
    }

    public final void commit() throws PersistenceException {
        if (this.errorFlag) {
            this.rollback();
            throw new PersistenceException("Commit() was called after errors in transaction. Transaction has been rolled back.");
        }
        Enumeration e = this.entityTables.elements();
        while (e.hasMoreElements()) {
            ((AbstractEntityTable)e.nextElement()).commit();
        }
    }

    public void rollback() {
        try {
            Enumeration e = this.entityTables.elements();
            while (e.hasMoreElements()) {
                ((AbstractEntityTable)e.nextElement()).rollback();
            }
            this.errorFlag = false;
        }
        catch (PersistenceException e) {
            throw new NestableRuntimeException(e);
        }
    }

    public void update(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        boolean success = false;
        try {
            PersistedObjectImpl o = (PersistedObjectImpl)entity.getPersistedObject();
            if (!this.contains(o.getClassDescriptor(), o.getKey())) {
                this.prepareChange(entity, treeOption, PersistenceOperationType.INSERT);
            } else {
                this.prepareChange(entity, treeOption, PersistenceOperationType.MODIFY);
            }
            success = true;
            Object var6_5 = null;
            boolean bl = this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl = this.errorFlag = !success;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.update(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.update(Entity, TreeOptionType)");
        }
    }

    public void insert(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        boolean success = false;
        try {
            this.prepareChange(entity, treeOption, PersistenceOperationType.INSERT);
            success = true;
            Object var5_4 = null;
            boolean bl = this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boolean bl = this.errorFlag = !success;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.insert(Entity, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.insert(Entity, TreeOptionType)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ClassDescriptor cdes, String entityKey) throws PersistenceException {
        boolean bl;
        PerformanceLog.methodStarted();
        try {
            bl = super.getEntityTable(cdes).contains(entityKey);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.contains(String, String)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return bl;
        PerformanceLog.methodFinished("FileTransactionManager.contains(String, String)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCount(Query q) throws PersistenceException {
        int n;
        PerformanceLog.methodStarted();
        try {
            ClassDescriptor cdes = this.runtime.getClassDescriptor(q.getClasstype());
            n = super.getEntityTable(cdes).getCount(q);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return n;
        PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
        return n;
    }

    public PersistableEntity get(ClassDescriptor cdes, String entityKey) throws PersistenceException {
        return ((EntityTable2)super.getEntityTable(cdes)).get(entityKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MeIterator get(Query q) throws PersistenceException {
        MeIterator meIterator;
        PerformanceLog.methodStarted();
        try {
            meIterator = super.getEntityTable(q.getClasstype()).get(q);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!PerformanceLog.isOn()) throw throwable;
            PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
            throw throwable;
        }
        if (!PerformanceLog.isOn()) return meIterator;
        PerformanceLog.methodFinished("FileTransactionManager.get(Query, TreeOptionType)");
        return meIterator;
    }

    public void registerEntityFactory(EntityFactory f) {
        this.entityFactory = f;
    }

    public boolean entityFactoryIsRegistered() {
        return this.entityFactory != null;
    }

    public PersistenceContainer createPersistedObject(ClassDescriptor d, String s) {
        return super.getEntityTable(d).getObjectTable().createPersistedObject(s);
    }

    public PersistenceContainer createPersistedObject(PersistenceContainer o) {
        return PersistedObjectImpl.createTransient((PersistedObjectImpl)o, o.getKey());
    }

    public PersistenceContainer createPersistedObject(PersistenceContainer o, String s) {
        return PersistedObjectImpl.createTransient((PersistedObjectImpl)o, s);
    }

    public void deleteAll(ClassDescriptor cdes, TreeOptionType treeOption) throws PersistenceException {
        PerformanceLog.methodStarted();
        boolean success = false;
        try {
            MeIterator allEnt = ((EntityTable2)this.getEntityTable(cdes)).getAll();
            while (allEnt.hasNext()) {
                this.delete((PersistableEntity)allEnt.next(), treeOption);
            }
            success = true;
            Object var6_5 = null;
            boolean bl = this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl = this.errorFlag = !success;
            if (PerformanceLog.isOn()) {
                PerformanceLog.methodFinished("FileTransactionManager.deleteAll(String, TreeOptionType)");
            }
            throw throwable;
        }
        if (PerformanceLog.isOn()) {
            PerformanceLog.methodFinished("FileTransactionManager.deleteAll(String, TreeOptionType)");
        }
    }

    public MeIterator getAll(ClassDescriptor cdes) throws PersistenceException {
        boolean success = false;
        try {
            MeIterator ret = super.getEntityTable(cdes).getAll();
            success = true;
            MeIterator meIterator = ret;
            Object var6_5 = null;
            this.errorFlag = !success;
            return meIterator;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.errorFlag = !success;
            throw throwable;
        }
    }

    AbstractEntityTable createEntityTable(ClassDescriptor cdes, File fileBase) {
        return new EntityTable2(this, cdes, fileBase, this.entityFactory);
    }

    private final void prepareChange(PersistableEntity e, TreeOptionType t, PersistenceOperationType op) throws PersistenceException {
        ClassDescriptor type = ((PersistedObjectImpl)e.getPersistedObject()).getClassDescriptor();
        String key = e.getPersistedObject().getKey();
        boolean exists = this.contains(type, key);
        if (op == PersistenceOperationType.INSERT) {
            if (exists) {
                throw new PersistenceException("No insertion possible; entity with key {0} has already been inserted", new Object[]{key});
            }
        } else if (!exists) {
            throw new PersistenceException("No deletion possible; entity with key {0} has not yet been inserted", new Object[]{key});
        }
        super.prepareChange(type, key, e, t, op, false);
    }

    public void beginTransaction(boolean doWait) throws PersistenceException {
        throw new PersistenceException("No direct access to FilePersistenceManager allowed");
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params, int startIdx, int maxCount) throws PersistenceException {
        throw new PersistenceException("Join Query not supported for File I/O");
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params) throws PersistenceException {
        throw new PersistenceException("Join Query not supported for File I/O");
    }

    public JQueryResult executeQuery(JQuery query, int startIdx, int maxCount) throws PersistenceException {
        throw new PersistenceException("Join Query not supported for File I/O");
    }

    public JQueryResult executeQuery(JQuery query) throws PersistenceException {
        throw new PersistenceException("Join Query not supported for File I/O");
    }
}

