/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.core.MeBitSet;
import com.sap.ip.me.persist.fileio.ObjectTable;
import java.util.Vector;

class FileIOQuery
implements Query {
    private long lastModCounter = -1L;
    private int resultCount;
    private MeBitSet nonTxResult;
    private Vector txResult;
    private final Query q;

    FileIOQuery(Query q) {
        this.q = q;
    }

    public MeBitSet getNonTxResult() {
        return this.nonTxResult;
    }

    public Vector getTxResult() {
        return this.txResult;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public int execute(ObjectTable ot, long lastModCounter) throws PersistenceException {
        if (this.lastModCounter != lastModCounter) {
            this.prepareExecution();
            this.nonTxResult = ot.getNonTxQueryResult(this);
            this.txResult = ot.getTxQueryResult(this);
            this.resultCount = 0;
            int i = this.nonTxResult.nextSetBit(0);
            while (i >= 0) {
                ++this.resultCount;
                i = this.nonTxResult.nextSetBit(i + 1);
            }
            this.resultCount += this.txResult.size();
            this.lastModCounter = lastModCounter;
        }
        return this.resultCount;
    }

    public String getClasstype() {
        return this.q.getClasstype();
    }

    public Condition getCondition() {
        return this.q.getCondition();
    }

    public int getMaxResults() {
        return this.q.getMaxResults();
    }

    public SortOrder getSortOrder() {
        return this.q.getSortOrder();
    }

    public int getStartIndex() {
        return this.q.getStartIndex();
    }

    public void prepareExecution() throws PersistenceException {
        this.q.prepareExecution();
    }
}

