/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PackageEntityFactory;
import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.persist.fileio.AbstractEntityTable;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import java.io.File;

final class EntityTable
extends AbstractEntityTable {
    private final PackageEntityFactory factory;

    EntityTable(AbstractFileTransactionManager txMan, ClassDescriptor cdes, File fileBase, PackageEntityFactory factory) {
        super(txMan, cdes, fileBase);
        this.factory = factory;
    }

    Entity get(String key) throws PersistenceException {
        return (Entity)super.getUntyped(key);
    }

    final void rollbackEntity(PersistedObject o) throws PersistenceException {
        ((Entity)this.CACHE.get(o)).setInstance(o);
    }

    void prepareChange(String key, Object e, PersistenceOperationType op, PersistenceOperationType subOp, TreeOptionType t) throws PersistenceException {
        if (op != PersistenceOperationType.NOOPER) {
            this.hasBeenChangedInCurrentTx = true;
            PersistedObjectImpl o = this.OBJ_TAB.getPersistedObjectForChange(((Entity)e).getEntityKey(), op);
            this.OBJ_TAB.prepareChange(o, key, op);
            ((Entity)e).getInstance(o);
            if (op == PersistenceOperationType.INSERT) {
                if (this.CACHE.put(o, e) != null) {
                    throw new PersistenceException("inconsistent");
                }
            } else if (op == PersistenceOperationType.DELETE) {
                this.CACHE_DELETED_IN_CURRENT_TX.put(o, e);
                if (this.CACHE.remove(o) == null) {
                    throw new PersistenceException("inconsistent");
                }
            }
            if (this.ENTITY_MAY_HAVE_LINKS) {
                this.TX_MAN.prepareChangeForLinkedEntities(o, t, subOp);
            }
        }
    }

    final Object createEntity(Object obj0) {
        PersistedObject obj = (PersistedObject)obj0;
        Entity ent = this.factory.createEntity(obj.getEntityKey(), obj.getClasstype(), obj.getAttributes());
        try {
            ent.setInstance(obj);
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e.toString());
        }
        return ent;
    }
}

