/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;

final class AttributePosition {
    final AttributeType type;
    final int offset;
    final int singleByteLen;
    final int totalByteLen;
    final int len;
    final int dec;
    final int mult;

    AttributePosition(AttributeDescriptor ades, int offset) {
        this.type = ades.getType();
        this.len = ades.getLength();
        this.dec = ades.getDecimals();
        this.mult = ades.getMultiple();
        this.offset = offset;
        this.singleByteLen = this.type.toByteLen(this.len, this.dec);
        this.totalByteLen = this.singleByteLen * this.mult;
    }

    Object toValue(byte[] b) {
        return this.toValue(b, this.offset);
    }

    Object toValue(byte[] b, int offset) {
        if (this.mult == 1) {
            return this.type.toValue(b, offset);
        }
        Object[] o = new Object[this.mult];
        int x = 0;
        while (x < this.mult) {
            o[x] = this.type.toValue(b, offset);
            offset += this.singleByteLen;
            ++x;
        }
        return o;
    }

    Object toValueFromSingle(byte[] b, int idx) {
        return this.toValueFromSingle(b, this.offset, idx);
    }

    Object toValueFromSingle(byte[] b, int offset, int idx) {
        if (this.mult <= 1) {
            throw new IllegalArgumentException("mal-reading from single attribute");
        }
        return this.type.toValue(b, offset + this.singleByteLen * idx);
    }

    void toByte(Object o, byte[] b) {
        this.toByte(o, b, this.offset);
    }

    void toByteForSingle(Object o, byte[] b, int pos) {
        this.toByteForSingle(o, b, this.offset, pos);
    }

    void toByte(Object o, byte[] b, int offset) {
        if (this.mult == 1) {
            this.type.toByte(b, offset, o, this.singleByteLen, this.dec);
        } else {
            Object[] o1 = (Object[])o;
            if (o == null) {
                o1 = new Object[this.mult];
            }
            int x = 0;
            while (x < this.mult) {
                this.type.toByte(b, offset, o1[x], this.singleByteLen, this.dec);
                offset += this.singleByteLen;
                ++x;
            }
        }
    }

    void toByteForSingle(Object o, byte[] b, int offset, int pos) {
        if (this.mult <= 1) {
            throw new IllegalArgumentException("mal-writing into single attribute");
        }
        this.type.toByte(b, offset + this.singleByteLen * pos, o, this.singleByteLen, this.dec);
    }

    void toDefaultBytes(byte[] b) {
        Object[] defaultValue = this.type.getDefaultValue(this.len, this.dec);
        if (this.mult > 1) {
            Object[] newDefaultValue = new Object[this.mult];
            int i = 0;
            while (i < this.mult) {
                newDefaultValue[i] = defaultValue;
                ++i;
            }
            defaultValue = newDefaultValue;
        }
        this.toByte(defaultValue, b);
    }

    Object getDefaultValue() {
        return this.type.getDefaultValue(this.len, this.dec);
    }
}

