/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.MeIteratorHashImpl;
import com.sap.ip.me.persist.core.InternalTransactionManager;
import com.sap.ip.me.persist.fileio.AbstractEntityTable;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import com.sap.ip.me.persist.fileio.PersistenceRuntimeImpl;
import com.sap.ip.me.persist.fileio.RandomAccessFilePool;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class AbstractFileTransactionManager
implements InternalTransactionManager {
    private static final Configuration CONFIG = Configuration.getInstance();
    static final String NO_TRANSACTION = "No transaction";
    final PersistenceRuntimeImpl runtime;
    private final File fileBase;
    final Hashtable entityTables = new Hashtable(50);
    private boolean isAlive = true;
    private final ConversationId convId;
    private final Stack tempEntityKeyStack = new Stack();

    AbstractFileTransactionManager(ConversationId convId, PersistenceRuntimeImpl runtime) throws PersistenceException {
        this.runtime = runtime;
        this.fileBase = this.runtime.getFileBase(convId.getId());
        this.convId = convId;
    }

    public void reset() throws PersistenceException {
        if (this.isAlive) {
            RandomAccessFilePool.getInstance().finalize();
            IOUtils.deleteDirectoryRecursively(this.fileBase);
            this.runtime.removeTransactionManager(this.convId.getId());
            this.finalize();
        }
    }

    protected void finalize() {
        if (this.isAlive) {
            Enumeration e = this.entityTables.elements();
            while (e.hasMoreElements()) {
                ((AbstractEntityTable)e.nextElement()).finalize();
            }
            this.entityTables.clear();
            this.tempEntityKeyStack.removeAllElements();
            this.isAlive = false;
        }
    }

    void reinitialize() throws PersistenceException {
        Enumeration e = this.entityTables.elements();
        while (e.hasMoreElements()) {
            ((AbstractEntityTable)e.nextElement()).reinitialize();
        }
        this.tempEntityKeyStack.removeAllElements();
    }

    final Vector getLinkAsVector(ClassDescriptor srcCdes, LinkDescriptor dstLdes, int srcRowIdx) throws PersistenceException {
        Vector keys = this.getEntityTable(srcCdes).getObjectTable().getMultipleLinkTable(dstLdes).get(srcRowIdx);
        Vector<Object> res = new Vector<Object>();
        Enumeration enumeration = keys.elements();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            AbstractEntityTable linkedEntityTable = this.getEntityTable(dstLdes.getClasstype());
            Object entity = linkedEntityTable.getUntyped(key);
            if (entity == null) {
                throw new NullPointerException(key);
            }
            res.addElement(entity);
        }
        return res;
    }

    final void prepareChangeForLinkedEntities(PersistedObject obj, TreeOptionType treeOption, PersistenceOperationType op) throws PersistenceException {
        Object[] links;
        if (treeOption != TreeOptionType.SKELETON && (links = obj.getLinks()) != null) {
            LinkDescriptor[] linkDescriptors = ((PersistedObjectImpl)obj).getClassDescriptor().getLinkDescriptorArray();
            int x = 0;
            while (x < links.length) {
                if (links[x] != null && (treeOption == TreeOptionType.COMPLETE || treeOption == TreeOptionType.DEPENDENT && linkDescriptors[x].isDependent())) {
                    ClassDescriptor cdes = this.runtime.getClassDescriptor(linkDescriptors[x].getClasstype());
                    if (linkDescriptors[x].getMultiplicity() == MultiplicityType.SINGLE) {
                        this.prepareChange(cdes, links[x], treeOption, op, true);
                    } else {
                        Enumeration e = ((Vector)links[x]).elements();
                        while (e.hasMoreElements()) {
                            this.prepareChange(cdes, e.nextElement(), treeOption, op, true);
                        }
                    }
                }
                ++x;
            }
        }
    }

    final AbstractEntityTable getEntityTable(ClassDescriptor cdes) {
        AbstractEntityTable e = (AbstractEntityTable)this.entityTables.get(cdes);
        if (e == null) {
            e = this.createEntityTable(cdes, this.fileBase);
            this.entityTables.put(cdes, e);
        }
        return e;
    }

    final MeIterator getEntityTables() {
        MeIterator it = this.runtime.getAllClassDescriptors();
        while (it.hasNext()) {
            this.getEntityTable((ClassDescriptor)it.next());
        }
        return new MeIteratorHashImpl(this.entityTables);
    }

    final AbstractEntityTable getEntityTable(String type) throws PersistenceException {
        return this.getEntityTable(this.runtime.getClassDescriptor(type));
    }

    abstract AbstractEntityTable createEntityTable(ClassDescriptor var1, File var2);

    final void prepareChange(ClassDescriptor cdes, Object entity, TreeOptionType t, PersistenceOperationType op, boolean dynamicallyDefineThisEntityOp) throws PersistenceException {
        String key = entity instanceof Entity ? ((Entity)entity).getEntityKey() : ((PersistableEntity)entity).getPersistedObject().getKey();
        this.prepareChange(cdes, key, entity, t, op, dynamicallyDefineThisEntityOp);
    }

    final void prepareChange(ClassDescriptor cdes, String key, Object entity, TreeOptionType t, PersistenceOperationType normalOp, boolean dynamicallyDefineThisEntityOp) throws PersistenceException {
        if (this.tempEntityKeyStack.search(entity) != -1) {
            return;
        }
        this.tempEntityKeyStack.push(entity);
        try {
            PersistenceOperationType thisEntityOp = dynamicallyDefineThisEntityOp ? normalOp.getOnExists(this.getEntityTable(cdes).contains(key)) : normalOp;
            this.getEntityTable(cdes).prepareChange(key, entity, thisEntityOp, normalOp, t);
            Object var9_8 = null;
            this.tempEntityKeyStack.pop();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.tempEntityKeyStack.pop();
            throw throwable;
        }
    }

    final Object getUntyped(String classtype, String key) throws PersistenceException {
        return this.getEntityTable(classtype).getUntyped(key);
    }
}

