/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.ObjectTable;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

abstract class AbstractEntityTable {
    private final ClassDescriptor C_DES;
    final Hashtable CACHE;
    final AbstractFileTransactionManager TX_MAN;
    private final File FILE_BASE;
    final boolean ENTITY_MAY_HAVE_LINKS;
    private final String CLASSTYPE;
    final Hashtable CACHE_DELETED_IN_CURRENT_TX;
    boolean hasBeenChangedInCurrentTx;
    ObjectTable OBJ_TAB;

    AbstractEntityTable(AbstractFileTransactionManager txMan, ClassDescriptor cdes, File fileBase) {
        this.C_DES = cdes;
        this.CLASSTYPE = cdes.getClasstype();
        this.CACHE = new Hashtable(10);
        this.CACHE_DELETED_IN_CURRENT_TX = new Hashtable(10);
        this.TX_MAN = txMan;
        this.FILE_BASE = fileBase;
        this.ENTITY_MAY_HAVE_LINKS = cdes.getLinkDescriptorArray().length > 0;
    }

    final boolean contains(String entityKey) throws PersistenceException {
        return this.getObjectTable().contains(entityKey);
    }

    final MeIterator get(Query q) throws PersistenceException {
        return this.getEntitiesFromPersistedObjects(this.getObjectTable().get(q));
    }

    final int getCount(Query q) throws PersistenceException {
        return this.getObjectTable().getCount(q);
    }

    final MeIterator getAll() throws PersistenceException {
        MeIterator allObj = this.getObjectTable().getAll();
        return this.getEntitiesFromPersistedObjects(allObj);
    }

    private final MeIterator getEntitiesFromPersistedObjects(MeIterator persistedObjects) throws PersistenceException {
        Vector<Object> entities = new Vector<Object>(persistedObjects.elementCount());
        while (persistedObjects.hasNext()) {
            entities.addElement(this.getUntyped((PersistedObjectImpl)persistedObjects.next()));
        }
        return new MeIteratorVectorImpl(entities);
    }

    final void reinitialize() throws PersistenceException {
        this.CACHE.clear();
        this.CACHE_DELETED_IN_CURRENT_TX.clear();
        this.getObjectTable().reinitialize();
        this.hasBeenChangedInCurrentTx = false;
    }

    protected void finalize() {
        this.CACHE.clear();
        this.CACHE_DELETED_IN_CURRENT_TX.clear();
        this.hasBeenChangedInCurrentTx = false;
    }

    final void commit() throws PersistenceException {
        if (this.hasBeenChangedInCurrentTx) {
            this.getObjectTable().commit();
            this.CACHE_DELETED_IN_CURRENT_TX.clear();
            this.hasBeenChangedInCurrentTx = false;
            this.CACHE.clear();
        }
    }

    abstract void rollbackEntity(PersistedObject var1) throws PersistenceException;

    void rollback() throws PersistenceException {
        this.CACHE.clear();
        this.CACHE_DELETED_IN_CURRENT_TX.clear();
        this.getObjectTable().rollback();
    }

    final boolean hasBeenChangedInCurrentTx() {
        return this.hasBeenChangedInCurrentTx;
    }

    final ObjectTable getObjectTable() {
        if (this.OBJ_TAB == null) {
            try {
                this.OBJ_TAB = new ObjectTable(this.C_DES, this.FILE_BASE, this.TX_MAN);
            }
            catch (PersistenceException e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.OBJ_TAB;
    }

    abstract void prepareChange(String var1, Object var2, PersistenceOperationType var3, PersistenceOperationType var4, TreeOptionType var5) throws PersistenceException;

    final Object getUntyped(PersistedObject o) {
        if (o == null) {
            throw new NullPointerException("o mustn't be null");
        }
        Object entity = this.CACHE.get(o);
        if (entity == null) {
            entity = this.createEntity(o);
            this.CACHE.put(o, entity);
        }
        return entity;
    }

    final Object getUntyped(String key) throws PersistenceException {
        PersistedObject o = this.getObjectTable().get(key);
        return o != null ? this.getUntyped(o) : null;
    }

    abstract Object createEntity(Object var1);
}

