/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.db2e;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IBMDB2eStringFormatter
extends DBSqlFormatter {
    public StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof String) {
            return this.escapeString(buf, this.getEscapedString(this.getSubString((String)obj, len)), "'", "'");
        }
        throw new IllegalArgumentException("STRING: invalid value type");
    }

    public StringBuffer toSQLValueStartsWith(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj == null) {
            throw new IllegalArgumentException("starts with NULL is not allowed");
        }
        if (obj instanceof String) {
            return this.escapeString(buf, this.getPatternEscapedString(this.getSubString((String)obj, len)), "'", "%'ESCAPE'\\'");
        }
        throw new IllegalArgumentException("STRING: invalid value type");
    }

    public StringBuffer toSQLValueContains(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj == null) {
            throw new IllegalArgumentException("contains NULL is not allowed");
        }
        if (obj instanceof String) {
            return this.escapeString(buf, this.getPatternEscapedString(this.getSubString((String)obj, len)), "'%", "%'ESCAPE'\\'");
        }
        throw new IllegalArgumentException("STRING: invalid value type");
    }

    public StringBuffer toSQLValueLike(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj == null) {
            throw new IllegalArgumentException("Like NULL is not allowed");
        }
        if (obj instanceof String) {
            return this.escapeString(buf, this.getEscapedString(this.getEscapedString(this.getSubString((String)obj, len), "\\", "\\\\")), "'", "'ESCAPE'\\'");
        }
        throw new IllegalArgumentException("STRING: invalid value type");
    }

    public StringBuffer toSQLValueAsterisk(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj == null) {
            throw new IllegalArgumentException("Like NULL is not allowed");
        }
        if (obj instanceof String) {
            return this.escapeString(buf, this.replaceChar(this.getPatternEscapedString(this.getSubString((String)obj, len)), '*', '%'), "'", "'ESCAPE'\\'");
        }
        throw new IllegalArgumentException("STRING: invalid value type");
    }

    public StringBuffer toSQLValueUpper(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        return this.toSQLValueAsterisk(buf, obj, len, dec);
    }

    private final String getSubString(String str, int len) {
        if (len < str.length()) {
            Trace.getInstance("MI/Persistence").log(50, "The String {0} is too long and will be cut to length {1} for database insert", (Object)str, (Object)Integer.toString(len));
            return str.substring(0, len);
        }
        return str;
    }

    private final StringBuffer escapeString(StringBuffer buf, String str, String prefix, String postfix) {
        buf.append(prefix);
        buf.append(str);
        buf.append(postfix);
        return buf;
    }

    private final String getEscapedString(String s, String replace, String escape) {
        StringBuffer sb = new StringBuffer();
        int p_idx = 0;
        while (true) {
            int idx;
            if ((idx = s.indexOf(replace, p_idx)) == -1) break;
            sb.append(s.substring(p_idx, idx));
            sb.append(escape);
            p_idx = idx + replace.length();
        }
        sb.append(s.substring(p_idx, s.length()));
        return sb.toString();
    }

    private final String getPatternEscapedString(String s) {
        return this.getEscapedString(this.getEscapedString(this.getEscapedString(this.getEscapedString(s, "\\", "\\\\"), "_", "\\_")), "%", "\\%");
    }

    private final String getEscapedString(String s) {
        return this.getEscapedString(s, "'", "''");
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        String s = rset.getString(idx);
        if (rset.wasNull()) {
            return null;
        }
        if (s.length() > len && len > 0) {
            Trace.getInstance("MI/Persistence").log(50, "The String {0} returned by the database is too long and will be cut to length {1}", (Object)s, (Object)Integer.toString(len));
            return s.substring(0, len);
        }
        return s;
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        return buf.append("VARCHAR(").append(len * 3).append(')');
    }
}

