/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.db2e;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.DeviceConfiguration;
import com.sap.ip.me.persist.db2e.IBMDB2eRepresentorImpl;
import com.sap.ip.me.persist.jdbc.DBManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import com.sap.ip.me.persist.jdbc.DBTableManager;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class IBMDB2eManager
extends DBManager {
    private static Connection connection;
    private boolean isEncrypted;
    private static final String ENCODING_PROP = "DB2e_ENCODING";
    private static final String USER_PROP = "user";
    private static final String PASS_PROP = "password";
    private static final String PARSE_STR = "%d";

    private String replace(String source, String parseString, String replaceString) {
        int index = source.indexOf(parseString);
        String ret = source;
        while (index != -1) {
            StringBuffer sb = new StringBuffer(ret.length());
            sb.append(ret.substring(0, index)).append(replaceString);
            sb.append(ret.substring(index + parseString.length(), ret.length()));
            ret = sb.toString();
            index = ret.indexOf(parseString);
        }
        return ret;
    }

    public Connection getConnection() throws SQLException {
        if (connection == null) {
            try {
                Class.forName(super.getDriverClassName()).newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException(t.toString());
            }
            String url = this.replace(super.getDBUrl(), PARSE_STR, super.getRootDir().getAbsolutePath() + File.separator);
            String user = super.getUserName();
            String password = super.getPassword();
            connection = this.getConnection(url, user, password);
            DatabaseMetaData dbMeta = connection.getMetaData();
            StringBuffer temp = new StringBuffer(80);
            temp.append(dbMeta.getDatabaseProductName());
            temp.append(" ");
            temp.append(dbMeta.getDatabaseProductVersion());
            StringBuffer sb = new StringBuffer("Connected to Database: ");
            sb.append(temp.toString());
            sb.append(" JDBC ");
            sb.append(dbMeta.getDriverVersion());
            DeviceConfiguration.setInformation("DATABASE_FULLNAME", temp.toString());
            Trace.getInstance("MI/Persistence").log(70, sb.toString());
            this.encryptionGrant(connection, user, password);
            connection.setAutoCommit(false);
        }
        return connection;
    }

    private Connection getConnection(String url, String user, String password) throws SQLException {
        Properties p = new Properties();
        ((Hashtable)p).put(ENCODING_PROP, "UTF8");
        ((Hashtable)p).put(USER_PROP, user);
        ((Hashtable)p).put(PASS_PROP, password);
        return DriverManager.getConnection(url, p);
    }

    private void encryptionGrant(Connection connection, String user, String password) throws SQLException {
        if (super.isEncrypted()) {
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate(this.getEncryptionGrantSQL(user, password));
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                statement.close();
                throw throwable;
            }
            statement.close();
            {
            }
        }
    }

    private String getEncryptionGrantSQL(String user, String password) {
        StringBuffer encryptionGrantSql = new StringBuffer(200);
        encryptionGrantSql.append("GRANT ENCRYPT ON DATABASE TO \"");
        encryptionGrantSql.append(user).append("\" USING \"").append(password).append("\" NEW \"").append(password).append("\"");
        return encryptionGrantSql.toString();
    }

    protected DBPersistenceManager createConcreteTransactionManager(DBTableMap tableMap) {
        return new DBPersistenceManagerImpl(tableMap, this, this);
    }

    protected DBTableManager createTableAdmin() throws SQLException {
        return new DBTableManager(new IBMDB2eRepresentorImpl(this, this));
    }

    public void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
            connection = null;
            Trace.getInstance("MI/Persistence").log(70, "Connection to DB2e was closed");
        }
    }

    public Connection restoreConnection() throws SQLException {
        if (connection != null) {
            try {
                connection.close();
                Trace.getInstance("MI/Persistence").log(70, "Connection to DB2e was closed");
            }
            catch (SQLException e) {
                Trace.getInstance("MI/Persistence").logException("Connection could not be closed", (Throwable)e, false);
            }
            connection = null;
        }
        return this.getConnection();
    }
}

