/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.db2e;

import com.sap.ip.me.api.services.DateFormatter;
import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class IBMDB2eDateFormatter
extends DBSqlFormatter {
    public final StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof Calendar) {
            buf.append("'");
            buf.append(IBMDB2eDateFormatter.getDateTime((Calendar)obj));
            buf.append("'");
            return buf;
        }
        if (obj instanceof Date) {
            buf.append("'");
            buf.append(DateFormatter.getDate((Date)obj));
            buf.append("'");
            return buf;
        }
        throw new IllegalArgumentException("DATE: invalid value type");
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        Timestamp ts = rset.getTimestamp(idx);
        if (rset.wasNull()) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(ts);
        c.set(14, ts.getNanos() / 1000000);
        return c;
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        return buf.append("TIMESTAMP");
    }

    public static synchronized String getDateTime(Calendar c) {
        StringBuffer buf = new StringBuffer(23);
        buf.append(IBMDB2eDateFormatter.format(String.valueOf(c.get(1)), 4, '0'));
        buf.append("-").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(2) + 1), 2, '0'));
        buf.append("-").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(5)), 2, '0'));
        buf.append("-").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(11)), 2, '0'));
        buf.append(".").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(12)), 2, '0'));
        buf.append(".").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(13)), 2, '0'));
        buf.append(".").append(IBMDB2eDateFormatter.format(String.valueOf(c.get(14)), 3, '0'));
        buf.append("000");
        return buf.toString();
    }

    private static String format(String s, int length, char fill) {
        StringBuffer sb = new StringBuffer(length - s.length());
        int i = 0;
        while (i < length - s.length()) {
            sb.append(fill);
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }
}

