/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.Transaction;

public class TXWrapperBase {
    private static final Object LOCK = new Object();
    private static Object owner = null;
    private Object impl;
    private boolean closed;
    private boolean isPersistenceManager = true;

    public TXWrapperBase(Transaction impl) {
        this.impl = impl;
        this.closed = false;
        this.isPersistenceManager = false;
    }

    public TXWrapperBase(PersistenceManager impl) {
        this.impl = impl;
        this.closed = false;
    }

    void setCurrentTransaction(Transaction trans) {
        this.impl = trans;
    }

    Transaction getCurrentTransaction() {
        return (Transaction)this.impl;
    }

    public void beginTransaction(boolean doWait) throws PersistenceException {
        if (this.closed) {
            Trace.getInstance("MI/Persistence").log(50, "PersistenceManager is not reusable after commit() or rollback()");
            throw new PersistenceException("PersistenceManager is not reusable after commit() or rollback()");
        }
        Object object = LOCK;
        synchronized (object) {
            if (owner == this) {
                return;
            }
            while (true) {
                StringBuffer sb;
                if (owner == null) {
                    if (Trace.getInstance("MI/Persistence").isOn()) {
                        sb = new StringBuffer("beginTransaction() called with doWait=");
                        sb.append(doWait);
                        sb.append(" for instance ");
                        sb.append(this.hashCode());
                        Trace.getInstance("MI/Persistence").log(90, sb.toString());
                    }
                    owner = this;
                    return;
                }
                if (!doWait) {
                    Trace.getInstance("MI/Persistence").log(50, "NESTED TRANSACTION ERROR: A transaction has already been started");
                    throw new PersistenceException("nested transaction not supported by TransactionManager");
                }
                try {
                    if (Trace.getInstance("MI/Persistence").isOn()) {
                        sb = new StringBuffer("PersistenceManager instance is waiting: ");
                        sb.append(this.hashCode());
                        Trace.getInstance("MI/Persistence").log(90, sb.toString());
                    }
                    LOCK.wait();
                }
                catch (InterruptedException e) {
                    Trace.getInstance("MI/Persistence").logException("Waiting PersistenceManager was interrupted", (Throwable)e, true);
                }
            }
        }
    }

    public void assertTransaction() throws PersistenceException {
        if (owner == this) {
            return;
        }
        PersistenceException e = new PersistenceException("A read Transaction has not been started. Use beginTransaction() before read access!");
        Trace.getInstance("MI/Persistence").log("A read Transaction has not been started!");
        throw e;
    }

    public void commit() throws PersistenceException {
        if (Trace.getInstance("MI/Persistence").isOn()) {
            Trace.getInstance("MI/Persistence").log(90, "commit() called on instance " + this.hashCode());
        }
        Object object = LOCK;
        synchronized (object) {
            if (owner == null) {
                if (this.isPersistenceManager) {
                    this.closed = true;
                }
                return;
            }
            if (owner == this) {
                owner = null;
                if (!this.isPersistenceManager) {
                    ((Transaction)this.impl).commit();
                    this.impl = null;
                } else {
                    ((PersistenceManager)this.impl).commit();
                }
            } else {
                throw new PersistenceException("commit() was called by a non active PersistenceManager");
            }
            LOCK.notify();
        }
        if (this.isPersistenceManager) {
            this.closed = true;
        }
    }

    public void rollback() throws PersistenceException {
        if (Trace.getInstance("MI/Persistence").isOn()) {
            Trace.getInstance("MI/Persistence").log(90, "rollback() called on instance " + this.hashCode());
        }
        Object object = LOCK;
        synchronized (object) {
            if (owner == null) {
                if (this.isPersistenceManager) {
                    this.closed = true;
                }
                return;
            }
            if (owner == this) {
                owner = null;
                if (!this.isPersistenceManager) {
                    ((Transaction)this.impl).rollback();
                    this.impl = null;
                } else {
                    ((PersistenceManager)this.impl).rollback();
                }
            } else {
                throw new PersistenceException("rollback() was called by a non active PersistenceManager");
            }
            LOCK.notify();
        }
        if (this.isPersistenceManager) {
            this.closed = true;
        }
    }
}

