/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.persist.core.PrioritizableSingleCondition;

public class SingleConditionImpl
implements PrioritizableSingleCondition {
    private static final int NONINDEX_PRIORITY = 0;
    private static final int INDEX_PRIORITY = 100;
    final RelationalOperatorType relationalOperator;
    final Object value;
    final AttributeDescriptor attribute;
    final MeComparator comparator;
    ClassDescriptor cdes;

    public SingleConditionImpl(AttributeDescriptor attribute, RelationalOperatorType relationalOperator, Object value) {
        this.attribute = attribute;
        this.relationalOperator = relationalOperator;
        this.value = value;
        this.comparator = attribute.getType();
    }

    public RelationalOperatorType getRelationalOperator() {
        return this.relationalOperator;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isComposite() {
        return false;
    }

    public AttributeDescriptor getAttributeDescriptor() {
        return this.attribute;
    }

    public void prepareExecution(ClassDescriptor classDescriptor) {
        this.cdes = classDescriptor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.attribute.getName());
        sb.append(" ");
        if (this.relationalOperator != RelationalOperatorType.STARTS_WITH && this.relationalOperator != RelationalOperatorType.CONTAINS) {
            sb.append(this.relationalOperator);
            sb.append(" '");
            sb.append(this.value);
            sb.append("' ");
        } else {
            sb.append(" LIKE '");
            if (this.relationalOperator == RelationalOperatorType.CONTAINS) {
                sb.append("%");
            }
            sb.append(this.value);
            sb.append("%' ");
        }
        return sb.toString();
    }

    public boolean matches(PersistedObject obj) throws PersistenceException {
        Object objValue = obj.getAttribute(this.cdes.getAttributePosition(this.attribute.getName()));
        return this.matches(objValue);
    }

    public boolean matches(Object objValue) {
        if (this.relationalOperator == RelationalOperatorType.EQUALS) {
            return this.comparator.compare(objValue, this.value) == 0;
        }
        if (this.relationalOperator == RelationalOperatorType.NOT_EQUALS) {
            return this.comparator.compare(objValue, this.value) != 0;
        }
        if (this.relationalOperator == RelationalOperatorType.LOWER_THAN) {
            return this.comparator.compare(objValue, this.value) < 0;
        }
        if (this.relationalOperator == RelationalOperatorType.GREATER_THAN) {
            return this.comparator.compare(objValue, this.value) > 0;
        }
        if (this.relationalOperator == RelationalOperatorType.STARTS_WITH) {
            if (objValue instanceof String && this.value instanceof String) {
                return ((String)objValue).startsWith((String)this.value);
            }
            return false;
        }
        if (this.relationalOperator == RelationalOperatorType.CONTAINS) {
            if (objValue instanceof String && this.value instanceof String) {
                return ((String)objValue).indexOf((String)this.value) != -1;
            }
            return false;
        }
        throw new RuntimeException("unsupported relational operator type " + this.relationalOperator);
    }

    public int getPriority() {
        if (this.attribute.isIndex()) {
            return 100;
        }
        return 0;
    }
}

