/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.InternalQueryRuntime;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.persist.core.CompositeConditionImpl;
import com.sap.ip.me.persist.core.MultipleSortOrderImpl;
import com.sap.ip.me.persist.core.QueryImpl;
import com.sap.ip.me.persist.core.SingleConditionImpl;
import com.sap.ip.me.persist.core.SingleSortOrderImpl;

public final class QueryRuntimeImpl
implements InternalQueryRuntime {
    private static final PersistenceRuntime PERSISTENCE_RUNTIME = PersistenceRuntime.getInstance();

    public Condition createCondition(AttributeDescriptor attribute, RelationalOperatorType relationalOperator, Object value) {
        return new SingleConditionImpl(attribute, relationalOperator, value);
    }

    public Condition createCondition(Condition[] conditions, LogicalOperatorType logicalOperator) {
        return new CompositeConditionImpl(conditions, logicalOperator);
    }

    public SortOrder createSortOrder(AttributeDescriptor attribute, boolean isAscending) {
        return new SingleSortOrderImpl(attribute, isAscending);
    }

    public SortOrder createSortOrder(SortOrder[] sortOrders) {
        return new MultipleSortOrderImpl(sortOrders);
    }

    public Query createQuery(String classtype, Condition condition) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), condition, null, -1, -1);
    }

    public Query createQuery(String classtype, Condition condition, SortOrder sortOrder) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), condition, sortOrder, -1, -1);
    }

    public Query createQuery(String classtype, Condition condition, int maxResults) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), condition, null, -1, maxResults);
    }

    public Query createQuery(String classtype, SortOrder sortOrder, int startIndex, int maxResults) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), null, sortOrder, startIndex, maxResults);
    }

    public Query createQuery(String classtype, Condition condition, SortOrder sortOrder, int maxResults) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), condition, sortOrder, -1, maxResults);
    }

    public Query createQuery(String classtype, Condition condition, SortOrder sortOrder, int startIdx, int maxResults) throws PersistenceException {
        return new QueryImpl(PERSISTENCE_RUNTIME.getClassDescriptor(classtype), condition, sortOrder, startIdx, maxResults);
    }
}

