/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.logging.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class PersistenceLog {
    public static final void log(Class calledClass, String calledMethod, Object[] params, boolean getCaller) {
        if (PersistenceLog.isLogging()) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("Persistence / CALLED: ");
            sb.append(calledClass);
            sb.append(".");
            sb.append(calledMethod);
            if (params != null && params.length > 0) {
                sb.append(" / PARAMETERS: ");
                int x = 0;
                while (x < params.length) {
                    if (params[x] instanceof Object[]) {
                        sb.append("[ ");
                        Object[] paramsx = (Object[])params[x];
                        int y = 0;
                        while (y < paramsx.length) {
                            sb.append(paramsx[y]);
                            sb.append(" ,");
                            ++y;
                        }
                        sb.append(" ]");
                    } else {
                        sb.append(params[x]);
                    }
                    sb.append(" ,");
                    ++x;
                }
            } else {
                sb.append(" / NO PARAMETERS");
            }
            if (getCaller) {
                sb.append(" / CALLER: ");
                sb.append(PersistenceLog.getCallerMethod(calledClass.getName()));
            }
            Trace.getInstance("MI/Persistence").log(90, sb.toString());
        }
    }

    public static final void log(Class calledClass, String calledMethod, Object[] params) {
        PersistenceLog.log(calledClass, calledMethod, params, false);
    }

    public static final void log(Class calledClass, String calledMethod) {
        PersistenceLog.log(calledClass, calledMethod, null, false);
    }

    private static final String getCallerMethod(String className) {
        StringWriter writer = new StringWriter();
        Throwable t = new Throwable();
        t.printStackTrace(new PrintWriter((Writer)writer, true));
        StringBuffer buffer = writer.getBuffer();
        StringBuffer line = new StringBuffer();
        int length = buffer.length();
        boolean found = false;
        int state = 0;
        int i = 0;
        while (i < length) {
            char ch = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if ('\n' != ch) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if ('t' != ch) break;
                    state = 2;
                    break;
                }
                case 2: {
                    line.setLength(0);
                    state = 3;
                    break;
                }
                case 3: {
                    if ('\n' != ch && '\r' != ch) {
                        line.append(ch);
                        break;
                    }
                    String method = line.toString();
                    boolean match = method.startsWith(className);
                    if (!found && match) {
                        found = true;
                    } else if (found && !match) {
                        return method;
                    }
                    state = 1;
                }
            }
            ++i;
        }
        return "";
    }

    public static boolean isLogging() {
        return false;
    }
}

