/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.AbstractMeComparator;
import com.sap.ip.me.persist.core.EntityPersistedPair;

public class EntityPersistedPairComparator
extends AbstractMeComparator {
    private final SortOrder sortOrder;
    private final ClassDescriptor desc;

    public EntityPersistedPairComparator(PersistenceRuntime runtime, Query query) throws PersistenceException {
        this(runtime, query.getClasstype(), query.getSortOrder());
    }

    public EntityPersistedPairComparator(PersistenceRuntime runtime, String classtype, SortOrder sortOrder) throws PersistenceException {
        this(runtime.getClassDescriptor(classtype), sortOrder);
    }

    public EntityPersistedPairComparator(ClassDescriptor desc, SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this.desc = desc;
    }

    public EntityPersistedPairComparator() {
        this.sortOrder = null;
        this.desc = null;
    }

    private int compareByKey(Object o1, Object o2) {
        String k1 = o1 instanceof EntityPersistedPair ? ((EntityPersistedPair)o1).entity.getEntityKey() : (String)o1;
        String k2 = o2 instanceof EntityPersistedPair ? ((EntityPersistedPair)o2).entity.getEntityKey() : (String)o2;
        return k1.compareTo(k2);
    }

    public int compare(Object o1, Object o2, SortOrder sortOrder) {
        if (sortOrder == null) {
            return this.compareByKey(o1, o2);
        }
        if (!sortOrder.isMultiple()) {
            Object vo2;
            SingleSortOrder singleSortOrder = (SingleSortOrder)sortOrder;
            Object vo1 = o1 instanceof EntityPersistedPair ? ((EntityPersistedPair)o1).object.getAttribute(this.desc.getPosition(singleSortOrder.getAttributeDescriptor())) : o1;
            Object object = vo2 = o2 instanceof EntityPersistedPair ? ((EntityPersistedPair)o2).object.getAttribute(this.desc.getPosition(singleSortOrder.getAttributeDescriptor())) : o2;
            if (singleSortOrder.isAscending()) {
                return this.compareTo(vo2, vo1);
            }
            return this.compareTo(vo1, vo2);
        }
        MultipleSortOrder multipleSortOrder = (MultipleSortOrder)sortOrder;
        MeIterator itr = multipleSortOrder.getSortOrders();
        while (itr.hasNext()) {
            SortOrder sub_sortOrder = (SortOrder)itr.next();
            int sub_ret = this.compare(o1, o2, sub_sortOrder);
            if (sub_ret == 0) continue;
            return sub_ret;
        }
        return 0;
    }

    public int compare(Object o1, Object o2) {
        return this.compare(o1, o2, this.sortOrder);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }
}

