/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import java.util.Hashtable;

public class EntityCache {
    private final Hashtable hash = new Hashtable(100);

    public void put(Entity entity, TreeOptionType tree) {
        String entityKey = entity.getEntityKey();
        EntityTreeWrapper ew = (EntityTreeWrapper)this.hash.get(entityKey);
        if (ew == null) {
            this.hash.put(entityKey, new EntityTreeWrapper(entity, tree));
        } else {
            ew.entity = entity;
            if (ew.tree.toInt() < tree.toInt()) {
                ew.tree = tree;
            }
        }
    }

    public Entity get(String entityKey) {
        return this.contains(entityKey) ? ((EntityTreeWrapper)this.hash.get(entityKey)).entity : null;
    }

    public TreeOptionType getTree(String entityKey) {
        return this.contains(entityKey) ? ((EntityTreeWrapper)this.hash.get(entityKey)).tree : null;
    }

    public void remove(String entityKey) {
        this.hash.remove(entityKey);
    }

    public boolean contains(String entityKey) {
        return this.hash.containsKey(entityKey);
    }

    private static final class EntityTreeWrapper {
        private Entity entity;
        private TreeOptionType tree;

        private EntityTreeWrapper(Entity entity, TreeOptionType tree) {
            this.entity = entity;
            this.tree = tree;
        }
    }
}

