/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.core.AttributeDescriptorImpl;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.core.InternalDescriptorRuntime;
import com.sap.ip.me.persist.core.LinkDescriptorImpl;
import java.util.Hashtable;

public class DescriptorRuntimeImpl
extends DescriptorRuntime
implements InternalDescriptorRuntime {
    private static final AttributeDescriptor[] EMPTY_ATTRIBS = new AttributeDescriptor[0];
    private static final LinkDescriptor[] EMPTY_LINKS = new LinkDescriptor[0];
    private final Hashtable classDescriptors = new Hashtable();
    private final int DEFAULT_KEY_LEN;
    private static final String DEFAULT_KEYNAME = "PKEY";
    private static final AttributeType DEFAULT_KEYTYPE = AttributeType.STRING;

    public DescriptorRuntimeImpl() {
        int keyLen = 0;
        try {
            keyLen = Integer.parseInt(Configuration.getInstance().getProperty("MobileEngine.Persist.DefaultKeyLength"));
        }
        catch (Throwable t) {
            Trace.getInstance("MI/Persistence").log("Cannot obtain default key length, taking 128 as default");
        }
        this.DEFAULT_KEY_LEN = keyLen > 0 ? keyLen : 128;
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length) throws DescriptorException {
        return this.createAttributeDescriptor(name, type, mult, length, 0, false);
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length, boolean isIndex) throws DescriptorException {
        return this.createAttributeDescriptor(name, type, mult, length, 0, isIndex);
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length, int dec, boolean isIndex) throws DescriptorException {
        return new AttributeDescriptorImpl(name, type, mult, length, dec, isIndex);
    }

    public LinkDescriptor createLinkDescriptor(String name, String classtype, MultiplicityType mult, boolean isDependent) throws DescriptorException {
        return new LinkDescriptorImpl(name, classtype, mult, isDependent);
    }

    public LinkDescriptor createLinkDescriptor(String name, ClassDescriptor cdes, MultiplicityType mult, boolean isDependent) throws DescriptorException {
        if (cdes == null) {
            throw new DescriptorException("ClassDescriptor is null");
        }
        return this.createLinkDescriptor(name, cdes.getClasstype(), mult, isDependent);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes) throws DescriptorException {
        return this.createClassDescriptor(classtype, this.createAttributeDescriptorArray(attributes, this.createDefaultKeyDescriptor(this.DEFAULT_KEY_LEN)), attributes.length, EMPTY_LINKS);
    }

    public ClassDescriptor createClassDescriptor(String classtype, LinkDescriptor[] links) throws DescriptorException {
        return this.createClassDescriptor(classtype, this.createAttributeDescriptorArray(EMPTY_ATTRIBS, this.createDefaultKeyDescriptor(this.DEFAULT_KEY_LEN)), EMPTY_ATTRIBS.length, links);
    }

    public ClassDescriptor createClassDescriptor(String classtype, int keyPos, AttributeDescriptor[] attribs) {
        return this.createClassDescriptor(classtype, attribs, keyPos, EMPTY_LINKS);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes, LinkDescriptor[] links) throws DescriptorException {
        return this.createClassDescriptor(classtype, this.createAttributeDescriptorArray(attributes, this.createDefaultKeyDescriptor(this.DEFAULT_KEY_LEN)), attributes.length, links);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes, LinkDescriptor[] links, int keyLen) throws DescriptorException {
        return this.createClassDescriptor(classtype, this.createAttributeDescriptorArray(attributes, this.createDefaultKeyDescriptor(keyLen)), attributes.length, links);
    }

    private ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes, int keyPos, LinkDescriptor[] links) {
        ClassDescriptorImpl cd = new ClassDescriptorImpl(classtype, attributes, keyPos, links);
        this.classDescriptors.put(cd.getClasstype(), cd);
        return cd;
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        return (ClassDescriptor)this.classDescriptors.get(classtype);
    }

    public boolean containsClassDescriptor(String classtype) {
        return this.classDescriptors.containsKey(classtype);
    }

    private final AttributeDescriptor createDefaultKeyDescriptor(int len) {
        return new AttributeDescriptorImpl(DEFAULT_KEYNAME, DEFAULT_KEYTYPE, 1, len, 0, true);
    }

    private final AttributeDescriptor[] createAttributeDescriptorArray(AttributeDescriptor[] src, AttributeDescriptor key) {
        AttributeDescriptor[] dst = new AttributeDescriptor[src.length + 1];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[src.length] = key;
        return dst;
    }
}

