/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.persist.core.Prioritizable;
import com.sap.ip.me.persist.core.PrioritizableCompositeCondition;

public class CompositeConditionImpl
implements PrioritizableCompositeCondition {
    final Condition[] conditions;
    final LogicalOperatorType logicalOperator;

    public CompositeConditionImpl(Condition[] conditions, LogicalOperatorType logicalOperator) {
        this.conditions = conditions;
        this.logicalOperator = logicalOperator;
    }

    public MeIterator getComponents() {
        return new MeIteratorArrayImpl(this.conditions);
    }

    public LogicalOperatorType getLogicalOperator() {
        return this.logicalOperator;
    }

    public boolean isComposite() {
        return true;
    }

    public void prepareExecution(ClassDescriptor classDescriptor) throws PersistenceException {
        int x = 0;
        while (x < this.conditions.length) {
            this.conditions[x].prepareExecution(classDescriptor);
            ++x;
        }
    }

    public boolean matches(PersistedObject obj) throws PersistenceException {
        if (this.logicalOperator == LogicalOperatorType.AND) {
            int x = 0;
            while (x < this.conditions.length) {
                if (!this.conditions[x].matches(obj)) {
                    return false;
                }
                ++x;
            }
            return true;
        }
        int x = 0;
        while (x < this.conditions.length) {
            if (this.conditions[x].matches(obj)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public int getPriority() {
        MeIterator itr = this.getComponents();
        int totalPriority = 0;
        itr.reset();
        while (itr.hasNext()) {
            Prioritizable prioritizable = (Prioritizable)itr.next();
            totalPriority += prioritizable.getPriority();
        }
        return totalPriority;
    }

    public boolean isEmpty() {
        return this.conditions.length == 0;
    }
}

