/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.core;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import java.util.Hashtable;

public class ClassDescriptorImpl
implements ClassDescriptor {
    private final String classtype;
    private final LinkDescriptor[] links;
    private final AttributeDescriptor[] attributes;
    private final Hashtable posAttributes;
    private final Hashtable posLinks;
    private final int secondaryIdxCnt;
    private final int keyAttribPos;

    public ClassDescriptorImpl(String classtype, AttributeDescriptor[] attributes, int keyPos, LinkDescriptor[] links) {
        this.verifyConstructorArgs(classtype, attributes, links, keyPos);
        this.classtype = classtype;
        this.attributes = ClassDescriptorImpl.createAttributesArray(attributes);
        this.posAttributes = ClassDescriptorImpl.createAttributePosition(this.attributes);
        this.keyAttribPos = keyPos;
        this.links = ClassDescriptorImpl.createLinksArray(links);
        this.posLinks = ClassDescriptorImpl.createLinkPosition(this.links);
        this.secondaryIdxCnt = ClassDescriptorImpl.getSecondaryIndexCount(attributes);
    }

    private void verifyConstructorArgs(String classtype, AttributeDescriptor[] att, LinkDescriptor[] lnk, int keyPos) {
        if (classtype == null) {
            throw new NullPointerException("classtype is null");
        }
        if (classtype.length() == 0) {
            throw new IllegalArgumentException("classtype is invalid");
        }
        if (att == null) {
            throw new NullPointerException("attributes is null");
        }
        if (lnk == null) {
            throw new NullPointerException("links is null");
        }
        if (keyPos < 0 || keyPos >= att.length) {
            throw new NullPointerException("Invalid key attribute position");
        }
        if (att[keyPos] == null) {
            throw new NullPointerException("key is null");
        }
        if (!att[keyPos].isIndex()) {
            throw new IllegalArgumentException("Key attribute descriptor has no index");
        }
        if (att[keyPos].getMultiple() != 1) {
            throw new IllegalArgumentException("Key attribute descriptor multiplicity must be 1");
        }
    }

    private static final AttributeDescriptor[] createAttributesArray(AttributeDescriptor[] buf) {
        AttributeDescriptor[] att = new AttributeDescriptor[buf.length];
        System.arraycopy(buf, 0, att, 0, buf.length);
        return att;
    }

    private static final Hashtable createAttributePosition(AttributeDescriptor[] att) {
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        int i = 0;
        int max = att.length;
        while (i < max) {
            if (map.put(att[i].getName(), new Integer(i)) != null) {
                throw new IllegalArgumentException("attribute name " + att[i].getName() + " is duplicated");
            }
            ++i;
        }
        return map;
    }

    private static final LinkDescriptor[] createLinksArray(LinkDescriptor[] buf) {
        LinkDescriptor[] lnk = new LinkDescriptor[buf.length];
        System.arraycopy(buf, 0, lnk, 0, buf.length);
        return lnk;
    }

    private static final Hashtable createLinkPosition(LinkDescriptor[] att) {
        if (att.length == 0) {
            return null;
        }
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        int i = 0;
        int max = att.length;
        while (i < max) {
            if (map.put(att[i].getName(), new Integer(i)) != null) {
                throw new IllegalArgumentException("link name " + att[i].getName() + " is duplicated");
            }
            ++i;
        }
        return map;
    }

    private static final int getSecondaryIndexCount(AttributeDescriptor[] att) {
        int cnt = 0;
        int i = 0;
        int max = att.length;
        while (i < max) {
            if (att[i].isIndex()) {
                ++cnt;
            }
            ++i;
        }
        return cnt - 1;
    }

    public String getClasstype() {
        return this.classtype;
    }

    public MeIterator getAttributeDescriptors() {
        return new MeIteratorArrayImpl(this.attributes);
    }

    public AttributeDescriptor[] getAttributeDescriptorArray() {
        AttributeDescriptor[] att = new AttributeDescriptor[this.attributes.length];
        System.arraycopy(this.attributes, 0, att, 0, att.length);
        return att;
    }

    public AttributeDescriptor getAttributeDescriptor(int no) {
        this.verifyAttributeIndex(no);
        return this.attributes[no];
    }

    public int getAttributePosition(String attribName) {
        Integer integer = (Integer)this.posAttributes.get(attribName);
        return integer != null ? integer : -1;
    }

    public int getPosition(AttributeDescriptor d) {
        return this.getAttributePosition(d.getName());
    }

    public MeIterator getLinkDescriptors() {
        return new MeIteratorArrayImpl(this.links);
    }

    public LinkDescriptor[] getLinkDescriptorArray() {
        LinkDescriptor[] lnk = new LinkDescriptor[this.links.length];
        System.arraycopy(this.links, 0, lnk, 0, lnk.length);
        return lnk;
    }

    public LinkDescriptor getLinkDescriptor(int no) {
        this.verifyLinkIndex(no);
        return this.links[no];
    }

    public int getLinkPosition(String linkName) {
        if (this.posLinks == null) {
            return -1;
        }
        Integer integer = (Integer)this.posLinks.get(linkName);
        return integer != null ? integer : -1;
    }

    public int getPosition(LinkDescriptor d) {
        return this.getLinkPosition(d.getName());
    }

    public int getSecondaryIdxCount() {
        return this.secondaryIdxCnt;
    }

    public AttributeDescriptor getKeyAttributeDescriptor() {
        return this.attributes[this.keyAttribPos];
    }

    public int getKeyAttributePosition() {
        return this.keyAttribPos;
    }

    public int hashCode() {
        return this.getClasstype().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ClassDescriptor) {
            return this.getClasstype().equals(((ClassDescriptor)object).getClasstype());
        }
        return false;
    }

    private final void verifyAttributeIndex(int idx) {
        if (idx < 0) {
            throw new ArrayIndexOutOfBoundsException("attribute index is negativ");
        }
        if (idx >= this.attributes.length) {
            throw new ArrayIndexOutOfBoundsException("attributes index " + idx + " exceed limit " + this.attributes.length);
        }
    }

    private final void verifyLinkIndex(int idx) {
        if (idx < 0) {
            throw new ArrayIndexOutOfBoundsException("link index is negativ");
        }
        if (idx >= this.links.length) {
            throw new ArrayIndexOutOfBoundsException("link index " + idx + " exceed limit " + this.links.length);
        }
    }

    public LinkDescriptor[] internalGetLinkDescriptors() {
        return null;
    }
}

