/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.itool;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.itool.InstallationStep;
import com.sapmarkets.web.liTS.util.reg.WafRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.PropertyResourceBundle;

public class InstStepSyncForApplications
extends InstallationStep
implements SyncEventListener {
    private String userName;
    private String password;
    private String imageRoot;
    private boolean syncSuccessful = false;
    private Trace trace;
    private int logLevel;
    private int numberOfSyncCycles;

    public InstStepSyncForApplications(PropertyResourceBundle properties, Object context) {
        super(properties, context);
    }

    void initFromContext(Object context) {
    }

    void initFromProperties(PropertyResourceBundle properties) {
        this.userName = properties.getString("INSTALL_PARAM_USER_NAME");
        this.password = properties.getString("INSTALL_PARAM_USER_PASSWORD");
        this.imageRoot = properties.getString("INSTALL_PARAM_IMAGE_ROOT");
        this.logLevel = Integer.parseInt(properties.getString("INSTALL_PARAM_IMAGE_LOGLEVEL"));
        this.numberOfSyncCycles = Integer.parseInt(properties.getString("NUMBER_OF_SYNC_CYCLES"));
    }

    public void execute() {
        int i = 0;
        while (i < this.numberOfSyncCycles) {
            this._execute();
            ++i;
        }
    }

    public void _execute() {
        block11: {
            UserManagerImpl userManager = (UserManagerImpl)UserManager.getInstance();
            SyncManager syncManager = SyncManager.getInstance();
            this.trace = Trace.getInstance("MI");
            try {
                try {
                    if (null == userManager.getUser(this.userName)) {
                        this.trace.log(90, "Adding user " + this.userName + " for installation image.");
                        userManager.addNewUser(this.userName, this.password, this.password);
                    }
                    this.trace.log(90, "Logging on user " + this.userName + " for installation image.");
                    userManager.logOnUser(this.userName, this.password);
                    if (!syncManager.isSyncCredentialAvailable()) {
                        this.trace.log(90, "Setting sync password for user " + this.userName);
                        userManager.setSyncPasswordOfCurrentUser(this.password);
                    }
                    this.trace.log(90, "Starting synchronisation for installation image.");
                    new WafRegistry().notifyR3();
                    syncManager.synchronizeWithBackend();
                    this.trace.log(90, "Logging out user " + this.userName);
                    userManager.logOutCurrentUser();
                }
                catch (LogonException e) {
                    this.notifyInstallationServer(e);
                    Object var6_4 = null;
                    if (!this.syncSuccessful) {
                        this.notifyInstallationServer(null, "#sync");
                    }
                    break block11;
                }
                catch (SyncPasswordException e) {
                    this.notifyInstallationServer(e);
                    Object var6_5 = null;
                    if (!this.syncSuccessful) {
                        this.notifyInstallationServer(null, "#sync");
                    }
                }
                Object var6_3 = null;
                if (!this.syncSuccessful) {
                    this.notifyInstallationServer(null, "#sync");
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!this.syncSuccessful) {
                    this.notifyInstallationServer(null, "#sync");
                }
                throw throwable;
            }
        }
    }

    private void notifyInstallationServer(SyncPasswordException e) {
        String lockFileName = this.imageRoot + "/" + "#spasswd";
        this.notifyInstallationServer(e, lockFileName);
    }

    private void notifyInstallationServer(LogonException e) {
        String lockFileName = this.imageRoot + "/" + "#login";
        this.notifyInstallationServer(e, lockFileName);
    }

    private void notifyInstallationServer(Exception e, String lockFileName) {
        try {
            this.writeLockFile(lockFileName);
        }
        catch (IOException anIOException) {
            this.writeTraceFatal(e);
        }
    }

    private void writeLockFile(String lockFileName) throws IOException {
        File file = new File(lockFileName);
        if (!file.exists()) {
            FileOutputStream output = new FileOutputStream(lockFileName);
            PrintStream printer = new PrintStream(output);
            printer.println(lockFileName);
            printer.flush();
            printer.close();
            output.close();
        }
    }

    private void writeTraceFatal(Exception exception) {
        this.trace.log(10, "Installation Image corrupted due to occurance of " + exception.getClass().getName());
    }

    public void actionPerformed(SyncEvent syncEvent) {
        if (syncEvent.getType() != 2) {
            return;
        }
        this.syncSuccessful = true;
    }
}

