/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.services.Log;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.CleanupListWriter;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.WebDynproEntityResolver;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDynproApplicationType
implements ApplicationType {
    private InstallationLog log = new InstallationLog("LOG");
    private DeploymentMessages deplLog = DeploymentMessages.getInstance();
    private final Trace trace = Trace.getInstance("MI/Deployment");
    static /* synthetic */ Class class$java$lang$String;

    public void install(String source, MobileSolutionDescriptor application) throws InstallationException {
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "DOWNLOADING", " " + application.getName() + " " + application.getVersion() + ": " + application.getDescription());
        this.log.addLogEntry("Retrieving application " + application.getName() + " from  " + source);
        if (this.trace.isLogging(80)) {
            this.trace.log(80, "Installation: Link sent from backend is " + source);
        }
        String wdProjectName = this.determineFilenameForDownload(source, application);
        String urlString = this.determineUrl(source);
        File fileIn = new File(wdProjectName.concat(".ear"));
        String webappsfolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "webapps" + File.separator;
        File earFile = new File(webappsfolder.concat(fileIn.getName()));
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "WebDynproApplicationType.install: webappsfolder is " + webappsfolder);
            this.trace.log(90, "WebDynproApplicationType.install: File for downloading .ear file is " + earFile.getAbsolutePath());
        }
        try {
            earFile = this.downloadWarFile(application, urlString, earFile);
        }
        catch (Exception ex) {
            this.deleteFile(earFile);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", " " + urlString);
            this.log.addLogEntry(ex.getMessage());
            this.log.addLogEntry("WebDynproApplicationType.install: failed");
            if (this.trace.isLogging(50)) {
                this.trace.logException("Installation: Failed to download installation file from " + urlString, (Throwable)ex, true);
            }
            throw new InstallationException(7, null, null);
        }
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "INSTALLING", " " + application.getName() + " " + application.getVersion() + ": " + application.getDescription());
        try {
            this.readOutWebDynproInformation(application, earFile);
            if (application.getWebDynproProjectName() == null || application.getWebDynproApplicationName() == null) {
                throw new InstallationException("Problem during parsing of the XML file to receive project name and application name", null);
            }
        }
        catch (IOException ioexc) {
            this.deleteFile(earFile);
            this.writeInstallFailureToDeplLog(ioexc.getMessage());
            throw new InstallationException("Cannot read out zip file, to get project name and application name", ioexc);
        }
        earFile = this.renameEarFileToProjectName(application, earFile);
        this.callWebDynproDeployer(earFile);
        this.log.sendToR3();
        this.setMSDVisibility(application);
    }

    public void uninstall(MobileSolutionDescriptor application) throws InstallationException {
        boolean success = false;
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", " " + application.getName() + " " + application.getVersion() + " " + application.getDescription());
        String installationDirectory = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        this.trace.log(90, "WebDynproType.uninstall: application " + application.getName() + " " + application.getVersion() + " " + application.getDescription());
        try {
            Class<?> c = Class.forName("com.sap.ide.webdynpro.tomcat.deploy.WDDeployer");
            Method method = c.getMethod("undeploy", class$java$lang$String == null ? (class$java$lang$String = WebDynproApplicationType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WebDynproApplicationType.class$("java.lang.String")) : class$java$lang$String);
            Object[] paramValues = new Object[]{installationDirectory, application.getWebDynproProjectName()};
            method.invoke(null, paramValues);
            success = true;
        }
        catch (IllegalAccessException exIllegal) {
            this.writeUnInstallFailureToDeplLog(exIllegal.getMessage());
            throw new InstallationException("WebDynpro Installer call IllegalAccessException", exIllegal);
        }
        catch (InvocationTargetException exTarget) {
            this.writeUnInstallFailureToDeplLog(exTarget.getMessage());
            throw new InstallationException("WebDynpro Installer call InvocationTargetException", exTarget);
        }
        catch (NoSuchMethodException exMethod) {
            this.writeUnInstallFailureToDeplLog(exMethod.getMessage());
            throw new InstallationException("WebDynpro Installer call NoSuchMethodException", exMethod);
        }
        catch (ClassNotFoundException ex) {
            this.writeUnInstallFailureToDeplLog(ex.getMessage());
            this.trace.log(50, "WebDynpro runtime not available: application requires WebDynpro runtime", (Object)ex);
            throw new InstallationException("ClassNotFoundException", ex);
        }
        if (success) {
            try {
                ApplicationManager.getInstance().saveMobileSolutionDescriptors();
            }
            catch (IOException ioex) {
                Log.logException("Cannot write registry", (Throwable)ioex, true);
            }
        } else {
            this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLATIONFAILURE", null);
            throw new InstallationException(6, null, null);
        }
    }

    public String toString() {
        return "WEBDYNPRO";
    }

    private void setMSDVisibility(MobileSolutionDescriptor application) {
        if (application.getPropertyValueForKey("HOMEPAGE.INVISIBLE").equalsIgnoreCase("X")) {
            application.setVisible(false);
        } else {
            application.setVisible(true);
        }
    }

    private void callWebDynproDeployer(File earFile) throws InstallationException {
        try {
            Class<?> c = Class.forName("com.sap.ide.webdynpro.tomcat.deploy.WDDeployer");
            Method method = c.getMethod("deploy", class$java$lang$String == null ? (class$java$lang$String = WebDynproApplicationType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WebDynproApplicationType.class$("java.lang.String")) : class$java$lang$String);
            Object[] paramValues = new Object[]{Configuration.getInstance().getProperty("MobileEngine.InstallationPath"), earFile.getAbsolutePath()};
            method.invoke(null, paramValues);
            this.deleteFile(earFile);
        }
        catch (IllegalAccessException exIllegal) {
            this.writeInstallFailureToDeplLog(exIllegal.getClass().getName() + " : " + exIllegal.getMessage());
            throw new InstallationException("Problems during call of external WebDynpro Installer because of: " + exIllegal.getClass().getName(), exIllegal);
        }
        catch (InvocationTargetException exTarget) {
            this.writeInstallFailureToDeplLog(exTarget.getClass().getName() + " : " + exTarget.getMessage());
            throw new InstallationException("Problems during call of external WebDynpro Installer beacuse of : " + exTarget.getClass().getName(), exTarget);
        }
        catch (NoSuchMethodException exMethod) {
            this.writeInstallFailureToDeplLog(exMethod.getClass().getName() + " : " + exMethod.getMessage());
            throw new InstallationException("Problems during call of external WebDynpro Installer, method not found: ", exMethod);
        }
        catch (ClassNotFoundException ex) {
            this.deleteFile(earFile);
            this.trace.log(50, "WebDynpro runtime not available: application requires WebDynpro runtime", (Object)ex);
            this.writeInstallFailureToDeplLog(ex.getClass().getName() + " : " + ex.getMessage());
            throw new InstallationException("ClassNotFoundException: WebDynpro Runtime not available", ex);
        }
    }

    private void writeInstallFailureToDeplLog(String message) {
        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", message);
    }

    private void writeUnInstallFailureToDeplLog(String message) {
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLATIONFAILURE", message);
    }

    private File renameEarFileToProjectName(MobileSolutionDescriptor application, File fileIn) {
        File file2 = new File(fileIn.getParent(), application.getWebDynproProjectName().concat(".ear"));
        if (!fileIn.renameTo(file2)) {
            this.trace.log(50, "Could not rename " + fileIn.getAbsolutePath() + " to " + file2.getAbsolutePath());
            return fileIn;
        }
        return file2;
    }

    private File downloadWarFile(MobileSolutionDescriptor msd, String url, File earfile) throws Exception {
        if (!msd.isInstallationFileAlreadyDownloaded()) {
            this.log.addLogEntry("Retrieving application " + msd.getName() + " from  " + url);
            SyncSettings.updateSystemProxySettings();
            IOUtils.httpGet(url, earfile.getAbsolutePath());
            return earfile;
        }
        this.log.addLogEntry("Retrieving application " + msd.getName() + " from  " + msd.getCustomizingValueForKey("LOCALPATH"));
        File newfile = new File(msd.getCustomizingValueForKey("LOCALPATH"));
        if (IOUtils.moveFileToDirectory(newfile, new File(earfile.getParent()))) {
            this.log.addLogEntry("JspApplicationType.install: copied installation file to: " + earfile.getParent().concat(File.separator).concat(newfile.getName()));
            return new File(earfile.getParent().concat(File.separator).concat(newfile.getName()));
        }
        throw new InstallationException(7, null, null);
    }

    private String determineUrl(String source) throws InstallationException {
        String urlString = null;
        if (!(source.startsWith("http") || source.startsWith("HTTP") || source.toLowerCase().startsWith("file"))) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", source);
            AppLog.getInstance("MI/Core").log(50, "Installation: Failed to download installation file because download link sent was: " + source);
            throw new InstallationException(7, null, null);
        }
        urlString = source;
        return urlString;
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            CleanupListWriter.writeToFile(file.getAbsolutePath().concat(File.pathSeparator));
        }
    }

    private String determineFilenameForDownload(String source, MobileSolutionDescriptor msd) {
        int lastIndexOfSlash = source.lastIndexOf("/");
        String version = msd.getVersion();
        version = version + "_";
        String projectString = source.substring(lastIndexOfSlash + 1, source.length() - 4);
        String wdProjectName = projectString.substring(version.length(), projectString.length());
        return wdProjectName;
    }

    private void readOutWebDynproInformation(MobileSolutionDescriptor msd, File earFile) throws IOException {
        String baseDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        String applicationName = null;
        String projectName = null;
        File tempFile = null;
        ZipFile zip = new ZipFile(earFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        String installationFolder = "";
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String currentEntryName = ze.getName();
            if (currentEntryName.toLowerCase().endsWith("application.xml")) {
                currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
                tempFile = IOUtils.extractZipFile(zip, ze, baseDir + File.separator + "work" + File.separator + currentEntryName);
                if (this.trace.isLogging(80)) {
                    this.trace.log(80, "Evaluation Application.xml file ''{0}''", (Object)tempFile.getAbsolutePath());
                }
                projectName = this.getProjectName(tempFile);
                this.deleteFile(tempFile);
                continue;
            }
            if (!currentEntryName.endsWith(".wda")) continue;
            currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
            File tempWdaFile = IOUtils.extractZipFile(zip, ze, baseDir + File.separator + "work" + File.separator + currentEntryName);
            ZipFile wdaFile = new ZipFile(tempWdaFile);
            Enumeration<? extends ZipEntry> wdaEntries = wdaFile.entries();
            while (wdaEntries.hasMoreElements()) {
                ZipEntry wdaEntry = wdaEntries.nextElement();
                String wdaCurrentEntryName = wdaEntry.getName();
                if (wdaCurrentEntryName.endsWith("portalapp.xml")) {
                    wdaCurrentEntryName = wdaCurrentEntryName.substring(wdaCurrentEntryName.lastIndexOf("/") + 1, wdaCurrentEntryName.length());
                    tempFile = IOUtils.extractZipFile(wdaFile, wdaEntry, baseDir + File.separator + "work" + File.separator + wdaCurrentEntryName);
                    applicationName = this.getApplicationName(tempFile);
                    this.deleteFile(tempFile);
                    this.deleteFile(tempWdaFile);
                    continue;
                }
                if (!wdaCurrentEntryName.toLowerCase().endsWith("merepmeta.xml")) continue;
                this.log.addLogEntry("WebDynproApplicationType.install(File warFile): Found merepmeta.xml in .war archive of application " + msd.getName());
                if (this.trace.isLogging(80)) {
                    this.trace.log(80, "WebDynproApplicationType.install(File warFile): Found merepmeta.xml in .war archive of application " + msd.getName());
                }
                msd.setUsingSmartSync(true);
                SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
                d.setMetaDataFile(msd.getName(), wdaFile, wdaEntry);
            }
            this.deleteFile(tempWdaFile);
            if (tempFile != null) {
                this.deleteFile(tempFile);
            }
            wdaFile.close();
        }
        zip.close();
        msd.setWebDynproApplicationName(applicationName);
        msd.setWebDynproProjectName(projectName);
    }

    private String getApplicationName(File tempFile) throws IOException {
        String result;
        block11: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            result = "";
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(tempFile.toString());
                NodeList nodeList = document.getElementsByTagName("application");
                int i = 0;
                while (i < nodeList.getLength()) {
                    NodeList childNodeList = nodeList.item(i).getChildNodes();
                    int y = 0;
                    while (y < childNodeList.getLength()) {
                        if (childNodeList.item(y).getNodeName().equals("webdynpro")) {
                            NodeList webdynproChildNodeList = childNodeList.item(y).getChildNodes();
                            int x = 0;
                            while (x < webdynproChildNodeList.getLength()) {
                                if (webdynproChildNodeList.item(x).getNodeName().equals("applications")) {
                                    NodeList applicationsChildNodeList = webdynproChildNodeList.item(x).getChildNodes();
                                    int z = 0;
                                    while (z < applicationsChildNodeList.getLength()) {
                                        if (applicationsChildNodeList.item(z).getNodeName().equals("part")) {
                                            NamedNodeMap nodeMap = applicationsChildNodeList.item(z).getAttributes();
                                            Node node = nodeMap.item(0);
                                            if (!node.getNodeName().equals("shortName")) break;
                                            result = node.getNodeValue();
                                            break;
                                        }
                                        ++z;
                                    }
                                }
                                ++x;
                            }
                        }
                        ++y;
                    }
                    ++i;
                }
            }
            catch (SAXException excSax) {
                if (this.trace.isLogging(50)) {
                    this.trace.logException(50, excSax);
                }
            }
            catch (ParserConfigurationException excParser) {
                if (!this.trace.isLogging(50)) break block11;
                this.trace.logException(50, excParser);
            }
        }
        return result;
    }

    private String getProjectName(File tempFile) throws IOException {
        String result;
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            result = "";
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new WebDynproEntityResolver());
                Document document = builder.parse(tempFile.toString());
                NodeList nodeList = document.getElementsByTagName("application");
                int i = 0;
                while (i < nodeList.getLength()) {
                    NodeList childNodeList = nodeList.item(i).getChildNodes();
                    int y = 0;
                    while (y < childNodeList.getLength()) {
                        if (childNodeList.item(y).getNodeName().equals("display-name")) {
                            result = childNodeList.item(y).getChildNodes().item(0).getNodeValue().toString();
                            break;
                        }
                        ++y;
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException excParser) {
                if (this.trace.isLogging(50)) {
                    this.trace.logException(50, excParser);
                }
            }
            catch (SAXException excSax) {
                if (!this.trace.isLogging(50)) break block7;
                this.trace.logException(50, excSax);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

