/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.security.PermissionException;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.smartsync.FieldDescriptor;
import com.sap.ip.me.api.smartsync.Row;
import com.sap.ip.me.api.smartsync.RowDescriptor;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ChangePasswordException;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.LogonListener;
import com.sap.ip.me.core.PasswordChangedListener;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.ServerExceptionMessage;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserImpl;
import com.sap.ip.me.security.permission.Action;
import com.sap.ip.me.security.permission.AuthBoEventListener;
import com.sap.ip.me.security.permission.AuthSyncBo;
import com.sap.ip.me.security.permission.Field;
import com.sap.ip.me.security.permission.PermissionList;
import com.sap.ip.me.security.permission.SinglePermission;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class UserManagerImpl
extends UserManager {
    private static final String USERS_DAT_FILE_NAME = "users.dat";
    private static final String UNSUPPORTED_CHARACTERS = "\\/:*?\"<>|&=[";
    private static final String EMPTY_STRING = "";
    private final Hashtable listOfUsers = new Hashtable();
    private final String SHARED_USERNAME = "(SHARED)";
    private static User SHARED_USER = null;
    private final Vector logonListeners = new Vector();
    private final Vector passwordChangedListeners = new Vector();
    private static UserManagerImpl instance;
    private UserImpl currentUser;
    private UserImpl temporaryCurrentUser;
    private Thread temporaryCurrentUserThread;

    private UserManagerImpl() {
        int requestTimeout;
        SHARED_USER = new UserImpl("(SHARED)", "MOBILE");
        this.readUserList();
        this.setCurrentUser(null);
        Configuration config = Configuration.getInstance();
        int waitingRefresh = config.getInt("MobileEngine.UM.SAPLogonTicketWaitingRefresh", -1);
        if (waitingRefresh < 1) {
            config.setDefaultProperty("MobileEngine.UM.SAPLogonTicketWaitingRefresh", "1");
        }
        if ((requestTimeout = config.getInt("MobileEngine.UM.SAPLogonTicketRequestTimeout", -1)) < 10) {
            config.setDefaultProperty("MobileEngine.UM.SAPLogonTicketRequestTimeout", "10");
        }
    }

    public static final User getSharedUser() {
        return SHARED_USER;
    }

    public final boolean checkIfShared(String loginName) {
        return "(SHARED)".equals(loginName);
    }

    public static UserManagerImpl getUserManagerImplInstance() {
        if (instance == null) {
            instance = (UserManagerImpl)UserManager.getInstance();
        }
        return instance;
    }

    public User getUser(String username) {
        if (username == null) {
            return null;
        }
        if (username.equals("(SHARED)")) {
            return SHARED_USER;
        }
        return (User)this.listOfUsers.get(username.trim().toUpperCase());
    }

    public UserImpl getUserImpl(String username) {
        return (UserImpl)this.getUser(username);
    }

    public void changeLocalPassword(String oldPassword, String newPassword, String newPasswordConfirmation) throws ChangePasswordException {
        UserImpl currentUser = this.getCurrentUserImpl();
        if (currentUser == null) {
            throw new IllegalStateException("A local password change is only allowed if a logged on user exists.");
        }
        boolean isSelectedSyncPasswordOptionLocal = false;
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            isSelectedSyncPasswordOptionLocal = true;
        }
        if (oldPassword == null || oldPassword.length() == 0) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(0);
            }
            throw new ChangePasswordException(5);
        }
        if (newPassword == null || newPassword.length() == 0) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(1);
            }
            throw new ChangePasswordException(6);
        }
        if (Configuration.getInstance().getBoolean("MobileEngine.Security.PasswordsToUpperCase", false)) {
            oldPassword = oldPassword.toUpperCase();
            newPassword = newPassword.toUpperCase();
            if (newPasswordConfirmation != null) {
                newPasswordConfirmation = newPasswordConfirmation.toUpperCase();
            }
        }
        if (!currentUser.getLogonPassword().equals(oldPassword)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(4);
            }
            throw new ChangePasswordException(9);
        }
        if (!newPassword.equals(newPasswordConfirmation)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(2);
            }
            throw new ChangePasswordException(7);
        }
        if (newPassword.equals(oldPassword)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(3);
            }
            throw new ChangePasswordException(8);
        }
        currentUser.setLogonPassword(newPassword);
        this.fireLocalPasswordChanged(currentUser);
        this.saveUserList();
    }

    public void resetLocalPassword(String UserId, String newPassword, String newPasswordConfirmation) throws ChangePasswordException {
        String oldPassword = null;
        UserImpl changedUser = this.getUserImpl(UserId);
        if (changedUser == null) {
            throw new IllegalStateException("The given user does not exist.");
        }
        boolean isSelectedSyncPasswordOptionLocal = false;
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            isSelectedSyncPasswordOptionLocal = true;
        }
        if (newPassword == null || newPassword.length() == 0) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(1);
            }
            throw new ChangePasswordException(6);
        }
        if (Configuration.getInstance().getBoolean("MobileEngine.Security.PasswordsToUpperCase", false)) {
            oldPassword = oldPassword.toUpperCase();
            newPassword = newPassword.toUpperCase();
            if (newPasswordConfirmation != null) {
                newPasswordConfirmation = newPasswordConfirmation.toUpperCase();
            }
        }
        if (!newPassword.equals(newPasswordConfirmation)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(2);
            }
            throw new ChangePasswordException(7);
        }
        changedUser.setLogonPassword(newPassword);
        this.fireLocalPasswordChanged(changedUser);
        this.saveUserList();
    }

    public void changeSyncPassword(String oldPassword, String newPassword, String newPasswordConfirmation) throws ChangePasswordException {
        UserImpl currentUser = this.getCurrentUserImpl();
        if (currentUser == null) {
            throw new IllegalStateException("A synchronization password change is only allowed if a logged on user exists.");
        }
        boolean isSelectedSyncPasswordOptionLocal = false;
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            isSelectedSyncPasswordOptionLocal = true;
        }
        if (oldPassword == null || oldPassword.length() == 0) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(0);
            }
            throw new ChangePasswordException(10);
        }
        if (newPassword == null || newPassword.length() == 0) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(1);
            }
            throw new ChangePasswordException(11);
        }
        if (isSelectedSyncPasswordOptionLocal && !currentUser.getLogonPassword().equals(oldPassword)) {
            throw new ChangePasswordException(4);
        }
        if (!newPassword.equals(newPasswordConfirmation)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(2);
            }
            throw new ChangePasswordException(12);
        }
        if (newPassword.equals(oldPassword)) {
            if (isSelectedSyncPasswordOptionLocal) {
                throw new ChangePasswordException(3);
            }
            throw new ChangePasswordException(13);
        }
        try {
            URL url = new URL(SyncSettings.getEnhancedSyncGatewayURL());
            try {
                IOUtils.isConnectable(url);
            }
            catch (HttpConnectionException e) {
                Trace.getInstance("MI/Core").log(90, "MI Server not reachable: " + e.getMessage());
                throw new ChangePasswordException(14);
            }
            URLConnection connection = url.openConnection();
            String userName = IOUtils.utf8AndUrlEncode(this.getCurrentUserImpl().getUniqueName());
            oldPassword = IOUtils.utf8AndUrlEncode(oldPassword);
            newPassword = IOUtils.utf8AndUrlEncode(newPassword);
            connection.setRequestProperty("content-type", "application/binary;charset=UTF-8");
            connection.setRequestProperty("com.sap.ip.mi.user", userName);
            connection.setRequestProperty("com.sap.ip.mi.syncpassword", oldPassword);
            connection.setRequestProperty("com.sap.ip.mi.newsyncpassword", newPassword);
            connection.setRequestProperty("com.sap.ip.mi.exceptioninfo", "true");
            long timeout = Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L);
            InputStream inputStream = null;
            inputStream = timeout != -1L ? this.getInputStreamFromURLConnection(connection, timeout) : connection.getInputStream();
            BufferedUTF8Reader reader = new BufferedUTF8Reader(inputStream);
            int bufferSize = 256;
            StringBuffer input = new StringBuffer(bufferSize);
            char[] charBuffer = new char[bufferSize];
            int len = reader.read(charBuffer);
            while (len >= 0) {
                input.append(charBuffer, 0, len);
                len = reader.read(charBuffer);
            }
            if (connection.getHeaderField("com.sap.ip.mi.serverexception") != null) {
                int exceptionInfoCode;
                String prefix = "<!--This page was created by the SAP MI J2EE server component. -->&WAF_SYNC&EXCEPTION_INFO_CODE=";
                String s = input.toString();
                try {
                    exceptionInfoCode = Integer.parseInt(s.substring(prefix.length(), s.length() - 1));
                }
                catch (NumberFormatException ex) {
                    exceptionInfoCode = -2;
                }
                ServerExceptionMessage message = new ServerExceptionMessage(exceptionInfoCode);
                throw new ChangePasswordException(message.getLocalizedMessage());
            }
            if (connection.getHeaderField("com.sap.ip.mi.localizedservermessage") != null) {
                throw new ChangePasswordException(input.toString());
            }
            if (connection.getHeaderField("com.sap.ip.mi.passwordchangeperformed") == null) {
                throw new ChangePasswordException(17);
            }
        }
        catch (MalformedURLException e) {
            Trace trace = Trace.getInstance("MI/Core");
            trace.log(50, "Malformed URL exception at synchronization password change: " + e.getMessage());
            trace.logException(50, e);
            throw new ChangePasswordException(15);
        }
        catch (IOException e) {
            Trace trace = Trace.getInstance("MI/Core");
            trace.log(50, "IO exception at synchronization password change: " + e.getMessage());
            trace.logException(50, e);
            throw new ChangePasswordException(16);
        }
        if (SyncPasswordHandlingOption.ONCE == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            currentUser.setSyncPassword(newPassword);
        }
        if (isSelectedSyncPasswordOptionLocal) {
            currentUser.setLogonPassword(newPassword);
            this.fireLocalPasswordChanged(currentUser);
            this.saveUserList();
        }
    }

    public void logOnUser(String userName, String password) throws LogonException {
        if (Configuration.getInstance().getBoolean("MobileEngine.Security.PasswordsToUpperCase", false)) {
            password = password.toUpperCase();
        }
        this.checkUserName(userName, false);
        if (password == null || password.length() == 0) {
            throw new LogonException(7);
        }
        UserImpl u = this.getUserImpl(userName);
        if (u != null) {
            if (!u.verifyPassword(password)) {
                this.saveUserList();
                if (u.isLocked()) {
                    throw new LogonException(12);
                }
                throw new LogonException(9);
            }
            this.saveUserList();
            if (u.isLocked()) {
                throw new LogonException(12);
            }
            if (!u.equals(this.getCurrentUser())) {
                this.logOutCurrentUser();
            }
        } else {
            throw new LogonException(9, new Object[]{userName});
        }
        this.logOnUser(u);
    }

    void logOnUser(UserImpl u) {
        if (u == null) {
            throw new IllegalStateException("UserImpl instance is null.");
        }
        this.setCurrentUser(u);
        Configuration.getInstance().switchUserConfiguration(u.getUniqueName());
        Trace.getInstance("MI/Core").refresh();
        if (!u.equals(UserManagerImpl.getSharedUser())) {
            Configuration.getInstance().setTemporary("MobileEngine.Sync.User", u.getUniqueID());
            this.fireLogon(u);
        }
        SmartSyncAdapter sa = (SmartSyncAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.SmartSyncAdapterImpl");
        sa.userLoggedIn();
        AuthSyncBo authSyncBo = new AuthSyncBo();
        Vector authorizations = this.getAuthVector(authSyncBo);
        try {
            this.setUserPermissions(authorizations);
        }
        catch (PermissionException e) {
            e.printStackTrace();
        }
        AuthBoEventListener syncAuthBo = new AuthBoEventListener();
        ConversationIdHandler handler = ConversationIdHandler.getInstance();
    }

    public void logOnSingleUser() throws LogonException {
        int numOfUsers = this.listOfUsers.size();
        if (numOfUsers != 0) {
            if (numOfUsers != 1) {
                throw new IllegalStateException("MI client is configured for single user mode, but there are more than one user registered.");
            }
        } else {
            throw new LogonException(9);
        }
        UserImpl u = (UserImpl)this.listOfUsers.elements().nextElement();
        this.logOnUser(u);
    }

    public void setSSOTicket(String ticket) {
        UserImpl u;
        Trace trace = Trace.getInstance("MI/Core");
        if (ticket == null || ticket.length() == 0) {
            trace.log(50, "UserManager - setSSOTicket: Empty SSO ticket received.");
            throw new IllegalArgumentException("Empty SSO ticket received.");
        }
        if (trace.isLogging(90)) {
            trace.log(90, "UserManager - setSSOTicket: SSO ticket received.");
        }
        if ((u = this.getCurrentUserImpl()) == null) {
            throw new IllegalStateException("UserManager - setSSOTicket: Current User is null.");
        }
        u.setSSOTicket(ticket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logOnUserViaSSOTicket(String ticket) throws LogonException {
        if (ticket == null || ticket.length() == 0) {
            Trace.getInstance("MI/Core").log(50, "SSO ticket not available for initial/online authentication.");
            throw new IllegalStateException("SSO ticket not available for initial/online authentication.");
        }
        String userName = null;
        try {
            URL url = new URL(SyncSettings.getEnhancedSyncGatewayURL());
            try {
                IOUtils.isConnectable(url);
            }
            catch (HttpConnectionException e) {
                Trace.getInstance("MI/Core").log(50, "MI server not reachable: " + e.getMessage());
                Trace.getInstance("MI/Core").logException(50, e);
                throw new LogonException(14);
            }
            URLConnection connection = url.openConnection();
            ticket = IOUtils.utf8AndUrlEncode(ticket);
            connection.setRequestProperty("content-type", "application/binary;charset=UTF-8");
            connection.setRequestProperty("com.sap.ip.mi.ssoticket", ticket);
            connection.setRequestProperty("com.sap.ip.mi.ssoauthenticationonly", "true");
            connection.setRequestProperty("com.sap.ip.mi.exceptioninfo", "true");
            long timeout = Configuration.getInstance().getLong("MobileEngine.Sync.WaitForResultsTimeout", -1L);
            InputStream inputStream = null;
            inputStream = timeout != -1L ? this.getInputStreamFromURLConnection(connection, timeout) : connection.getInputStream();
            BufferedUTF8Reader reader = new BufferedUTF8Reader(inputStream);
            int bufferSize = 256;
            StringBuffer input = new StringBuffer(bufferSize);
            char[] charBuffer = new char[bufferSize];
            int len = reader.read(charBuffer);
            while (len >= 0) {
                input.append(charBuffer, 0, len);
                len = reader.read(charBuffer);
            }
            if (connection.getHeaderField("com.sap.ip.mi.serverexception") != null) {
                Trace.getInstance("MI/Core").log(50, "MI Sync Servlet Exception: " + input.toString());
                throw new LogonException(13);
            }
            userName = input.toString();
            if (userName == null) {
                Trace.getInstance("MI/Core").log(50, "MI Sync Servlet sent an empty user ID.");
                throw new LogonException(0);
            }
        }
        catch (MalformedURLException e) {
            Trace.getInstance("MI/Core").log(50, "Malformed URL exception at logon via SSO ticket: " + e.getMessage());
            Trace.getInstance("MI/Core").logException(50, e);
            throw new LogonException(15);
        }
        catch (IOException e) {
            Trace.getInstance("MI/Core").log(50, "IO exception at logon via SSO ticket: " + e.getMessage());
            Trace.getInstance("MI/Core").logException(50, e);
            throw new LogonException(16);
        }
        UserImpl u = (UserImpl)this.getUser(userName);
        if (u != null) {
            if (!u.equals(this.currentUser)) {
                this.logOutCurrentUser();
            }
        } else if (Configuration.getInstance().getBoolean("MobileEngine.UM.SingleUserMode", false)) {
            if (this.listOfUsers.size() != 0) throw new IllegalStateException("There is only one initial authentication supported in single user mode with SAP logon ticket support.");
            u = new UserImpl(userName, EMPTY_STRING);
            this.addUser(u);
        } else {
            Trace.getInstance("MI/Core").log(50, "SSO: Received unknown user ID.");
            throw new LogonException(18, new Object[]{userName});
        }
        u.setSSOTicket(ticket);
        this.logOnUser(u);
    }

    public void unlockUser(User u) {
        this.getUserImpl(u.getUniqueID()).unlock();
        this.saveUserList();
    }

    public boolean isUserLocked(User u) {
        return this.getUserImpl(u.getUniqueID()).isLocked();
    }

    public void deleteUser(User u) {
        this.listOfUsers.remove(u.getUniqueName());
        this.saveUserList();
    }

    public void logOutCurrentUser() {
        UserImpl u;
        if (SyncPasswordHandlingOption.LOCAL != SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            this.removeSyncPasswordOfCurrentUser();
        }
        if ((u = this.getCurrentUserImpl()) != null) {
            u.setSSOTicket(null);
        }
        this.setCurrentUser(null);
        Configuration config = Configuration.getInstance();
        config.setTemporary("MobileEngine.Sync.User", EMPTY_STRING);
        ApplicationManager.getInstance().destroyAllRunningApplications();
        Configuration.getInstance().switchUserConfiguration(null);
        Trace.getInstance("MI/Core").refresh();
    }

    public User getCurrentUser() {
        if (this.temporaryCurrentUser == null) {
            return this.currentUser;
        }
        if (this.temporaryCurrentUserThread != Thread.currentThread()) {
            return this.currentUser;
        }
        return this.temporaryCurrentUser;
    }

    public User getCurrentLogonUser() {
        return this.currentUser;
    }

    public UserImpl getCurrentUserImpl() {
        return this.temporaryCurrentUser != null ? this.temporaryCurrentUser : this.currentUser;
    }

    public void removeSyncPasswordOfCurrentUser() {
        UserImpl cu = this.getCurrentUserImpl();
        if (cu != null && !cu.equals(UserManagerImpl.getSharedUser())) {
            cu.setSyncPassword(null);
        }
    }

    public void setSyncPasswordOfCurrentUser(String password) throws SyncPasswordException {
        UserImpl cu = this.getCurrentUserImpl();
        if (cu == null || cu.equals(UserManagerImpl.getSharedUser())) {
            throw new SyncPasswordException(0, null, null);
        }
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            throw new SyncPasswordException(2, null, null);
        }
        if (password == null || password.length() == 0) {
            throw new SyncPasswordException(1, null, null);
        }
        if (Configuration.getInstance().getBoolean("MobileEngine.Security.PasswordsToUpperCase", false)) {
            password = password.toUpperCase();
        }
        cu.setSyncPassword(password);
    }

    public boolean isSyncCredentialAvailable() {
        UserImpl u = this.getCurrentUserImpl();
        if (u == null || u.equals(UserManagerImpl.getSharedUser())) {
            return false;
        }
        if (u.getSSOTicket() != null && u.getSSOTicket().length() > 0) {
            return true;
        }
        return u.getSyncPassword() != null && u.getSyncPassword().length() != 0;
    }

    public Enumeration getAllUsers() {
        return this.listOfUsers.elements();
    }

    public void setUserPermissions(Vector authorizations) throws PermissionException {
        UserImpl cu = this.getCurrentUserImpl();
        String meUser = EMPTY_STRING;
        if (cu != null && !cu.equals(UserManagerImpl.getSharedUser())) {
            String userName = cu.getUniqueName();
            PermissionList permissionList = new PermissionList(userName);
            if (authorizations != null) {
                String oldFieldName = EMPTY_STRING;
                String oldAuthName = EMPTY_STRING;
                String objectName = EMPTY_STRING;
                String authName = EMPTY_STRING;
                String fieldName = EMPTY_STRING;
                String fromValue = EMPTY_STRING;
                String toValue = EMPTY_STRING;
                SinglePermission singlePermission = null;
                Field permField = null;
                Action permAction = null;
                int authorizationCounter = authorizations.size();
                int i = 0;
                while (i < authorizationCounter) {
                    Row currentRow = (Row)authorizations.elementAt(i);
                    meUser = this.getDescriptorValue(currentRow, "MEUSER");
                    objectName = this.getDescriptorValue(currentRow, "OBJCT");
                    authName = objectName + this.getDescriptorValue(currentRow, "AUTH");
                    fieldName = this.getDescriptorValue(currentRow, "FIELD");
                    fromValue = this.getDescriptorValue(currentRow, "VON");
                    toValue = this.getDescriptorValue(currentRow, "BIS");
                    if (!fieldName.equals(oldFieldName)) {
                        if (singlePermission != null) {
                            singlePermission.addField(permField);
                        }
                        permField = new Field(fieldName);
                        oldFieldName = fieldName;
                    }
                    permAction = new Action(fromValue, toValue);
                    permField.addAction(permAction);
                    if (!authName.equals(oldAuthName)) {
                        if (singlePermission != null) {
                            permissionList.add(singlePermission);
                        }
                        singlePermission = new SinglePermission(objectName);
                        oldAuthName = authName;
                    }
                    ++i;
                }
                if (singlePermission != null) {
                    if (permField != null) {
                        singlePermission.addField(permField);
                    }
                    permissionList.add(singlePermission);
                }
            }
            cu.setPermissionList(permissionList);
        }
    }

    public void addNewUser(String username, String password, String passwordConfirmation) throws LogonException {
        if (this.listOfUsers.size() > 0 && Configuration.getInstance().getBoolean("MobileEngine.UM.SingleUserMode", false)) {
            throw new LogonException(17);
        }
        this.checkUserName(username, true);
        if (password == null || password.length() == 0) {
            throw new LogonException(7);
        }
        if (passwordConfirmation == null || passwordConfirmation.length() == 0) {
            throw new LogonException(10);
        }
        if (Configuration.getInstance().getBoolean("MobileEngine.Security.PasswordsToUpperCase", false)) {
            password = password.toUpperCase();
            passwordConfirmation = passwordConfirmation.toUpperCase();
        }
        if (!password.equals(passwordConfirmation)) {
            throw new LogonException(10);
        }
        UserImpl newUser = this.getUserImpl(username);
        if (newUser != null) {
            throw new LogonException(4, new Object[]{username});
        }
        newUser = new UserImpl(username, password);
        this.addUser(newUser);
    }

    public void notifyMeOnInDelta() {
        AuthSyncBo authSyncBo = new AuthSyncBo();
        Vector authorizations = this.getAuthVector(authSyncBo);
        try {
            this.setUserPermissions(authorizations);
        }
        catch (PermissionException e) {
            e.printStackTrace();
        }
    }

    void addUser(User newUser) {
        if (newUser == null || newUser.getUniqueName() == null || SHARED_USER.getUniqueName().equalsIgnoreCase(newUser.getUniqueName())) {
            return;
        }
        User oldUser = this.getUser(newUser.getUniqueName());
        if (oldUser == null) {
            this.listOfUsers.put(newUser.getUniqueName(), newUser);
            this.saveUserList();
        }
    }

    void _clear() {
        this.listOfUsers.clear();
        this.setCurrentUser(null);
        this.saveUserList();
    }

    void _clearAndLoad() {
        this.listOfUsers.clear();
        this.setCurrentUser(null);
        this.readUserList();
    }

    public void addLogonListener(LogonListener l) {
        if (l != null && !this.logonListeners.contains(l)) {
            this.logonListeners.addElement(l);
        }
    }

    public void removeLogonListener(LogonListener l) {
        this.logonListeners.removeElement(l);
    }

    void addPasswordChangedListener(PasswordChangedListener l) {
        if (l != null && !this.passwordChangedListeners.contains(l)) {
            this.passwordChangedListeners.addElement(l);
        }
    }

    void removePasswordChangedListener(PasswordChangedListener l) {
        this.passwordChangedListeners.removeElement(l);
    }

    synchronized void saveUserList() {
        try {
            File f = new File(this.getFilename());
            File dir = new File(f.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Enumeration users = this.listOfUsers.elements();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(f));
            UserImpl u = null;
            char[] chars = null;
            while (users.hasMoreElements()) {
                u = (UserImpl)users.nextElement();
                chars = u.getObjectRepresentation();
                dout.writeShort(chars.length);
                int j = 0;
                while (j < chars.length) {
                    dout.writeChar(chars[j]);
                    ++j;
                }
            }
            dout.writeShort(Short.MAX_VALUE);
            dout.flush();
            dout.close();
        }
        catch (IOException ioex) {
            String message = "Cannot save user list to file: " + ioex.getMessage();
            AppLog.getInstance("MI/Core").logException(10, message, ioex, true);
            throw new RuntimeException(message);
        }
    }

    private Vector getAuthVector(AuthSyncBo authSyncBo) {
        Vector authorizations = null;
        UserImpl cu = this.getCurrentUserImpl();
        if (cu != null && !cu.equals(UserManagerImpl.getSharedUser())) {
            String userName = cu.getUniqueName();
            if (authSyncBo != null) {
                authorizations = authSyncBo.createQuery(userName);
            }
        }
        return authorizations;
    }

    private String getDescriptorValue(Row row, String fdName) {
        FieldDescriptor tmpFD;
        RowDescriptor rowDesc;
        String fieldValue = EMPTY_STRING;
        if (row != null && (rowDesc = row.getRowDescriptor()) != null && (tmpFD = rowDesc.getFieldDescriptor(fdName)) != null) {
            fieldValue = row.getFieldValue(tmpFD).toString();
        }
        return fieldValue;
    }

    private void checkUserName(String userName, boolean isFullCheckRequired) throws LogonException {
        if (userName == null || userName.length() == 0) {
            throw new LogonException(0, null, null);
        }
        if (UserManagerImpl.getSharedUser().getUniqueName().equalsIgnoreCase(userName)) {
            throw new LogonException(5, new Object[]{userName}, null);
        }
        if (!isFullCheckRequired) {
            return;
        }
        int i = 0;
        while (i < UNSUPPORTED_CHARACTERS.length()) {
            if (userName.indexOf(UNSUPPORTED_CHARACTERS.charAt(i)) >= 0) {
                Character invalidChar = new Character(UNSUPPORTED_CHARACTERS.charAt(i));
                throw new LogonException(6, new Object[]{userName, invalidChar.toString()}, null);
            }
            ++i;
        }
    }

    private void readUserList() {
        Hashtable<String, UserImpl> newUsers = new Hashtable<String, UserImpl>();
        try {
            File f = new File(this.getFilename());
            DataInputStream din = new DataInputStream(new FileInputStream(f));
            UserImpl u = null;
            char[] chars = null;
            while (din.available() > 0) {
                short bytes = din.readShort();
                if (bytes == Short.MAX_VALUE) break;
                chars = new char[bytes];
                int j = 0;
                while (j < chars.length) {
                    chars[j] = din.readChar();
                    ++j;
                }
                u = new UserImpl("init", "Initial");
                if (!u.setObjectRepresentation(chars)) continue;
                newUsers.put(u.getUniqueName(), u);
            }
            din.close();
        }
        catch (IOException ioex) {
            String message = "Cannot read user list from file: " + ioex.getMessage();
            AppLog.getInstance("MI/Core").logException(10, message, ioex, true);
            throw new RuntimeException(message);
        }
        if (newUsers.size() > 0) {
            this.listOfUsers.clear();
            Enumeration enumeration = newUsers.elements();
            User u = null;
            while (enumeration.hasMoreElements()) {
                u = (User)enumeration.nextElement();
                this.listOfUsers.put(u.getUniqueName(), u);
            }
        }
    }

    private String getFilename() {
        return new StringBuffer(Configuration.getSettingsFolder().length() + USERS_DAT_FILE_NAME.length()).append(Configuration.getSettingsFolder()).append(USERS_DAT_FILE_NAME).toString();
    }

    private void fireLogon(User u) {
        Enumeration enumeration = this.logonListeners.elements();
        LogonListener l = null;
        while (enumeration.hasMoreElements()) {
            l = (LogonListener)enumeration.nextElement();
            l.userLoggedOn(u);
        }
    }

    private void fireLocalPasswordChanged(User u) {
        Trace trace = Trace.getInstance("MI/Core");
        if (trace.isLogging(90)) {
            trace.log(90, "Fire local password changed for user {0}", (Object)u);
        }
        Enumeration enumeration = this.passwordChangedListeners.elements();
        PasswordChangedListener l = null;
        while (enumeration.hasMoreElements()) {
            l = (PasswordChangedListener)enumeration.nextElement();
            l.localPasswordChanged(u);
        }
    }

    private void setCurrentUser(UserImpl newUser) {
        Trace trace = Trace.getInstance("MI/Core");
        if (this.temporaryCurrentUser != null && (newUser != null && !newUser.equals(this.currentUser) || newUser != this.temporaryCurrentUser)) {
            trace.log(60, "Userswitch while temporary user is set. Current temporary user is {0}, current user is {1} and new user is {2}", this.temporaryCurrentUser, this.currentUser, newUser);
        }
        if (newUser != this.currentUser) {
            trace.log(80, "Set current user to " + (newUser == null ? "null" : newUser.getUniqueID()));
        }
        this.currentUser = newUser;
    }

    UserImpl setTemporaryCurrentUser(User newUser) {
        if (newUser != null && this.getUser(newUser.getUniqueID()) != newUser) {
            throw new IllegalArgumentException("Cannot set unknown user '" + newUser.getUniqueID() + "' as temporary current user");
        }
        UserImpl oldTempUser = this.temporaryCurrentUser;
        this.temporaryCurrentUser = (UserImpl)newUser;
        this.temporaryCurrentUserThread = newUser != null ? Thread.currentThread() : null;
        return oldTempUser;
    }

    private InputStream getInputStreamFromURLConnection(URLConnection connection, long timeout) throws IOException {
        URLInputStreamFetcher fetcher = new URLInputStreamFetcher(connection);
        long sleepingtime = timeout / 50L;
        Trace.getInstance("MI/Core").log(90, "Sleeping interval to wait for Mobile Infrastructure Server to respond is" + sleepingtime / 1000L + " seconds");
        fetcher.start();
        for (int tries = 0; tries < 50; ++tries) {
            try {
                if (fetcher.isFinished) break;
                Thread.sleep(sleepingtime);
                continue;
            }
            catch (InterruptedException e) {
                Trace.getInstance("MI/Core").logException(e);
                break;
            }
        }
        return fetcher.getInputStream();
    }

    static {
        String key = "MobileEngine.Reg.UserManager.Implementation";
        Properties props = System.getProperties();
        UserManagerImpl singletonInstance = (UserManagerImpl)((Hashtable)props).get(key);
        Trace tr = Trace.getInstance("MI/Core");
        if (singletonInstance == null) {
            try {
                singletonInstance = new UserManagerImpl();
                if (tr.isLogging(90)) {
                    tr.log(90, "New UserManager SINGLETON created : {0} ", (Object)singletonInstance);
                }
                ((Hashtable)props).put(key, singletonInstance);
            }
            catch (Exception t) {
                AppLog.getInstance("MI/Core").logException(10, "Cannot instantiate UserManager", t, true);
                throw new RuntimeException("Startup aborted because user manager cannot be instanitated!");
            }
        } else if (tr.isLogging(90)) {
            tr.log(90, "Reuse SINGLETON-instance for {0}: {1} ", (Object)key, (Object)singletonInstance);
        }
        instance = singletonInstance;
        UserManager.setInstance(instance);
    }

    private class URLInputStreamFetcher
    extends Thread {
        private InputStream inputStream;
        private URLConnection connection;
        private boolean isFinished;

        private URLInputStreamFetcher(URLConnection connection) {
            this.connection = connection;
            this.inputStream = null;
            this.isFinished = false;
        }

        public void run() {
            while (!this.isFinished) {
                try {
                    this.inputStream = this.connection.getInputStream();
                    this.isFinished = true;
                }
                catch (IOException e) {
                    Trace.getInstance("MI/Core").logException(e);
                    this.isFinished = true;
                }
            }
        }

        private InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                Trace trace = Trace.getInstance("MI/Core");
                trace.log(50, "No InputStream available from: " + this.connection.getURL().toExternalForm());
                throw new IOException("Server not reachable");
            }
            return this.inputStream;
        }
    }
}

