/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.security.Permission;
import com.sap.ip.me.api.security.PermissionEntry;
import com.sap.ip.me.api.security.PermissionException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.security.permission.PermissionList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class UserImpl
implements User {
    private String logonName;
    private String firstName = "";
    private String lastName = "";
    private String logonPasswordHash = null;
    private transient String logonPassword = null;
    private transient String syncPassword = null;
    private transient String mySAPSSO2Ticket = null;
    private PermissionList permissionList;
    private int logonFailuresCounter;

    UserImpl(String logonName, String logonPassword) {
        this.logonName = logonName.trim().toUpperCase();
        StringBuffer input = new StringBuffer(this.logonName).append(logonPassword);
        this.logonPasswordHash = SecurityManager.getInstance().getOneWayHash(input.toString());
        this.logonPassword = logonPassword;
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            this.syncPassword = logonPassword;
        }
        this.logonFailuresCounter = 0;
    }

    public String getUniqueName() {
        return this.logonName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String toString() {
        String fullname = this.getName();
        if (fullname.length() == 0) {
            return this.logonName;
        }
        return new StringBuffer(this.logonName.length() + fullname.length() + " ()".length()).append(this.logonName).append(" (").append(fullname).append(")").toString();
    }

    public boolean verifyPassword(String password) {
        StringBuffer input = new StringBuffer(this.logonName).append(password);
        String pwHash = SecurityManager.getInstance().getOneWayHash(input.toString());
        if (this.logonPasswordHash.equals(pwHash)) {
            this.logonPassword = password;
            if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
                this.syncPassword = this.logonPassword;
            }
            if (!this.isLocked()) {
                this.logonFailuresCounter = 0;
            }
            return true;
        }
        int numOfAllowedLogonFailures = Configuration.getInstance().getInt("MobileEngine.Security.AllowedLogonFailuresUntilUserLock", -1);
        if (numOfAllowedLogonFailures > -1 && this.logonFailuresCounter < numOfAllowedLogonFailures + 1) {
            ++this.logonFailuresCounter;
        }
        return false;
    }

    boolean isLocked() {
        int numOfAllowedLogonFailures = Configuration.getInstance().getInt("MobileEngine.Security.AllowedLogonFailuresUntilUserLock", -1);
        if (numOfAllowedLogonFailures > -1) {
            return this.logonFailuresCounter > numOfAllowedLogonFailures;
        }
        return false;
    }

    void unlock() {
        this.logonFailuresCounter = 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof UserImpl && this.logonName.equals(((UserImpl)other).getUniqueName());
    }

    public int hashCode() {
        return this.logonName.hashCode();
    }

    boolean setFirstName(String firstName) {
        boolean modified = false;
        if (firstName == null) {
            modified = false;
        } else if (this.firstName.equals(firstName)) {
            modified = false;
        } else {
            modified = true;
            this.firstName = firstName;
        }
        return modified;
    }

    boolean setLastName(String lastName) {
        boolean modified = false;
        if (lastName == null) {
            modified = false;
        } else if (this.lastName.equals(lastName)) {
            modified = false;
        } else {
            modified = true;
            this.lastName = lastName;
        }
        return modified;
    }

    void setLogonPassword(String newLogonPassword) {
        String newLocalPasswordHash;
        StringBuffer input = new StringBuffer(this.logonName).append(newLogonPassword);
        this.logonPasswordHash = newLocalPasswordHash = SecurityManager.getInstance().getOneWayHash(input.toString());
        this.logonPassword = newLogonPassword;
        if (SyncPasswordHandlingOption.LOCAL == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
            this.syncPassword = this.logonPassword;
        }
    }

    String getLogonPassword() {
        return this.logonPassword;
    }

    void setSyncPassword(String syncPassword) {
        this.syncPassword = syncPassword;
    }

    public String getSyncPassword() {
        return this.syncPassword;
    }

    void setSSOTicket(String ticket) {
        this.mySAPSSO2Ticket = ticket;
    }

    public String getSSOTicket() {
        return this.mySAPSSO2Ticket;
    }

    char[] getObjectRepresentation() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.logonName).append("&&");
        sb.append(this.logonPasswordHash).append("&&");
        sb.append(this.firstName).append("&&");
        sb.append(this.lastName).append("&&");
        sb.append(Integer.toString(this.logonFailuresCounter)).append("&&");
        String r = SecurityManager.getInstance().encode(sb.toString());
        return r.toCharArray();
    }

    boolean setObjectRepresentation(char[] newObjectRepresentation) {
        String s = SecurityManager.getInstance().decode(new String(newObjectRepresentation));
        int start = 0;
        int end = -1;
        end = s.indexOf("&&");
        if (end >= 0) {
            this.logonName = s.substring(0, end);
            start = end + 2;
            end = s.indexOf("&&", start);
            this.logonPasswordHash = s.substring(start, end);
            start = end + 2;
            end = s.indexOf("&&", start);
            this.firstName = s.substring(start, end);
            start = end + 2;
            end = s.indexOf("&&", start);
            this.lastName = s.substring(start, end);
            start = end + 2;
            this.logonFailuresCounter = (end = s.indexOf("&&", start)) > -1 ? Integer.parseInt(s.substring(start, end)) : 0;
            this.logonPassword = null;
            return true;
        }
        return false;
    }

    public void checkPermission(Permission permission) throws Exception {
        if (!this.hasPermission(permission)) {
            throw new PermissionException();
        }
    }

    public String getCellPhone() {
        throw new RuntimeException("Method not supported");
    }

    public String getFax() {
        throw new RuntimeException("Method not supported");
    }

    public String getEmail() {
        throw new RuntimeException("Method not supported");
    }

    public boolean isCompanyUser() {
        throw new RuntimeException("Method not supported");
    }

    public String getCompany() {
        throw new RuntimeException("Method not supported");
    }

    public int getAccessibilityLevel() {
        throw new RuntimeException("Method not supported");
    }

    public boolean isMemberOfRole(String uniqueIdOfRole, boolean recursive) {
        throw new RuntimeException("Method not supported");
    }

    public boolean isMemberOfGroup(String uniqueIdOfGroup, boolean recursive) {
        throw new RuntimeException("Method not supported");
    }

    public Object getTransientAttribute(String namespace, String name) {
        throw new RuntimeException("Method not supported");
    }

    public boolean setTransientAttribute(String namespace, String name, Object o) {
        throw new RuntimeException("Method not supported");
    }

    public String getName() {
        if (this.firstName.length() == 0 && this.lastName.length() == 0) {
            return Configuration.getInstance().getProperty("MobileEngine.Sync.LongUserName", "");
        }
        StringBuffer name = new StringBuffer(this.firstName.length() + this.lastName.length());
        name.append(this.firstName);
        if (this.firstName.length() > 0 && this.lastName.length() > 0) {
            name.append(" ");
        }
        name.append(this.lastName);
        return name.toString();
    }

    public String getAttributeType(String namespace, String attributeName) {
        throw new RuntimeException("Method not supported");
    }

    public boolean isMutable() {
        throw new RuntimeException("Method not supported");
    }

    public void refresh() throws Exception {
        throw new RuntimeException("Method not supported");
    }

    public boolean isExistenceChecked() {
        throw new RuntimeException("Method not supported");
    }

    public String getDisplayName() {
        if (this.firstName.length() == 0 && this.lastName.length() == 0) {
            return Configuration.getInstance().getProperty("MobileEngine.Sync.LongUserName", "");
        }
        StringBuffer name = new StringBuffer(this.firstName.length() + this.lastName.length());
        name.append(this.firstName);
        if (this.firstName.length() > 0 && this.lastName.length() > 0) {
            name.append(" ");
        }
        name.append(this.lastName);
        return name.toString();
    }

    public String[] getAttributeNames(String namespace) {
        throw new RuntimeException("Method not supported");
    }

    public String[] getAttributeNamespaces() {
        throw new RuntimeException("Method not supported");
    }

    public byte[] getBinaryAttribute(String namespace, String name) {
        throw new RuntimeException("Method not supported");
    }

    public String[] getAttribute(String namespace, String name) {
        throw new RuntimeException("Method not supported");
    }

    public Date lastModified() {
        throw new RuntimeException("Method not supported");
    }

    public Date created() {
        throw new RuntimeException("Method not supported");
    }

    public String getUniqueID() {
        return this.getUniqueName();
    }

    void setPermissionList(PermissionList permissionList) {
        this.permissionList = permissionList;
    }

    public boolean hasPermission(Permission permission) {
        if (permission != null) {
            Vector permissionList = permission.get();
            int permissionCount = permissionList.size();
            if (permissionCount < 1) {
                return false;
            }
            int i = 0;
            while (i < permissionCount) {
                PermissionEntry permissionEntry = (PermissionEntry)permissionList.elementAt(i);
                if (!PermissionList.check(this.permissionList, permissionEntry)) {
                    System.out.println("Permission (" + permissionEntry + ") NOT okay");
                    return false;
                }
                System.out.println("Permission (" + permissionEntry + ") okay");
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getCity() {
        return null;
    }

    public String getCountry() {
        return null;
    }

    public String getCurrency() {
        return null;
    }

    public String getDepartment() {
        return null;
    }

    public String getJobTitle() {
        return null;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getSalutation() {
        return null;
    }

    public String getState() {
        return null;
    }

    public String getStreet() {
        return null;
    }

    public String getTelephone() {
        return null;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public String getTitle() {
        return null;
    }

    public String getUid() {
        return null;
    }

    public String getZip() {
        return null;
    }
}

