/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.DCPackagingConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public class SyncSettings {
    private static final Trace trace = Trace.getInstance("MI/Sync");
    private static boolean newProtocolActive = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false);

    private SyncSettings() {
    }

    public static boolean isNewProtocolActive() {
        return newProtocolActive;
    }

    public static String getEnhancedSyncGatewayURL() {
        return SyncSettings.getUrlPrefix();
    }

    public static String getSyncGateway() {
        Configuration configuration = Configuration.getInstance();
        String protocol = configuration.getProperty("MobileEngine.Sync.Gateway.Protocol", "");
        String host = configuration.getProperty("MobileEngine.Sync.Gateway.Host", "");
        String port = configuration.getProperty("MobileEngine.Sync.Gateway.Port", "");
        String system = configuration.getProperty("MobileEngine.Sync.Gateway.System", "");
        if (protocol.length() == 0) {
            trace.log("synchronization protocol is not set");
            protocol = "NO_PROTOCOL_SET";
        }
        if (host.length() == 0) {
            trace.log("synchronization host is not set");
            host = "NO_HOST_SET";
        }
        if (port.length() == 0) {
            trace.log("synchronization port is not set");
            port = "NO_PORT_SET";
        }
        if (system.length() == 0) {
            trace.log("synchronization backend system id is not set");
            system = "NO_SYSTEM_ID_SET";
        }
        StringBuffer gatewayURL = new StringBuffer();
        gatewayURL.append(protocol);
        gatewayURL.append("://");
        gatewayURL.append(host);
        gatewayURL.append(":");
        gatewayURL.append(port);
        gatewayURL.append("/meSync/servlet/meSync?~sysid=");
        gatewayURL.append(system);
        gatewayURL.append("&");
        return gatewayURL.toString();
    }

    private static String getUrlPrefix() {
        Configuration configuration = Configuration.getInstance();
        String syncGateway = SyncSettings.getSyncGateway();
        String client = configuration.getProperty("MobileEngine.Sync.Client", "").trim();
        client = IOUtils.utf8AndUrlEncode(client);
        String language = configuration.getProperty("MobileEngine.Sync.Language", "").trim();
        language = IOUtils.utf8AndUrlEncode(language);
        StringBuffer urlStringB = new StringBuffer();
        urlStringB.append(syncGateway);
        if (client != null) {
            urlStringB.append("~client=").append(client).append('&');
        }
        if (language != null) {
            urlStringB.append("~language=").append(language).append('&');
        }
        String urlString = urlStringB.toString();
        return urlString;
    }

    public static String createUrlString() {
        long packagesize;
        StringBuffer urlBuffer = new StringBuffer(SyncSettings.getUrlPrefix());
        DCPackagingConfiguration dcconfig = new DCPackagingConfiguration(false);
        if (dcconfig.isActivated() && (packagesize = dcconfig.getMaximumPackageSize()) > 0L) {
            urlBuffer.append("PACKET_SIZE=").append(packagesize).append('&');
        }
        if (SyncSettings.isNewProtocolActive() && !ConversationIdHandler.getInstance().getCurrentConversationId().isGeneratedOnServer()) {
            urlBuffer.append("ACKNOWLEDGE=&");
        } else {
            urlBuffer.append("ACKNOWLEDGE=X&");
        }
        return urlBuffer.toString();
    }

    public static boolean isReadyForSynchronization() {
        Configuration config = Configuration.getInstance();
        return !"".equals(config.getProperty("MobileEngine.Sync.Client", "")) && !"".equals(config.getProperty("MobileEngine.Sync.Gateway.Protocol", "")) && !"".equals(config.getProperty("MobileEngine.Sync.Gateway.Host", "")) && !"".equals(config.getProperty("MobileEngine.Sync.Gateway.Port", "")) && !"".equals(config.getProperty("MobileEngine.Sync.Gateway.System", "")) && UserManagerImpl.getUserManagerImplInstance().getCurrentUser() != null;
    }

    public static void updateSystemProxySettings() {
        Properties props = System.getProperties();
        Configuration config = Configuration.getInstance();
        boolean proxyUsed = config.getBoolean("MobileEngine.Sync.Proxyused", false);
        if (proxyUsed) {
            Trace.getInstance("MI/Sync").log(80, "Use http proxy (system properties update)");
            String proxyHost = config.getProperty("MobileEngine.Sync.Proxyhost", "");
            String proxyPort = config.getProperty("MobileEngine.Sync.Proxyport", "");
            ((Hashtable)props).put("http.proxyHost", proxyHost);
            ((Hashtable)props).put("http.proxyPort", proxyPort);
            if (config.getBoolean("MobileEngine.Security.SSLSupport", false)) {
                ((Hashtable)props).put("https.proxyHost", proxyHost);
                ((Hashtable)props).put("https.proxyPort", proxyPort);
            }
            String gatewayIts = SyncSettings.getSyncGateway();
            String byPass = "";
            try {
                if (proxyUsed) {
                    byPass = "";
                } else {
                    URL its = new URL(gatewayIts);
                    byPass = its.getHost();
                }
            }
            catch (MalformedURLException urlex) {
                AppLog.getInstance("MI/Sync").logException(60, "Cannot set bypass url", urlex, false);
                byPass = "";
            }
            ((Hashtable)props).put("http.nonProxyHosts", byPass);
            ((Hashtable)props).put("proxySet", "true");
            ((Hashtable)props).put("proxyHost", proxyHost);
            ((Hashtable)props).put("proxyPort", proxyPort);
        } else {
            Trace.getInstance("MI/Sync").log(80, "Do not use http proxy (system properties update)");
            ((Hashtable)props).remove("http.proxyHost");
            ((Hashtable)props).remove("http.proxyPort");
            if (config.getBoolean("MobileEngine.Security.SSLSupport", false)) {
                ((Hashtable)props).remove("https.proxyHost");
                ((Hashtable)props).remove("https.proxyPort");
            }
            ((Hashtable)props).remove("http.nonProxyHosts");
            ((Hashtable)props).put("proxySet", "false");
        }
        System.setProperties(props);
    }
}

