/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.core.FrameworkInitializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Startup
extends ClassLoader {
    private static final String ME_HOME_PLACEHOLDER = "%ME_HOME%";
    static PrintWriter out = null;
    ClassLoader cl = null;
    String rootfolder = "";
    Vector folders = new Vector(20);
    private static boolean DEBUG = false;
    static /* synthetic */ Class class$com$sap$ip$me$core$Startup;

    private Startup(ClassLoader originalCL, String rootfolder) {
        if (DEBUG) {
            out.println("Instantiate MERootClassLoader instance with parent = " + originalCL);
        }
        this.cl = originalCL;
        this.rootfolder = rootfolder;
        this.initialize();
    }

    private final void initialize() {
        String jarfilename = this.rootfolder + File.separator + "listOfJars.txt";
        File jarListFile = new File(jarfilename);
        StringTokenizer tokenizer = new StringTokenizer(Startup.readJarListFile(jarListFile), ";", false);
        StringBuffer adjustedJarFileContent = new StringBuffer(512);
        boolean containsPlaceholder = false;
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            if (path.startsWith(ME_HOME_PLACEHOLDER)) {
                path = this.rootfolder + path.substring(ME_HOME_PLACEHOLDER.length());
                containsPlaceholder = true;
            }
            adjustedJarFileContent.append(path).append(';');
            System.out.println("Collect jar: " + path);
            try {
                MapEntry m = new MapEntry(new ZipFile(path));
                this.folders.addElement(m);
            }
            catch (IOException ioex) {
                if (!DEBUG) continue;
                out.println("Cannot add zip file " + path + " because of " + ioex.getMessage());
                ioex.printStackTrace(out);
            }
        }
        if (containsPlaceholder) {
            Startup.writeJarListFile(jarListFile, adjustedJarFileContent.toString());
        }
        File webappsFolder = new File(this.rootfolder + File.separator + "webapps");
        if (DEBUG) {
            out.println("Webappsfolder = " + webappsFolder.getAbsolutePath() + " (" + (webappsFolder.isDirectory() ? "D" : "F") + "," + (webappsFolder.exists() ? "E" : "N") + ")");
        }
        if (webappsFolder != null && webappsFolder.exists() && webappsFolder.isDirectory()) {
            String[] wars = webappsFolder.list(new WarFileFilter());
            if (DEBUG) {
                out.println("Found " + wars.length + " war files within the webapps folder");
            }
            String webappsFolderString = webappsFolder.getAbsolutePath();
            File f = null;
            String fullWarFilename = null;
            int i = 0;
            while (i < wars.length) {
                f = new File(webappsFolderString + File.separatorChar + wars[i].substring(0, wars[i].length() - 4));
                fullWarFilename = webappsFolderString + File.separator + wars[i];
                if (f.exists()) {
                    out.println("Do NOT extract '" + fullWarFilename + "' because corresponding webapps folder already exists");
                } else {
                    this.extractWarFile(webappsFolderString + File.separator + wars[i], f);
                }
                ++i;
            }
            String[] apps = webappsFolder.list(new DirectoryFilter(webappsFolder));
            if (DEBUG) {
                out.println("Found " + apps.length + " webapps");
            }
            int i2 = 0;
            while (i2 < apps.length) {
                File libfolder = new File(webappsFolder.getAbsolutePath() + File.separator + apps[i2] + File.separator + "WEB-INF" + File.separator + "lib");
                if (DEBUG) {
                    out.println("libfolder = " + libfolder.getAbsolutePath() + " (" + (libfolder.isDirectory() ? "D" : "F") + "," + (libfolder.exists() ? "E" : "N") + ")");
                }
                File classesfolder = new File(webappsFolder.getAbsolutePath() + File.separator + apps[i2] + File.separator + "WEB-INF" + File.separator + "classes");
                if (DEBUG) {
                    out.println("classesfolder = " + classesfolder.getAbsolutePath() + " (" + (classesfolder.isDirectory() ? "D" : "F") + "," + (classesfolder.exists() ? "E" : "N") + ")");
                }
                if (classesfolder.exists() && classesfolder.isDirectory()) {
                    MapEntry m = new MapEntry(classesfolder);
                    this.folders.addElement(m);
                }
                if (libfolder.exists() && libfolder.isDirectory()) {
                    String[] archives = libfolder.list(new FileFilter(true));
                    int j = 0;
                    while (j < archives.length) {
                        block20: {
                            try {
                                MapEntry m = new MapEntry(new ZipFile(libfolder.getAbsolutePath() + File.separator + archives[j]));
                                this.folders.addElement(m);
                            }
                            catch (IOException ioex) {
                                if (!DEBUG) break block20;
                                out.println("Cannot add zip file " + archives[j] + " because of " + ioex.getMessage());
                                ioex.printStackTrace(out);
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
    }

    /*
     * Loose catch block
     */
    private final void extractWarFile(String warfile, File targetDir) {
        File warFile;
        boolean allright;
        block33: {
            Exception ex222222;
            ZipFile zipfile;
            FilterOutputStream bos;
            BufferedInputStream bis;
            block29: {
                if (warfile == null || targetDir == null || warfile.length() < 1) {
                    out.println("Cannot extract war file '" + warfile + "' to folder '" + targetDir.getAbsolutePath() + "'");
                    return;
                }
                out.println("Extract war file '" + warfile + "' to folder '" + targetDir.getAbsolutePath() + "'");
                String targetFolder = targetDir.getAbsolutePath();
                bis = null;
                bos = null;
                zipfile = null;
                allright = true;
                warFile = new File(warfile);
                zipfile = new ZipFile(warFile);
                Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
                ZipEntry zipentry = null;
                while (enumeration.hasMoreElements()) {
                    zipentry = enumeration.nextElement();
                    out.println("Extracting " + warfile + ": Zip-Entry: '" + zipentry.getName() + "'");
                    if (!zipentry.isDirectory()) {
                        int lastSeperatorPos = zipentry.getName().lastIndexOf("/");
                        String folder = lastSeperatorPos >= 0 ? zipentry.getName().substring(0, lastSeperatorPos + 1) : null;
                        String name = lastSeperatorPos >= 0 ? zipentry.getName().substring(lastSeperatorPos + 1) : zipentry.getName();
                        out.println("Extracting " + warfile + ": Create file '" + targetFolder + "' + '" + File.separatorChar + "' + '" + (folder != null ? folder.replace('/', File.separatorChar) : "") + "' + '" + name + "'");
                        File tempFile = new File(targetFolder + File.separatorChar + (folder != null ? folder.replace('/', File.separatorChar) : "") + name);
                        File dir = new File(tempFile.getParent());
                        dir.mkdirs();
                        InputStream is = zipfile.getInputStream(zipentry);
                        bis = new BufferedInputStream(is);
                        FileOutputStream fos = new FileOutputStream(tempFile.getAbsolutePath());
                        bos = new BufferedOutputStream(fos);
                        int sz = (int)zipentry.getSize();
                        int ln = 0;
                        int N = 512;
                        byte[] buf = new byte[512];
                        while (sz > 0 && (ln = bis.read(buf, 0, Math.min(512, sz))) != -1) {
                            ((BufferedOutputStream)bos).write(buf, 0, ln);
                            sz -= ln;
                        }
                        bos.close();
                        bis.close();
                        continue;
                    }
                    File currentdir = new File(targetFolder + File.separatorChar + zipentry.getName());
                    out.println("Extracting " + warfile + ": Create dir '" + currentdir.getAbsolutePath() + "' - State: " + (currentdir.exists() ? "E" : "N"));
                    if (currentdir.exists()) continue;
                    currentdir.mkdirs();
                }
                Object var23_24 = null;
                if (bos == null) break block29;
                try {
                    bos.close();
                }
                catch (Exception ex222222) {
                    allright = false;
                    out.println("Cannot extract war file '" + warfile + "'.");
                    ex222222.printStackTrace(out);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ex222222) {
                    allright = false;
                    out.println("Cannot extract war file '" + warfile + "'.");
                    ex222222.printStackTrace(out);
                }
            }
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (Exception ex222222) {
                    allright = false;
                    out.println("Cannot extract war file '" + warfile + "'.");
                    ex222222.printStackTrace(out);
                }
            }
            break block33;
            {
                catch (IOException ioex) {
                    Exception ex222222;
                    allright = false;
                    out.println("Cannot extract war file '" + warfile + "'.");
                    ioex.printStackTrace(out);
                    Object var23_25 = null;
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Exception ex222222) {
                            allright = false;
                            out.println("Cannot extract war file '" + warfile + "'.");
                            ex222222.printStackTrace(out);
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception ex222222) {
                            allright = false;
                            out.println("Cannot extract war file '" + warfile + "'.");
                            ex222222.printStackTrace(out);
                        }
                    }
                    if (zipfile != null) {
                        try {
                            zipfile.close();
                        }
                        catch (Exception ex222222) {
                            allright = false;
                            out.println("Cannot extract war file '" + warfile + "'.");
                            ex222222.printStackTrace(out);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception ex222222;
                Object var23_26 = null;
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception ex222222) {
                        allright = false;
                        out.println("Cannot extract war file '" + warfile + "'.");
                        ex222222.printStackTrace(out);
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ex222222) {
                        allright = false;
                        out.println("Cannot extract war file '" + warfile + "'.");
                        ex222222.printStackTrace(out);
                    }
                }
                if (zipfile != null) {
                    try {
                        zipfile.close();
                    }
                    catch (Exception ex222222) {
                        allright = false;
                        out.println("Cannot extract war file '" + warfile + "'.");
                        ex222222.printStackTrace(out);
                    }
                }
                throw throwable;
            }
        }
        if (allright) {
            out.println("Delete " + warfile + ": State: " + (warFile.delete() ? "deleted" : "cannot be deleted"));
        }
    }

    public static boolean deleteDirectoryRecursively(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.isFile()) {
            return dir.delete();
        }
        if (dir.exists()) {
            int max;
            String[] elements = dir.list();
            boolean result = true;
            int n = max = elements == null ? 0 : elements.length;
            if (elements != null) {
                int i = 0;
                while (i < max) {
                    result = result && Startup.deleteDirectoryRecursively(new File(dir, elements[i]));
                    ++i;
                }
            }
            result = result && dir.delete();
            return result;
        }
        return false;
    }

    public static void main(String[] args) {
        block16: {
            String instBase = "";
            boolean traceClassloader = false;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-home:")) {
                    instBase = args[i].substring("-home:".length());
                } else if (args[i].equalsIgnoreCase("-trace")) {
                    traceClassloader = true;
                } else if (args[i].equalsIgnoreCase("-stop")) {
                    traceClassloader = false;
                    DEBUG = false;
                }
                ++i;
            }
            Startup.CleanUpDeinstalledApplicationSources(instBase);
            try {
                String javaVersion = System.getProperty("java.version");
                if (javaVersion != null && (javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3") || javaVersion.startsWith("1.4"))) {
                    System.out.println("Use the MobileEngine classloader");
                    if (traceClassloader) {
                        DEBUG = true;
                        File f = new File(instBase + File.separator + "mestart.log");
                        f.delete();
                        try {
                            out = new PrintWriter(new FileOutputStream(f), true);
                        }
                        catch (IOException ioex) {
                            out = null;
                        }
                    }
                    if (out == null) {
                        out = new PrintWriter(System.out);
                    }
                    Startup rootCl = new Startup((class$com$sap$ip$me$core$Startup == null ? (class$com$sap$ip$me$core$Startup = Startup.class$("com.sap.ip.me.core.Startup")) : class$com$sap$ip$me$core$Startup).getClassLoader(), instBase);
                    try {
                        Class startup = rootCl.loadClass("com.sap.ip.me.core.FrameworkInitializer", true);
                        Method mainMethod = startup.getMethod("main", args.getClass());
                        mainMethod.invoke((Object)mainMethod, new Object[]{args});
                    }
                    catch (Exception ex) {
                        if (DEBUG) {
                            out.println("Cannot initialize dynamically: " + ex.getMessage());
                            ex.printStackTrace(out);
                        }
                        break block16;
                    }
                }
                System.out.println("Do not use the MobileEngine classloader");
                FrameworkInitializer.main(args);
            }
            catch (Throwable t) {
                System.err.println("Exception within Startup.main" + t.getMessage());
                t.printStackTrace(System.err);
            }
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream result;
        block8: {
            if (name == null) {
                return null;
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (DEBUG) {
                out.println("       MERootClassLoader.getResourceAsStream(" + name + ")");
            }
            result = null;
            try {
                MapEntry me = this.findMapEntry(name);
                if (me != null) {
                    if (DEBUG) {
                        out.println("Found right class = " + name + ", within = " + me.getLocation());
                    }
                    result = me.getInputstream(name);
                }
            }
            catch (Exception ex) {
                if (!DEBUG) break block8;
                out.println("Exception while loading class " + name + ": " + ex.getMessage());
                ex.printStackTrace(out);
            }
        }
        if (result == null && this.cl != null) {
            result = this.cl.getResourceAsStream(name);
        }
        return result;
    }

    public URL getResource(String name) {
        if (DEBUG) {
            out.println("       MERootClassLoader.getResource(" + name + ")");
        }
        if (this.cl != null) {
            return this.cl.getResource(name);
        }
        return null;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        block10: {
            result = null;
            result = super.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            String classname = name.replace('.', '/') + ".class";
            if (DEBUG) {
                out.println("       MERootClassLoader.loadClass(" + name + ", " + resolve + ")");
            }
            try {
                MapEntry me = this.findMapEntry(classname);
                if (me != null) {
                    if (DEBUG) {
                        out.println("Found right class = " + classname + ", within = " + me.getLocation());
                    }
                    int size = me.getSize(classname);
                    BufferedInputStream in = new BufferedInputStream(me.getInputstream(classname), size);
                    byte[] classdef = new byte[size];
                    int offset = 0;
                    int readBytes = 0;
                    while (offset < size) {
                        readBytes = in.read(classdef, offset, classdef.length - offset);
                        offset += readBytes;
                    }
                    result = super.defineClass(name, classdef, 0, size);
                    in.close();
                }
                if (result == null && this.cl != null) {
                    result = this.cl.loadClass(name);
                }
            }
            catch (Exception ex) {
                if (!DEBUG) break block10;
                out.println("Exception while loading class " + name + ": " + ex.getMessage());
                ex.printStackTrace(out);
            }
        }
        if (result == null) {
            result = super.findSystemClass(name);
        }
        if (result == null) {
            throw new ClassNotFoundException("MERootClassLoader cannot load class " + name);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void CleanUpDeinstalledApplicationSources(String instDir) {
        File f = new File(instDir + File.separator + "cleanuplist.txt");
        String toBeDeleted = Startup.readJarListFile(f);
        StringBuffer deletionFailed = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(toBeDeleted, File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            boolean success;
            String path = tokenizer.nextToken();
            System.out.print("Delete ");
            System.out.println(path);
            File fileToBeDeleted = new File(path);
            if (!fileToBeDeleted.exists() || (success = Startup.deleteDirectoryRecursively(new File(path)))) continue;
            System.out.print("Deletion failed for: ");
            System.out.println(path);
            deletionFailed.append(path);
            deletionFailed.append(File.pathSeparator);
        }
        FileWriter writer = null;
        writer = new FileWriter(f);
        writer.write(deletionFailed.toString());
        Object var9_9 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                System.out.println("saving of not deleted sources failed");
                e.printStackTrace();
                Object var9_10 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static String readJarListFile(File f) {
        StringBuffer fileContent;
        block22: {
            Exception e222;
            InputStreamReader isr;
            FileInputStream fis;
            block20: {
                String line;
                fileContent = new StringBuffer();
                String encoding = "UTF8";
                fis = null;
                isr = null;
                fis = new FileInputStream(f);
                int i = fis.read();
                int j = fis.read();
                fis.close();
                if (i == 255 && j == 254 || i == 254 && j == 255) {
                    encoding = "Unicode";
                }
                isr = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
                BufferedReader in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    void var8_9;
                    fileContent.append((String)var8_9);
                }
                Object var10_10 = null;
                if (fis == null) break block20;
                try {
                    fis.close();
                }
                catch (Exception e222) {
                    // empty catch block
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e222) {}
            }
            break block22;
            {
                catch (IOException e3) {
                    Exception e222;
                    if (DEBUG) {
                        out.println("Exception while loading jar list file: " + e3.getMessage());
                        e3.printStackTrace(out);
                    }
                    Object var10_11 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e222) {
                            // empty catch block
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (Exception e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222;
                Object var10_12 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (Exception e222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return fileContent.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeJarListFile(File f, String content) {
        String encoding = "UTF8";
        OutputStreamWriter osw = null;
        try {
            try {
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
                osw.write(content);
                osw.flush();
                osw.close();
                return;
            }
            catch (IOException e) {
                if (DEBUG) {
                    out.println("Exception while writing jar list file: " + e.getMessage());
                    e.printStackTrace(out);
                }
                Object var6_5 = null;
                if (osw == null) return;
                try {
                    osw.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (osw == null) throw throwable;
            try {
                osw.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private MapEntry findMapEntry(String filename) {
        boolean found = false;
        Enumeration enumeration = this.folders.elements();
        MapEntry currentEntry = null;
        while (!found && enumeration.hasMoreElements()) {
            currentEntry = (MapEntry)enumeration.nextElement();
            found = currentEntry.contains(filename);
        }
        return found ? currentEntry : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WarFileFilter
    implements FilenameFilter {
        private WarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            if (DEBUG) {
                out.print("Check file: " + dir + " ... " + name + " ---> ");
            }
            String n = name.toLowerCase();
            result = n.endsWith(".war");
            if (DEBUG) {
                out.println(result);
            }
            return result;
        }
    }

    private static class FileFilter
    implements FilenameFilter {
        boolean onlyLibs = false;

        FileFilter(boolean onlylibs) {
            this.onlyLibs = onlylibs;
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            if (DEBUG) {
                out.print("Check file: " + dir + " ... " + name + " ---> ");
            }
            if (this.onlyLibs) {
                String n = name.toLowerCase();
                result = n.endsWith(".jar");
            } else {
                result = true;
            }
            if (DEBUG) {
                out.println(result);
            }
            return result;
        }
    }

    private static class DirectoryFilter
    implements FilenameFilter {
        File rootDir = null;

        DirectoryFilter(File rootDir) {
            this.rootDir = rootDir;
        }

        public boolean accept(File dir, String name) {
            if (this.rootDir == null) {
                return false;
            }
            boolean result = false;
            if (DEBUG) {
                out.print("Check if directory: " + dir + " ... " + name + " ---> ");
            }
            if (!this.rootDir.equals(dir)) {
                result = false;
            } else {
                File f = new File(dir, name);
                result = f.isDirectory();
            }
            if (DEBUG) {
                out.println(result);
            }
            return result;
        }
    }

    private static class MapEntry {
        private ZipFile zipFile = null;
        private Hashtable entries = null;
        private File classesfolder = null;

        public MapEntry(File classesfolder) {
            if (classesfolder == null || !classesfolder.exists() || !classesfolder.isDirectory()) {
                throw new RuntimeException("Cannot create MapEntry for " + classesfolder);
            }
            this.classesfolder = classesfolder;
            this.collectFiles();
        }

        public MapEntry(ZipFile zipfile) {
            if (zipfile == null) {
                throw new RuntimeException("Cannot create MapEntry for " + zipfile);
            }
            this.zipFile = zipfile;
            this.collectZipEntries();
        }

        public String getLocation() {
            String result = "";
            if (this.zipFile != null) {
                result = this.zipFile.getName();
            }
            if (this.classesfolder != null) {
                result = this.classesfolder.getAbsolutePath();
            }
            return result;
        }

        public InputStream getInputstream(String file) {
            InputStream result;
            block6: {
                if (file == null) {
                    return null;
                }
                file = file.replace('\\', '/');
                result = null;
                try {
                    if (this.zipFile != null) {
                        ZipEntry e = this.zipFile.getEntry(file);
                        result = this.zipFile.getInputStream(e);
                    } else {
                        String entryname = (String)this.entries.get(file);
                        if (entryname != null) {
                            result = new FileInputStream(entryname);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!DEBUG) break block6;
                    out.println("Exception while MapEntry.getInputstream: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
            }
            return result;
        }

        public int getSize(String file) {
            if (file == null) {
                return -1;
            }
            file = file.replace('\\', '/');
            int result = -1;
            if (this.zipFile != null) {
                ZipEntry entry = this.zipFile.getEntry(file);
                if (entry != null) {
                    result = (int)entry.getSize();
                }
            } else {
                File f = new File((String)this.entries.get(file));
                result = (int)f.length();
            }
            return result;
        }

        public boolean contains(String filename) {
            filename = filename.replace('\\', '/');
            return this.entries.containsKey(filename);
        }

        void collectZipEntries() {
            if (DEBUG) {
                out.println("Collect files for zip: " + this.zipFile.getName());
            }
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            ZipEntry entry = null;
            this.entries = new Hashtable(50);
            while (enumeration.hasMoreElements()) {
                entry = enumeration.nextElement();
                if (DEBUG) {
                    out.println("    + add: " + entry.getName());
                }
                this.entries.put(entry.getName(), entry);
            }
        }

        void collectFiles() {
            if (DEBUG) {
                out.println("Collect files within: " + this.classesfolder.getAbsolutePath());
            }
            this.entries = new Hashtable(50);
            this.collectDirectory(this.classesfolder, this.classesfolder.getAbsolutePath() + File.separator);
        }

        private void collectDirectory(File dir, String base) {
            if (dir == null || !dir.exists()) {
                return;
            }
            if (!dir.isDirectory()) {
                String relativeFilename = dir.getAbsolutePath();
                if (relativeFilename.startsWith(base)) {
                    relativeFilename = relativeFilename.substring(base.length());
                }
                relativeFilename = relativeFilename.replace('\\', '/');
                if (DEBUG) {
                    out.println("    + add File: " + relativeFilename + " (= " + dir.getAbsolutePath() + ")");
                }
                this.entries.put(relativeFilename, dir.getAbsolutePath());
            } else {
                String[] content = dir.list();
                File f = null;
                int i = 0;
                while (i < content.length) {
                    f = new File(dir.getAbsolutePath() + File.separator + content[i]);
                    this.collectDirectory(f, base);
                    ++i;
                }
            }
        }
    }
}

