/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;

class SslSupportConfiguration {
    protected SslSupportConfiguration() {
        this.initialize();
    }

    private void initialize() {
        AppLog applog = AppLog.getInstance("MI/Core");
        Trace trace = Trace.getInstance("MI/Core");
        Configuration config = Configuration.getInstance();
        Properties systemProperties = System.getProperties();
        try {
            Provider sslProvider = new Provider();
            java.security.Provider[] providers = Security.getProviders();
            boolean sslProviderUnknown = true;
            int i = 0;
            while (i < providers.length) {
                if (sslProvider.equals(providers[i])) {
                    sslProviderUnknown = false;
                    break;
                }
                ++i;
            }
            if (sslProviderUnknown) {
                Security.addProvider((java.security.Provider)sslProvider);
            }
        }
        catch (NoClassDefFoundError e) {
            applog.log(60, "The SSL support feature is not properly configured. Https is not available.");
            trace.logException(60, "The SSL support feature is not available.", e, true);
            return;
        }
        catch (Exception e) {
            applog.log(60, "The SSL support feature is not properly configured. Https is not available.");
            trace.logException(60, "An exception occurred while trying to add a new security provider for the SSL support configuration.", e, true);
            return;
        }
        ((Hashtable)systemProperties).put("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        StringBuffer keystoreLocation = new StringBuffer(config.getProperty("MobileEngine.InstallationPath"));
        keystoreLocation.append(File.separatorChar).append("settings").append(File.separatorChar).append("keystore");
        ((Hashtable)systemProperties).put("javax.net.ssl.keyStore", keystoreLocation.toString());
        StringBuffer truststoreLocation = new StringBuffer(config.getProperty("MobileEngine.InstallationPath"));
        truststoreLocation.append(File.separatorChar).append("settings").append(File.separatorChar).append("truststore");
        ((Hashtable)systemProperties).put("javax.net.ssl.trustStore", truststoreLocation.toString());
        ((Hashtable)systemProperties).put("javax.net.ssl.keyStorePassword", "mobile");
        ((Hashtable)systemProperties).put("javax.net.ssl.trustStorePassword", "access");
        String javaVersion = System.getProperty("java.version");
        if (trace.isLogging(70)) {
            trace.log(70, "The https protocol is able to run with the currently used java version: {0}", (Object)javaVersion);
        }
        if (trace.isLogging(90)) {
            trace.log(90, "System property 'javax.net.ssl.keyStore' has value: {0}", (Object)keystoreLocation);
            trace.log(90, "System property 'javax.net.ssl.trustStore' has value: {0}", (Object)truststoreLocation);
        }
        if (!config.getBoolean("MobileEngine.Security.HostnameVerifying", true)) {
            if (trace.isLogging(70)) {
                trace.log(70, "Hostname verifying is not active.");
            }
            try {
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new HostnameVerifier(){

                    public boolean verify(String urlHostname, String certHostname) {
                        AppLog.getInstance("MI/Core").log(70, "URL hostname is {0}, but certificate hostname {1} differs. However, hostname verifying is disabled.", (Object)urlHostname, (Object)certHostname);
                        return true;
                    }
                });
            }
            catch (Exception e) {
                applog.log(60, "The SSL support feature is not properly configured. Https connections may get into trouble.");
                trace.logException(60, "An error occurred while trying to set a default hostname verifier.", e, true);
            }
            if (trace.isLogging(70)) {
                trace.log(70, "SecurityConfiguration: Default hostname verifier was successfully set.");
            }
        }
        System.setProperties(systemProperties);
    }
}

