/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.Trace;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ServerExceptionMessage {
    public static final int MI_INTERNAL_ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int LOGON_WRONG_PASSWORD = 0;
    public static final int LOGON_PASSWORD_EXPIRED = 1;
    public static final int LOGON_USER_LOCKED = 2;
    public static final int LOGON_USER_NOT_ACTIVE = 3;
    public static final int LOGON_WAIT = 4;
    public static final int LOGON_NO_CHECK_FOR_THIS_USER = 5;
    public static final int LOGON_INTERNAL_ERROR = 6;
    public static final int SERVICE_USER_CONNECTION_ERROR = 7;
    public static final int MI_INTERNAL_ABAP_ERROR = 8;
    private static final String[] MESSAGES = new String[]{"xmsg_S_WRONG_PASSWORD", "Server logon failed: User name or password is incorrect.", "xmsg_S_PASSWORD_EXPIRED", "Server logon failed: Password is expired.", "xmsg_S_USER_LOCKED", "Server logon failed: User is locked.", "xmsg_S_USER_NOT_ACTIVE", "Server logon failed: User is not avtice.", "xmsg_S_WAIT", "Server logon failed: User name or password is incorrect.", "xmsg_S_NO_LOGON_CHECK", "Server logon failed: Logon check is not permitted.", "xmsg_S_INTERNAL_E", "Server logon failed: Internal error. Contact your administrator.", "xmsg_S_SERVICE_USER_E", "Server logon failed.", "xmsg_S_MI_ABAP_ERROR", "Internal server error. Contact your administrator."};
    private static final String UNDEFINED_ERROR = "Received undefinied error code.";
    private static final String INTERNAL_ERROR = "MI internal framework error.";
    private static final String RESOURCEBUNDLE_NAME = "com/sap/ip/me/awtapps/home/mobile_engine";
    private int messageId;

    public ServerExceptionMessage(int messageId) {
        this.messageId = messageId < -2 || messageId >= MESSAGES.length / 2 ? -1 : messageId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getMessage() {
        if (this.messageId >= 0) {
            return MESSAGES[this.messageId * 2 + 1];
        }
        if (this.messageId == -1) {
            return UNDEFINED_ERROR;
        }
        return INTERNAL_ERROR;
    }

    public String getLocalizedMessage() {
        try {
            ResourceBundle resources = ResourceBundle.getBundle(RESOURCEBUNDLE_NAME);
            if (this.messageId >= 0) {
                return resources.getString(MESSAGES[2 * this.messageId]);
            }
            if (this.messageId == -1) {
                return resources.getString("xmsg_S_UNDEFINED");
            }
            return resources.getString("xmsg_S_MI_INTERNAL_E");
        }
        catch (MissingResourceException e) {
            Trace.getInstance("MI/Core").log(60, "Cannot create a localized error message.");
            Trace.getInstance("MI/Core").logException(60, e);
            return this.getMessage();
        }
    }
}

