/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.CipherHandler;
import com.sap.ip.me.core.DBPasswordHandler;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;

public class SecurityManager {
    private static final SecurityManager INSTANCE;
    private static boolean isCryptoImplAvailable;
    private MessageDigest md = null;
    private SyncPasswordHandlingOption selectedSyncPasswordHandlingOption = null;
    private CipherHandler cipherHandler = null;
    private DBPasswordHandler dbPasswordHandler = null;
    private static final AppLog appLog;
    private static final Trace trace;

    private SecurityManager() {
        String selectedOption;
        if (INSTANCE != null) {
            appLog.log(10, "Fatal framework error: SecurityManager instance was already created.");
            throw new RuntimeException("Fatal framework error: SecurityManager instance was already created.");
        }
        Configuration config = Configuration.getInstance();
        this.initializeMandatoryCryptoSupport(config);
        if (config.getBoolean("MobileEngine.Security.SSLSupport", false)) {
            this.initializeSslSupport();
        } else if (appLog.isLogging(70)) {
            appLog.log(70, "SecurityManager: SSL support is switched off.");
        }
        if (trace.isLogging(90)) {
            trace.log(90, "SecurityManager: The following security providers are available: ");
            Provider[] providers = Security.getProviders();
            if (providers.length == 0) {
                trace.log(90, "  There are no security providers at all.");
            }
            int i = 0;
            while (i < providers.length) {
                Object[] args = new Object[]{providers[i].getName(), new Integer(i + 1), providers[i].getInfo(), new Double(providers[i].getVersion())};
                trace.log(90, "  Name: {0}, preference order: {1}, info: {2}, version: {3}.", args);
                ++i;
            }
            if (this.md != null) {
                trace.log(90, "SecurityManager: The following message digest algorithm was instantiated:  {0}", (Object)this.md.toString());
            }
        }
        this.selectedSyncPasswordHandlingOption = "atSync".equalsIgnoreCase(selectedOption = config.getProperty("MobileEngine.Security.SynchronizationPasswordHandlingOption")) ? SyncPasswordHandlingOption.AT_SYNC : ("local".equalsIgnoreCase(selectedOption) ? SyncPasswordHandlingOption.LOCAL : SyncPasswordHandlingOption.ONCE);
        trace.log(90, "SecurityManager: Selected synchronization password handling option:  {0}", (Object)this.selectedSyncPasswordHandlingOption.toString());
        this.cipherHandler = new CipherHandler();
        this.dbPasswordHandler = new DBPasswordHandler(this.cipherHandler);
        int logonFailures = config.getInt("MobileEngine.Security.AllowedLogonFailuresUntilUserLock", -1);
        if (logonFailures > 100) {
            config.setDefaultProperty("MobileEngine.Security.AllowedLogonFailuresUntilUserLock", "100");
        }
    }

    public static SecurityManager getInstance() {
        return INSTANCE;
    }

    public SyncPasswordHandlingOption getSelectedSyncPasswordHandlingOption() {
        return this.selectedSyncPasswordHandlingOption;
    }

    public String getOneWayHash(String value) {
        if (value == null) {
            return null;
        }
        if (this.md != null) {
            char[] hashValueAsChars;
            int len = 2 * value.length();
            byte[] bytes = new byte[len];
            int i = 0;
            while (i < len) {
                char b = value.charAt(i / 2);
                bytes[i] = (byte)(b >> 8 & 0xFF);
                bytes[i + 1] = (byte)(b & 0xFF);
                i += 2;
            }
            byte[] hashValue = this.md.digest(bytes);
            this.md.reset();
            int size = hashValue.length;
            if (size % 2 == 0) {
                hashValueAsChars = new char[size / 2];
                int i2 = 0;
                while (i2 < size) {
                    int b = (hashValue[i2] & 0xFF) << 8;
                    hashValueAsChars[i2 / 2] = (char)(b += hashValue[i2 + 1] & 0xFF);
                    i2 += 2;
                }
            } else {
                hashValueAsChars = new char[size / 2 + 1];
                int i3 = 0;
                while (i3 < size - 2) {
                    int b = (hashValue[i3] & 0xFF) << 8;
                    hashValueAsChars[i3 / 2] = (char)(b += hashValue[i3 + 1] & 0xFF);
                    i3 += 2;
                }
                hashValueAsChars[size / 2] = (char)((hashValue[size - 1] & 0xFF) << 8);
            }
            return new String(hashValueAsChars);
        }
        appLog.log(50, "Error occurred during the execution of an MI internal computation. Contact the MI support team.");
        trace.log(50, "Mandatory one-way-hash algorithm is not available.");
        throw new RuntimeException("Mandatory one-way-hash algorithm is not available.");
    }

    public String encode(String input) {
        return this.cipherHandler.encrypt(input);
    }

    public String decode(String input) {
        try {
            return this.cipherHandler.decrypt(input);
        }
        catch (Exception e) {
            appLog.log(50, "Error occurred during the execution of an MI internal decoding procedure. Contact the MI support team.");
            trace.logException(50, "There is a decryption problem.", null, e, true);
            throw new RuntimeException("MI framework cannot decrypt a given encrypted string.");
        }
    }

    public String getDBPassword() {
        return this.dbPasswordHandler.getPassword();
    }

    private void initializeMandatoryCryptoSupport(Configuration config) {
        Object[] params;
        String provider = config.getProperty("MobileEngine.Security.Implementation.Provider");
        String providerName = null;
        isCryptoImplAvailable = false;
        try {
            Class<?> providerClass = Class.forName(provider);
            Provider newProvider = (Provider)providerClass.newInstance();
            Provider[] providers = Security.getProviders();
            boolean newProviderUnknown = true;
            int i = 0;
            while (i < providers.length) {
                if (((Hashtable)newProvider).equals(providers[i])) {
                    newProviderUnknown = false;
                    break;
                }
                ++i;
            }
            if (newProviderUnknown) {
                Security.addProvider(newProvider);
            }
            providerName = newProvider.getName();
            isCryptoImplAvailable = true;
        }
        catch (NoClassDefFoundError e) {
            Object[] params2 = new Object[]{provider};
            appLog.logException(50, "SecurityManager: Unknown security provider (NoClassDefFoundError: {0}).", params2, e, false);
        }
        catch (Exception e) {
            params = new Object[]{provider};
            appLog.logException(50, "SecurityManager: An exception occurred while trying to add the security provider ({0}).", params, e, true);
        }
        if (isCryptoImplAvailable) {
            String oneWayHashAlgorithm = config.getProperty("MobileEngine.Security.Implementation.OneWayHashAlgorithm");
            try {
                this.md = MessageDigest.getInstance(oneWayHashAlgorithm, providerName);
            }
            catch (NoSuchAlgorithmException e) {
                params = new Object[]{oneWayHashAlgorithm};
                appLog.logException(50, "SecurityManager: Unknown message digest algorithm ({0}).", params, e, false);
            }
            catch (NoSuchProviderException e) {
                Object[] params3 = new Object[]{providerName, oneWayHashAlgorithm};
                appLog.logException(50, "SecurityManager: Unknown provider ({0}) for message digest algorithm ({1}).", params3, e, false);
            }
        }
    }

    private void initializeSslSupport() {
        try {
            Class<?> sslSupportConfiguration = Class.forName("com.sap.ip.me.core.SslSupportConfiguration");
            sslSupportConfiguration.newInstance();
        }
        catch (NoClassDefFoundError e) {
            appLog.log(60, "The SSL support feature is not properly configured. Https is not available.");
            trace.logException(50, "SecurityManager: The SSL support feature is not available (NoClassDefFoundError)", e, false);
        }
        catch (Exception e) {
            appLog.log(60, "The SSL support feature is not properly configured. Https is not available.");
            trace.logException(50, "SecurityManager: An exception occurred while trying to initialize the SSL support configuration.", e, true);
        }
    }

    static void _reinitialize(boolean complete) {
        if (complete) {
            Properties props = System.getProperties();
            ((Hashtable)props).remove("MobileEngine.Security.Implementation.SecurityManager");
        }
    }

    static {
        appLog = AppLog.getInstance("MI/Core");
        trace = Trace.getInstance("MI/Core");
        String key = "MobileEngine.Security.Implementation.SecurityManager";
        Properties props = System.getProperties();
        SecurityManager singletonInstance = (SecurityManager)((Hashtable)props).get(key);
        if (singletonInstance == null) {
            singletonInstance = new SecurityManager();
            ((Hashtable)props).put(key, singletonInstance);
        }
        INSTANCE = singletonInstance;
    }
}

