/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import java.io.Serializable;
import java.util.Vector;

public class RegistryInboundProcessingLog {
    private static final RegistryInboundProcessingLog instance = new RegistryInboundProcessingLog();
    private Vector installedApplicationInfos;
    private Vector uninstalledApplicationInfos;
    private Vector bapiRet2Messages;

    private RegistryInboundProcessingLog() {
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).addSyncEventListener(new RegistryInboundProcessingLogSyncEventListener(), ConversationIdHandler.getSharedFrameworkConversationId());
        this.bapiRet2Messages = new Vector(2);
        this.installedApplicationInfos = new Vector(2);
        this.uninstalledApplicationInfos = new Vector(2);
    }

    public static RegistryInboundProcessingLog getInstance() {
        return instance;
    }

    public void addInstalledApplicationInfo(MobileSolutionDescriptor ai) {
        this.installedApplicationInfos.addElement(ai);
    }

    public void addUnInstalledApplicationInfo(MobileSolutionDescriptor ai) {
        this.uninstalledApplicationInfos.addElement(ai);
    }

    public void addBapiRet2Message(String message) {
        this.bapiRet2Messages.addElement(message);
    }

    public Vector getInstalledApplicationInfos() {
        return this.installedApplicationInfos;
    }

    public Vector getUninstalledApplicationInfos() {
        return this.uninstalledApplicationInfos;
    }

    public Vector getBapiRet2Messages() {
        return this.bapiRet2Messages;
    }

    public boolean applicationsWereInstalled() {
        return this.installedApplicationInfos.size() > 0;
    }

    public boolean applicationsWereUninstalled() {
        return this.uninstalledApplicationInfos.size() > 0;
    }

    public boolean messagesToDisplay() {
        return this.bapiRet2Messages.size() > 0;
    }

    public static class RegistryInboundProcessingLogSyncEventListener
    implements SyncEventListener,
    Serializable {
        public void actionPerformed(SyncEvent e) {
            if (e.getType() == 0) {
                RegistryInboundProcessingLog log = RegistryInboundProcessingLog.getInstance();
                log.installedApplicationInfos.removeAllElements();
                log.getBapiRet2Messages().removeAllElements();
                log.uninstalledApplicationInfos.removeAllElements();
            }
        }
    }
}

