/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.Trace;
import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    private final Trace trace = Trace.getInstance("MI/Core");

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        this.trace.log(90, "MULTICLASSLOADER.loadClass: " + className);
        Class<?> result = (Class<?>)this.classes.get(className);
        if (result != null) {
            this.trace.log(90, "MULTICLASSLOADER.loadClass found class in local cache: " + result);
            return result;
        }
        byte[] classBytes = this.loadClassBytes(className);
        if (classBytes == null) {
            ClassLoader parent = this.getClass().getClassLoader();
            if (parent != null) {
                this.trace.log(90, "MULTICLASSLOADER.loadClass parent CL: " + parent.toString());
                result = parent.loadClass(className);
                this.trace.log(90, "MULTICLASSLOADER.loadClass finding parent classloader result: " + result);
            } else {
                this.trace.log(90, "MULTICLASSLOADER.loadClass finding system class: " + className);
                result = super.findSystemClass(className);
                this.trace.log(90, "MULTICLASSLOADER.loadClass finding system class result: " + result);
            }
            return result;
        }
        result = this.defineClass(className, classBytes, 0, classBytes.length);
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        this.classes.put(className, result);
        return result;
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return className.replace('.', '/') + ".class";
        }
        return className.replace('.', this.classNameReplacementChar) + ".class";
    }
}

