/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.runtime.Application;
import com.sap.ip.me.apps.InstallationScenarioApplicationType;
import com.sap.ip.me.core.AddonApplicationType;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationNotAvailableException;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.AwtApplicationType;
import com.sap.ip.me.core.FrameworkApplicationType;
import com.sap.ip.me.core.JspApplicationType;
import com.sap.ip.me.core.LitsApplicationType;
import com.sap.ip.me.core.MicroItsApplicationImpl;
import com.sap.ip.me.core.MobileSolutionDescriptorApplicationDependency;
import com.sap.ip.me.core.UnknownApplicationTypeException;
import com.sap.ip.me.core.WebDynproApplicationImpl;
import com.sap.ip.me.core.WebDynproApplicationType;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MobileSolutionDescriptor
implements Serializable {
    static final long serialVersionUID = -4189844749551416641L;
    private static final String INITIALDATAVALUESACCEPTED = "INITVALUE";
    static final String DATA_VISIBLE_SHARED = "DATA_VISIBLE_SHARED";
    private String namespace;
    private String name;
    private String version;
    private transient String id;
    private String description;
    private transient ApplicationType type;
    private Vector installedFiles;
    private boolean visible;
    private boolean ownFrame;
    private boolean installed;
    private boolean failed = false;
    private boolean incomplete;
    private boolean clientInstallerArchive = false;
    private String targetClassname;
    private String typeClassname;
    private Hashtable listOfProperties;
    private Hashtable listOfCustomizing;
    private boolean usingSmartSync;
    private String webDynproApplicationName = "";
    private String webDynproProjectName = "";
    private Vector listOfDependency;
    private boolean installationFileAlreadyDownloaded;

    public MobileSolutionDescriptor(String namespace, String name, String version, String description, ApplicationType type, String targetClassname, boolean visible, boolean installed, boolean incomplete) {
        this.namespace = namespace != null ? namespace : "";
        this.name = name != null ? name : "";
        this.version = version != null ? version : "";
        this.setId();
        this.description = description != null ? description : "";
        this.targetClassname = targetClassname;
        this.type = type;
        this.typeClassname = type != null ? type.getClass().getName() : "";
        this.visible = visible;
        this.installed = installed;
        this.incomplete = incomplete;
        this.ownFrame = false;
        this.installedFiles = new Vector();
        this.listOfProperties = new Hashtable();
        this.listOfCustomizing = new Hashtable();
        this.listOfDependency = new Vector();
        this.usingSmartSync = false;
        this.installationFileAlreadyDownloaded = false;
        this.clientInstallerArchive = false;
        this.failed = false;
    }

    public MobileSolutionDescriptor(String name, String version, String description, ApplicationType type, String targetClassname, boolean visible, boolean installed, boolean incomplete) {
        this("", name, version, description, type, targetClassname, visible, installed, incomplete);
    }

    public MobileSolutionDescriptor(String nameSpace, String name, String version) {
        this(nameSpace, name, version, "", null, "", false, false, true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public ApplicationType getType() throws UnknownApplicationTypeException {
        if (this.type == null) {
            if ((this.typeClassname == null || this.typeClassname.length() == 0) && ApplicationManager.getInstance().getFrameworkName().equalsIgnoreCase(this.name)) {
                this.type = new FrameworkApplicationType();
            } else {
                try {
                    Class<?> appl = Class.forName(this.typeClassname);
                    this.type = (ApplicationType)appl.newInstance();
                }
                catch (Exception ex) {
                    if (this.typeClassname != null && this.typeClassname != "") {
                        throw new UnknownApplicationTypeException(this.typeClassname, ex.getMessage());
                    }
                    String type = (String)this.listOfProperties.get("TYPE");
                    throw new UnknownApplicationTypeException("Application type classname was null", "An application type for MSD property " + type + " is not available. Therefore the installation of " + this.getName() + " cannot be executed. Please contact your system administartor");
                }
            }
        }
        return this.type;
    }

    public void setType(ApplicationType newType) throws UnknownApplicationTypeException {
        if (newType != null && newType instanceof ApplicationType) {
            this.type = newType;
            this.typeClassname = newType.getClass().getName();
            return;
        }
        throw new UnknownApplicationTypeException(newType == null ? "" : newType.getClass().getName(), "Application type cannot be set because it is unknown or null.");
    }

    public String[] getInstalledFiles() {
        Object[] result = new String[this.installedFiles.size()];
        this.installedFiles.copyInto(result);
        return result;
    }

    public void addInstalledFile(String filename) {
        this.installedFiles.addElement(filename);
    }

    public void removeInstalledFile(String filename) {
        this.installedFiles.removeElement(filename);
    }

    public Application getApplication() throws ApplicationNotAvailableException {
        ClassLoader l;
        if (this.getTargetClassname() == null || this.getTargetClassname().equals("")) {
            try {
                if (this.getType() instanceof LitsApplicationType) {
                    return new MicroItsApplicationImpl(this.getName());
                }
                if (this.getType() instanceof WebDynproApplicationType) {
                    return new WebDynproApplicationImpl(this.getName());
                }
            }
            catch (UnknownApplicationTypeException uapptype) {
                AppLog.getInstance("MI/Core").logException(uapptype, true);
            }
        }
        if ((l = this.getClass().getClassLoader()) == null) {
            try {
                Class<?> appl = Class.forName(this.targetClassname);
                Application result = (Application)appl.newInstance();
                return result;
            }
            catch (Exception ex) {
                AppLog.getInstance("MI/Core").logException(ex);
                throw new ApplicationNotAvailableException(this.name, this.targetClassname, ex.getMessage());
            }
        }
        try {
            Class<?> appl = l.loadClass(this.targetClassname);
            Application result = (Application)appl.newInstance();
            return result;
        }
        catch (Exception ex) {
            AppLog.getInstance("MI/Core").logException(ex);
            throw new ApplicationNotAvailableException(this.name, this.targetClassname, ex.getMessage());
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public boolean isClientInstallerArchive() {
        return this.clientInstallerArchive;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setInstallationFailed() {
        this.failed = true;
    }

    public void setClientInstallerArchive() {
        this.clientInstallerArchive = true;
    }

    public boolean isOwnFrame() {
        return this.ownFrame;
    }

    public void setOwnFrame(boolean ownFrame) {
        this.ownFrame = ownFrame;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String getTargetClassname() {
        return this.targetClassname;
    }

    public void setTargetClassname(String classname) {
        this.targetClassname = classname;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: ").append(this.getNamespace());
        b.append(" / ").append(this.getName()).append(" (V. ").append(this.getVersion()).append("), ");
        b.append("Target=").append(this.getTargetClassname()).append(", Type=").append(this.typeClassname);
        return b.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof MobileSolutionDescriptor && this.getId().equalsIgnoreCase(((MobileSolutionDescriptor)other).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getPropertyValueForKey(String key) {
        String returnValue = (String)this.listOfProperties.get(key);
        if (returnValue == null) {
            return "";
        }
        return returnValue;
    }

    public String getCustomizingValueForKey(String key) {
        String returnValue = (String)this.listOfCustomizing.get(key);
        if (returnValue == null) {
            return "";
        }
        return returnValue;
    }

    public void setPropertyValue(String key, String value) {
        this.listOfProperties.put(key, value);
    }

    public void setCustomizingValue(String key, String value) {
        this.listOfCustomizing.put(key, value);
    }

    public String getInstallationUrl() {
        String webserver = (String)this.listOfCustomizing.get("WEBSERVER");
        String webpath = (String)this.listOfCustomizing.get("WEBPATH");
        if (webserver != null && webpath != null) {
            return webserver.concat(webpath);
        }
        return "";
    }

    public void setApplicationType() {
        String type = (String)this.listOfProperties.get("TYPE");
        if (type.equalsIgnoreCase("ADDON")) {
            this.type = new AddonApplicationType();
        } else if (type.equalsIgnoreCase("APPLICATION")) {
            String runTime = (String)this.listOfProperties.get("RUNTIME");
            if (runTime.equalsIgnoreCase("AWT")) {
                this.type = new AwtApplicationType();
            } else if (runTime.equalsIgnoreCase("JSP")) {
                this.type = new JspApplicationType();
            } else if (runTime.equalsIgnoreCase("MICROITS")) {
                this.type = new LitsApplicationType();
            } else if (runTime.equalsIgnoreCase("WEBDYNPRO")) {
                this.type = new WebDynproApplicationType();
            }
        } else if (type.equalsIgnoreCase("FRAMEWORK")) {
            this.type = new FrameworkApplicationType();
        } else if (type.equalsIgnoreCase("INSTALL_SEQUENCE")) {
            this.type = new InstallationScenarioApplicationType();
        }
        if (this.type != null) {
            this.typeClassname = this.type.getClass().getName();
        }
    }

    public void setWebDynproApplicationName(String wdApplicationName) {
        this.webDynproApplicationName = wdApplicationName;
    }

    public String getWebDynproApplicationName() {
        return this.webDynproApplicationName;
    }

    public void setWebDynproProjectName(String wdProjectName) {
        this.webDynproProjectName = wdProjectName;
    }

    public String getWebDynproProjectName() {
        return this.webDynproProjectName;
    }

    public String[] getSupportedLanguages() {
        Vector<String> supportedLanguages = new Vector<String>();
        Enumeration e = this.listOfProperties.keys();
        while (e.hasMoreElements()) {
            String propertyValue;
            String propertyKey = (String)e.nextElement();
            if (propertyKey.length() != 2 || !(propertyValue = (String)this.listOfProperties.get(propertyKey)).equalsIgnoreCase("language")) continue;
            supportedLanguages.addElement(propertyKey);
        }
        if (!supportedLanguages.isEmpty()) {
            Object[] listOfSupportedLanguages = new String[supportedLanguages.size()];
            supportedLanguages.copyInto(listOfSupportedLanguages);
            return listOfSupportedLanguages;
        }
        return null;
    }

    public boolean isItASmartSyncApplication() {
        return this.usingSmartSync;
    }

    public void setUsingSmartSync(boolean smartsync) {
        this.usingSmartSync = smartsync;
    }

    public boolean initialDataValuesAccepted() {
        return this.getPropertyValueForKey(INITIALDATAVALUESACCEPTED).equalsIgnoreCase("X");
    }

    public boolean sharedDataVisible() {
        return this.getPropertyValueForKey(DATA_VISIBLE_SHARED).equalsIgnoreCase("X");
    }

    void setSharedDataVisible(boolean useSharedArea) {
        this.setPropertyValue(DATA_VISIBLE_SHARED, useSharedArea ? "X" : "");
    }

    public void setDependencyValue(MobileSolutionDescriptorApplicationDependency msdDep) {
        if (this.listOfDependency == null) {
            this.listOfDependency = new Vector();
        }
        this.listOfDependency.addElement(msdDep);
    }

    public Vector getListOfDependency() {
        if (this.listOfDependency == null) {
            this.listOfDependency = new Vector();
        }
        return this.listOfDependency;
    }

    public boolean isInstallationFileAlreadyDownloaded() {
        return this.installationFileAlreadyDownloaded;
    }

    public void setInstallationFileAlreadyDownloaded(boolean installationFileAlreadyDownloaded) {
        this.installationFileAlreadyDownloaded = installationFileAlreadyDownloaded;
    }

    private void setId() {
        this.id = this.namespace.toUpperCase() + "_" + this.name.toUpperCase() + "_" + this.version.toUpperCase();
    }
}

