/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.MeTreeSet;

public class MeSortedVector
implements MeTreeSet {
    public static final long serialVersionUID = Long.MIN_VALUE;
    private final MeComparator comparator;
    private Object[] objects;
    private int elementCount;

    public MeSortedVector(MeComparator comparator, int initialCapacity) {
        this.comparator = comparator;
        this.objects = new Object[initialCapacity];
        this.elementCount = 0;
    }

    public MeSortedVector(MeTreeSet treeSet) {
        this(treeSet.comparator(), treeSet.size());
        MeIterator iterator = treeSet.iterator();
        int x = 0;
        while (iterator.hasNext()) {
            this.objects[x++] = iterator.next();
        }
        this.elementCount = iterator.elementCount();
    }

    public void add(Object object) {
        if (object != null) {
            int left = 0;
            int right = this.elementCount;
            while (left < right) {
                int middle = (left + right) / 2;
                int cmp = this.comparator.compare(object, this.objects[middle]);
                if (cmp < 0) {
                    right = middle;
                    continue;
                }
                if (cmp > 0) {
                    left = middle + 1;
                    continue;
                }
                left = middle;
                break;
            }
            this._checkSizeForAdd();
            if (left < this.elementCount) {
                System.arraycopy(this.objects, left, this.objects, left + 1, this.elementCount - left);
            }
            this.objects[left] = object;
            ++this.elementCount;
        }
    }

    public void append(Object object) {
        if (object != null) {
            if (this.elementCount == 0 || this.comparator.compare(object, this.objects[this.elementCount - 1]) >= 0) {
                this._checkSizeForAdd();
                this.objects[this.elementCount++] = object;
            } else {
                throw new IllegalArgumentException("Comparison with rightmost object was negative");
            }
        }
    }

    public void add(MeIterator it) {
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public Object get(Object key) {
        int index = this.indexOf(key);
        return index != -1 ? this.objects[index] : null;
    }

    public void delete(int iIdx) {
        if (iIdx < this.elementCount) {
            this._delete(iIdx);
        }
    }

    public void delete(Object iObject) {
        int idx = this.indexOf(iObject);
        if (idx != -1) {
            this._delete(idx);
        }
    }

    public void clear() {
        this.objects = new Object[this.objects.length];
        this.elementCount = 0;
    }

    public int size() {
        return this.elementCount;
    }

    public Object get(int x) {
        return x >= 0 && x < this.elementCount ? this.objects[x] : null;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public MeComparator comparator() {
        return this.comparator;
    }

    public int indexOf(Object object) {
        int low = 0;
        int high = this.elementCount - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = this.comparator.compare(object, this.objects[mid]);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int firstIndexOf(Object object) {
        int pos = this.indexOf(object);
        if (pos == -1) {
            return -1;
        }
        int cmp = 0;
        while (pos > 0) {
            if ((cmp = this.comparator.compare(object, this.objects[--pos])) == 0) continue;
            return ++pos;
        }
        return 0;
    }

    public MeIterator iterator() {
        return new MeIterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < MeSortedVector.this.elementCount;
            }

            public Object next() {
                return MeSortedVector.this.objects[this.index++];
            }

            public int elementCount() {
                return MeSortedVector.this.elementCount;
            }

            public void reset() {
                this.index = 0;
            }
        };
    }

    private void _delete(int iIdx) {
        System.arraycopy(this.objects, iIdx + 1, this.objects, iIdx, this.elementCount - iIdx);
        --this.elementCount;
    }

    private void _checkSizeForAdd() {
        int newLen = 0;
        if (this.elementCount + 1 > this.objects.length) {
            newLen = this.objects.length * 2;
            Object[] newArray = new Object[newLen];
            System.arraycopy(this.objects, 0, newArray, 0, this.elementCount);
            this.objects = newArray;
        }
    }
}

