/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import java.io.Serializable;

public class MeBitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int i = this.unitsInUse - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) break;
            --i;
        }
        this.unitsInUse = i + 1;
    }

    public MeBitSet() {
        this(64);
    }

    public MeBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.bits = new long[MeBitSet.unitIndex(nbits - 1) + 1];
    }

    private void ensureCapacity(int unitsRequired) {
        if (this.bits.length < unitsRequired) {
            int request = Math.max(2 * this.bits.length, unitsRequired);
            long[] newBits = new long[request];
            System.arraycopy(this.bits, 0, newBits, 0, this.unitsInUse);
            this.bits = newBits;
        }
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = MeBitSet.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n = unitIndex;
            this.bits[n] = this.bits[n] | MeBitSet.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n = unitIndex;
            this.bits[n] = this.bits[n] | MeBitSet.bit(bitIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = MeBitSet.unitIndex(bitIndex);
        if (unitIndex >= this.unitsInUse) {
            return;
        }
        int n = unitIndex;
        this.bits[n] = this.bits[n] & (MeBitSet.bit(bitIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        boolean result = false;
        int unitIndex = MeBitSet.unitIndex(bitIndex);
        if (unitIndex < this.unitsInUse) {
            result = (this.bits[unitIndex] & MeBitSet.bit(bitIndex)) != 0L;
        }
        return result;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = MeBitSet.unitIndex(fromIndex);
        if (u >= this.unitsInUse) {
            return -1;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u] >> testIndex;
        if (unit == 0L) {
            testIndex = 0;
        }
        while (unit == 0L && u < this.unitsInUse - 1) {
            unit = this.bits[++u];
        }
        if (unit == 0L) {
            return -1;
        }
        return u * 64 + (testIndex += MeBitSet.trailingZeroCnt(unit));
    }

    private static int trailingZeroCnt(long val) {
        int byteVal = (int)val & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal];
        }
        byteVal = (int)(val >>> 8) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 8;
        }
        byteVal = (int)(val >>> 16) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 16;
        }
        byteVal = (int)(val >>> 24) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 24;
        }
        byteVal = (int)(val >>> 32) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 32;
        }
        byteVal = (int)(val >>> 40) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 40;
        }
        byteVal = (int)(val >>> 48) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 48;
        }
        byteVal = (int)(val >>> 56) & 0xFF;
        return trailingZeroTable[byteVal] + 56;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = MeBitSet.unitIndex(fromIndex);
        if (u >= this.unitsInUse) {
            return fromIndex;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u] >> testIndex;
        if (unit == -1L >> testIndex) {
            testIndex = 0;
        }
        while (unit == -1L && u < this.unitsInUse - 1) {
            unit = this.bits[++u];
        }
        if (unit == -1L) {
            return this.length();
        }
        if (unit == 0L) {
            return u * 64 + testIndex;
        }
        return u * 64 + (testIndex += MeBitSet.trailingZeroCnt(unit ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long highestUnit = this.bits[this.unitsInUse - 1];
        int highPart = (int)(highestUnit >>> 32);
        return 64 * (this.unitsInUse - 1) + (highPart == 0 ? MeBitSet.bitLen((int)highestUnit) : 32 + MeBitSet.bitLen(highPart));
    }

    private static int bitLen(int w) {
        return w < 32768 ? (w < 128 ? (w < 8 ? (w < 2 ? (w < 1 ? (w < 0 ? 32 : 0) : 1) : (w < 4 ? 2 : 3)) : (w < 32 ? (w < 16 ? 4 : 5) : (w < 64 ? 6 : 7))) : (w < 2048 ? (w < 512 ? (w < 256 ? 8 : 9) : (w < 1024 ? 10 : 11)) : (w < 8192 ? (w < 4096 ? 12 : 13) : (w < 16384 ? 14 : 15)))) : (w < 0x800000 ? (w < 524288 ? (w < 131072 ? (w < 65536 ? 16 : 17) : (w < 262144 ? 18 : 19)) : (w < 0x200000 ? (w < 0x100000 ? 20 : 21) : (w < 0x400000 ? 22 : 23))) : (w < 0x8000000 ? (w < 0x2000000 ? (w < 0x1000000 ? 24 : 25) : (w < 0x4000000 ? 26 : 27)) : (w < 0x20000000 ? (w < 0x10000000 ? 28 : 29) : (w < 0x40000000 ? 30 : 31))));
    }

    public void and(MeBitSet set) {
        if (this == set) {
            return;
        }
        int oldUnitsInUse = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < this.unitsInUse) {
            int n = i;
            this.bits[n] = this.bits[n] & set.bits[i];
            ++i;
        }
        while (i < oldUnitsInUse) {
            this.bits[i] = 0L;
            ++i;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(MeBitSet set) {
        if (this == set) {
            return;
        }
        this.ensureCapacity(set.unitsInUse);
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
            ++i;
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        if (this.unitsInUse < set.unitsInUse) {
            this.unitsInUse = set.unitsInUse;
        }
    }

    public void xor(MeBitSet set) {
        int unitsInCommon;
        if (this.unitsInUse >= set.unitsInUse) {
            unitsInCommon = set.unitsInUse;
        } else {
            unitsInCommon = this.unitsInUse;
            int newUnitsInUse = set.unitsInUse;
            this.ensureCapacity(newUnitsInUse);
            this.unitsInUse = newUnitsInUse;
        }
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
            ++i;
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(MeBitSet set) {
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        int i = 0;
        while (i < unitsInCommon) {
            int n = i;
            this.bits[n] = this.bits[n] & (set.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
        this.recalculateUnitsInUse();
    }

    public Object clone() {
        MeBitSet result = null;
        try {
            result = (MeBitSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, this.unitsInUse);
        return result;
    }
}

