/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.core.ComparatorHelper;

public class MeArrays {
    private MeArrays() {
    }

    public static void sort(long[] a) {
        MeArrays.sort1(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(int[] a) {
        MeArrays.sort1(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(short[] a) {
        MeArrays.sort1(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(char[] a) {
        MeArrays.sort1(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(byte[] a) {
        MeArrays.sort1(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort1(a, fromIndex, toIndex - fromIndex);
    }

    public static void sort(double[] a) {
        MeArrays.sort2(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort2(a, fromIndex, toIndex);
    }

    public static void sort(float[] a) {
        MeArrays.sort2(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        MeArrays.sort2(a, fromIndex, toIndex);
    }

    private static void sort2(double[] a, int fromIndex, int toIndex) {
        long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                double swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0 && Double.doubleToLongBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0;
                ++numNegZeros;
            }
            ++i;
        }
        MeArrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = MeArrays.binarySearch(a, 0.0, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0) {
            }
            int k = 0;
            while (k < numNegZeros) {
                a[++j] = -0.0;
                ++k;
            }
        }
    }

    private static void sort2(float[] a, int fromIndex, int toIndex) {
        int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
        int numNegZeros = 0;
        int i = fromIndex;
        int n = toIndex;
        while (i < n) {
            if (a[i] != a[i]) {
                float swap = a[i];
                a[i] = a[--n];
                a[n] = swap;
                continue;
            }
            if (a[i] == 0.0f && Float.floatToIntBits(a[i]) == NEG_ZERO_BITS) {
                a[i] = 0.0f;
                ++numNegZeros;
            }
            ++i;
        }
        MeArrays.sort1(a, fromIndex, n - fromIndex);
        if (numNegZeros != 0) {
            int j = MeArrays.binarySearch(a, 0.0f, fromIndex, n - 1);
            while (--j >= 0 && a[j] == 0.0f) {
            }
            int k = 0;
            while (k < numNegZeros) {
                a[++j] = -0.0f;
                ++k;
            }
        }
    }

    private static void sort1(long[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(int[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(short[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(char[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        char v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(char[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(char[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(byte[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        byte v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(double[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sort1(float[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            int i = off;
            while (i < len + off) {
                int j = i;
                while (j > off && x[j - 1] > x[j]) {
                    MeArrays.swap(x, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = MeArrays.med3(x, l, l + s, l + 2 * s);
                m = MeArrays.med3(x, m - s, m, m + s);
                n = MeArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = MeArrays.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    MeArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    MeArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            MeArrays.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        MeArrays.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        MeArrays.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            MeArrays.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            MeArrays.sort1(x, n - s, s);
        }
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            MeArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void sort(Object[] a) {
        Object[] aux = (Object[])a.clone();
        MeArrays.mergeSort(aux, a, 0, a.length);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = (Object[])a.clone();
        MeArrays.mergeSort(aux, a, fromIndex, toIndex);
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && ComparatorHelper.compareTo(dest[j], dest[j - 1]) > 0) {
                    MeArrays.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = low + high >> 1;
        MeArrays.mergeSort(dest, src, low, mid);
        MeArrays.mergeSort(dest, src, mid, high);
        if (ComparatorHelper.compareTo(src[mid], src[mid - 1]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            dest[i] = q >= high || p < mid && ComparatorHelper.compareTo(src[q], src[p]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void sort(Object[] a, MeComparator c) {
        Object[] aux = (Object[])a.clone();
        if (c == null) {
            MeArrays.mergeSort(aux, a, 0, a.length);
        } else {
            MeArrays.mergeSort(aux, a, 0, a.length, c);
        }
    }

    public static void sort(Object[] a, int fromIndex, int toIndex, MeComparator c) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        Object[] aux = (Object[])a.clone();
        if (c == null) {
            MeArrays.mergeSort(aux, a, fromIndex, toIndex);
        } else {
            MeArrays.mergeSort(aux, a, fromIndex, toIndex, c);
        }
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, MeComparator c) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && c.compare(dest[j - 1], dest[j]) > 0) {
                    MeArrays.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = low + high >> 1;
        MeArrays.mergeSort(dest, src, low, mid, c);
        MeArrays.mergeSort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int i = low;
        int p = low;
        int q = mid;
        while (i < high) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static int binarySearch(long[] a, long key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(int[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(short[] a, short key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(char[] a, char key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(byte[] a, byte key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            byte midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(double[] a, double key) {
        return MeArrays.binarySearch(a, key, 0, a.length - 1);
    }

    private static int binarySearch(double[] a, double key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            double midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(float[] a, float key) {
        return MeArrays.binarySearch(a, key, 0, a.length - 1);
    }

    private static int binarySearch(float[] a, float key, int low, int high) {
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            float midVal = a[mid];
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                int keyBits;
                int midBits = Float.floatToIntBits(midVal);
                int n = midBits == (keyBits = Float.floatToIntBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Object[] a, Object key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = a[mid];
            int cmp = ComparatorHelper.compareTo(key, midVal);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(Object[] a, Object key, MeComparator c) {
        if (c == null) {
            return MeArrays.binarySearch(a, key);
        }
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static boolean equals(long[] a, long[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(int[] a, int[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (Double.doubleToLongBits(a[i]) != Double.doubleToLongBits(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (Float.floatToIntBits(a[i]) != Float.floatToIntBits(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (!(o1 == null ? o2 == null : o1.equals(o2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void fill(long[] a, long val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(int[] a, int val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(short[] a, short val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(char[] a, char val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(byte[] a, byte val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(boolean[] a, boolean val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(double[] a, double val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(float[] a, float val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(Object[] a, Object val) {
        MeArrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        MeArrays.rangeCheck(a.length, fromIndex, toIndex);
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }
}

