/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.deploy.ClassPathManager;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.HttpConnectionException;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.services.MEException;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import com.sapmarkets.wafJLib.PathConversions;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileListHandling;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileStructure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LitsApplicationType
implements ApplicationType {
    private static final String INFO_FILE_EXT = ".srvc";
    private static final String HTRC_PARAM_INVISIBLE = "INVISIBLE";
    private static final String HTRC_PARAM_TITLE = "TITLE";
    private static final String SRVC_PARAM_INVISIBLE = "~INVISIBLE";
    private static final String SRVC_PARAM_VERSION = "~VERSION";
    private final Trace trace = Trace.getInstance("MI/Deployment");
    private DeploymentMessages deplLog = DeploymentMessages.getInstance();
    private InstallationLog log = new InstallationLog("LOG");

    public void install(String source, MobileSolutionDescriptor applicationInfo) throws InstallationException {
        InstallationLog log = new InstallationLog("LOG");
        log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + source);
        this.trace.log(80, "Installation: Link sent from backend is " + source);
        String urlString = this.determineURL(source);
        this.trace.log(80, "Installation: Retrieving application " + applicationInfo.getName() + " from  " + urlString);
        try {
            File fileIn = this.downloadInstallationFile(applicationInfo, urlString);
            ZipFile installationFile = new ZipFile(fileIn);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "INSTALLING", " " + applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
            this.installZip(installationFile, applicationInfo);
            File delfile = new File(fileIn.getAbsolutePath());
            if (delfile.delete()) {
                this.trace.log(80, "Installation: Failed to delete installation file " + fileIn.getAbsolutePath());
            } else {
                this.trace.log(80, "Installation: Deletion of application file " + fileIn.getAbsolutePath() + " successfull ");
            }
        }
        catch (Exception ex) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", " " + urlString);
            this.trace.logException(80, "Installation: Failed to download installation file from " + urlString, ex, true);
            log.addLogEntry(ex.getMessage());
            log.addLogEntry("Application.install: Failed to download installation file from " + urlString);
            throw new InstallationException(7, null, null);
        }
        log.addLogEntry("Installation of " + applicationInfo.getName() + " completed successfully");
        this.putDeploymentInstallLogToInbox(applicationInfo);
        log.sendToR3();
    }

    /*
     * WARNING - void declaration
     */
    public void installZip(ZipFile installationFile, MobileSolutionDescriptor msd) {
        String resourceFileName;
        boolean severeDamage = false;
        InstallationLog log = new InstallationLog("LOG");
        log.addLogEntry("Installing application from file " + installationFile.getName());
        Properties applProps = null;
        Properties applPropsLangDependent = null;
        String currentLanguage = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "");
        if (currentLanguage.trim().equalsIgnoreCase("")) {
            resourceFileName = "";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(msd.getName());
            sb.append("_");
            sb.append(currentLanguage);
            sb.append(".htrc");
            resourceFileName = sb.toString().toLowerCase();
        }
        try {
            PDAFileListHandling plh = new PDAFileListHandling("", "");
            String fileBase = plh.getTopDir();
            String wwwrootdir = plh.getBaseDir();
            log.addLogEntry("TOPDIR: " + fileBase);
            int N = 1024;
            byte[] buffer = new byte[1024];
            FileOutputStream out = null;
            InputStream zin = null;
            boolean allDirCreated = false;
            int levelCount = 0;
            while (!allDirCreated && levelCount < 20) {
                allDirCreated = true;
                ++levelCount;
                Enumeration<? extends ZipEntry> inDirs = installationFile.entries();
                while (inDirs.hasMoreElements()) {
                    ZipEntry zEntry = inDirs.nextElement();
                    if (!zEntry.isDirectory()) continue;
                    StringBuffer sbb = new StringBuffer(fileBase);
                    sbb.append(File.separator);
                    String dirname = PathConversions.getCorrectInstallationPath(sbb.toString(), zEntry.getName());
                    File newDir = new File(dirname);
                    if (newDir.exists()) continue;
                    if (!newDir.mkdirs()) {
                        allDirCreated = false;
                        continue;
                    }
                    msd.addInstalledFile(newDir.getAbsolutePath());
                    log.addLogEntry(dirname + "  created\t");
                }
            }
            Enumeration<? extends ZipEntry> inFiles = installationFile.entries();
            while (inFiles.hasMoreElements()) {
                ZipEntry zEntry = inFiles.nextElement();
                if (zEntry == null) continue;
                try {
                    zin = installationFile.getInputStream(zEntry);
                    if (zEntry.getName().toLowerCase().endsWith("merepmeta.xml")) {
                        log.addLogEntry("LitsApplicationType: Found merepmeta.xml in .zip archive of application " + msd.getName());
                        this.trace.log(80, "LitsApplicationType: Found merepmeta.xml in .zip archive of application " + msd.getName());
                        SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
                        msd.setUsingSmartSync(true);
                        d.setMetaDataFile(msd.getName(), installationFile, zEntry);
                        ConversationId convidShared = ConversationIdHandler.getInstance().getConversationId(msd, UserManagerImpl.getSharedUser());
                        ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForApplication(msd);
                        if (convidShared != null && cis.length > 1) {
                            d.processMetaData(convidShared);
                        }
                    }
                }
                catch (IOException e) {
                    this.trace.logException(e);
                }
                String fileBaseWithSeparator = fileBase.concat(File.separator);
                File applComp = new File(PathConversions.getCorrectInstallationPath(fileBaseWithSeparator, zEntry.getName()));
                if (zEntry.isDirectory()) continue;
                try {
                    int i;
                    int sz = (int)zEntry.getSize();
                    out = new FileOutputStream(applComp);
                    msd.addInstalledFile(applComp.getAbsolutePath());
                    log.addLogEntry(applComp.getAbsolutePath() + "  created\t");
                    while (sz > 0 && (i = zin.read(buffer, 0, Math.min(1024, sz))) != -1) {
                        void var24_31;
                        out.write(buffer, 0, (int)var24_31);
                        sz -= var24_31;
                    }
                    if (applComp.getName().endsWith(resourceFileName)) {
                        applPropsLangDependent = LitsApplicationType._readProperties(applComp.getAbsolutePath());
                    }
                    if (applComp.getName().endsWith(INFO_FILE_EXT)) {
                        applProps = LitsApplicationType._readProperties(applComp.getAbsolutePath());
                    }
                    if (applComp.getName().endsWith(".jar") && Configuration.getInstance().getBoolean("MobileEngine.Deployment.UpdateJarList", false)) {
                        this.updateListOfJars(applComp.getAbsolutePath(), false);
                    }
                }
                catch (IOException ex) {
                    this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                    this.trace.logException(ex);
                    log.addLogEntry(ex.getMessage());
                }
                catch (Exception e) {
                    this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                    log.addLogEntry(e.getMessage());
                }
                if (zin != null) {
                    try {
                        zin.close();
                    }
                    catch (IOException ex) {
                        this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                        log.addLogEntry(ex.getMessage());
                    }
                }
                if (out == null) continue;
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
                    log.addLogEntry(ex.getMessage());
                }
            }
            this.trace.log(80, "Installation: Unpacking of files finished.");
            msd.setVisible(true);
            if (applProps != null && applProps.getProperty(SRVC_PARAM_INVISIBLE) != null) {
                if (applProps.getProperty(SRVC_PARAM_INVISIBLE).equalsIgnoreCase("X")) {
                    msd.setVisible(false);
                } else {
                    msd.setVisible(true);
                }
            }
            if (applPropsLangDependent != null) {
                String description = applPropsLangDependent.getProperty(HTRC_PARAM_TITLE);
                msd.setDescription(description == null ? msd.getName() : description);
                if (applPropsLangDependent != null && applPropsLangDependent.getProperty(HTRC_PARAM_INVISIBLE) != null) {
                    if (applPropsLangDependent.getProperty(HTRC_PARAM_INVISIBLE).equalsIgnoreCase("X")) {
                        msd.setVisible(false);
                    } else {
                        msd.setVisible(true);
                    }
                }
            } else {
                msd.setDescription(msd.getName());
            }
        }
        catch (MEException e) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            log.addLogEntry("Unable to determine file base for installation: " + e.getMessage());
            this.trace.logException(80, "Installation: Unable to determine file base for installation: ", e, false);
        }
        if (msd.getPropertyValueForKey("HOMEPAGE.INVISIBLE").equalsIgnoreCase("X")) {
            msd.setVisible(false);
        } else {
            msd.setVisible(true);
        }
        log.sendToR3();
        if (severeDamage) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            try {
                this.uninstall(msd);
            }
            catch (InstallationException instex) {
                this.trace.logException(instex);
            }
        }
    }

    public void uninstall(MobileSolutionDescriptor application) throws InstallationException {
        File instFile;
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", " " + application.getName() + " " + application.getVersion() + " " + application.getDescription());
        InstallationLog log = new InstallationLog("LOG");
        log.addLogEntry("Removing application " + application.getName());
        this.trace.log(80, "Application.uninstall(): Removing application " + application.getName());
        int deletionCount = 0;
        int instFilesCount = 0;
        String[] instFiles = application.getInstalledFiles();
        Vector<File> notYetDeleted = new Vector<File>();
        int i = 0;
        while (i < instFiles.length) {
            ++instFilesCount;
            File instFile2 = new File(instFiles[i]);
            if (instFile2.getName().endsWith(".jar") && Configuration.getInstance().getBoolean("MobileEngine.Deployment.UpdateJarList", false)) {
                this.updateListOfJars(instFile2.getAbsolutePath(), true);
            }
            if (instFile2.delete()) {
                ++deletionCount;
                this.trace.log(80, "DELETED: " + instFile2.getAbsolutePath());
                log.addLogEntry("DELETED: " + instFile2.getAbsolutePath());
            } else if (!instFile2.getName().endsWith(".htrc") && instFile2.exists()) {
                notYetDeleted.addElement(instFile2);
            } else {
                ++deletionCount;
            }
            ++i;
        }
        Enumeration instFiles2 = notYetDeleted.elements();
        boolean allDirDeleted = false;
        int levelCount = 0;
        while (!allDirDeleted && levelCount < 20) {
            allDirDeleted = true;
            ++levelCount;
            Vector<File> dirNotYetDeleted = new Vector<File>();
            while (instFiles2.hasMoreElements()) {
                instFile = (File)instFiles2.nextElement();
                if (instFile.delete()) {
                    ++deletionCount;
                    this.trace.log(80, "DELETED: " + instFile.getAbsolutePath());
                    log.addLogEntry("DELETED: " + instFile.getAbsolutePath());
                    continue;
                }
                allDirDeleted = false;
                dirNotYetDeleted.addElement(instFile);
            }
            instFiles2 = dirNotYetDeleted.elements();
        }
        if (deletionCount < instFilesCount) {
            StringBuffer sb = new StringBuffer();
            while (instFiles2.hasMoreElements()) {
                instFile = (File)instFiles2.nextElement();
                application.addInstalledFile(instFile.getAbsolutePath());
                log.addLogEntry(instFile.getAbsolutePath() + " still not deleted");
                this.trace.log(80, instFile.getAbsolutePath() + " still not deleted");
                sb.append(instFile.getAbsolutePath()).append(File.pathSeparator);
            }
            this.trace.log(80, "Installation: Removal NOT successfully completed");
        } else {
            this.trace.log(80, "Installation: Removal successfully completed");
        }
        try {
            ApplicationManager.getInstance().saveMobileSolutionDescriptors();
        }
        catch (IOException ioex) {
            this.trace.logException(ioex);
        }
        log.sendToR3();
    }

    public String toString() {
        return "microits";
    }

    private static Properties _readProperties(String infFile) {
        Properties props = new Properties();
        try {
            BufferedUTF8Reader reader = new BufferedUTF8Reader(infFile);
            String val = reader.readLine();
            while (val != null) {
                int idx = -1;
                while (++idx < val.length() && val.charAt(idx) > ' ') {
                }
                String key = val.substring(0, idx++).toUpperCase();
                val = idx < val.length() ? val.substring(idx).trim() : "";
                ((Hashtable)props).put(key, val);
                val = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return props;
    }

    private void putDeploymentInstallLogToInbox(MobileSolutionDescriptor applicationInfo) {
        DeploymentInstallLog d = new DeploymentInstallLog(applicationInfo.getName());
        d.appendLines(this.log.getLogEntries());
        DeploymentInbox.getInstance().setApplicationLog(d);
    }

    private String determineURL(String source) throws InstallationException {
        String urlString = null;
        if (!(source.startsWith("http") || source.startsWith("HTTP") || source.toLowerCase().startsWith("file"))) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", source);
            AppLog.getInstance("MI/Core").log(50, "Installation: Failed to download installation file because download link sent was: " + source);
            throw new InstallationException(7, null, null);
        }
        urlString = source;
        return urlString;
    }

    private void updateListOfJars(String absoluteJarFilePath, boolean remove) {
        ClassPathManager jfm = ClassPathManager.getInstance();
        if (remove) {
            jfm.removeFromClassPath(absoluteJarFilePath);
        } else {
            jfm.addToClassPath(absoluteJarFilePath);
        }
    }

    private File downloadInstallationFile(MobileSolutionDescriptor applicationInfo, String urlString) throws MEException, HttpConnectionException {
        File f = null;
        if (!applicationInfo.isInstallationFileAlreadyDownloaded()) {
            this.log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + urlString);
            PDAFileListHandling plh = new PDAFileListHandling(PDAFileStructure.INSTALLATION_DIR, ".zip");
            f = new File(plh.getFileName(applicationInfo.getName()));
            boolean bWithProxy = false;
            if (Configuration.getInstance().getBoolean("MobileEngine.Sync.Proxyused", false)) {
                bWithProxy = true;
            }
            SyncSettings.updateSystemProxySettings();
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "DOWNLOADING", " " + applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
            IOUtils.httpGet(urlString, f.getAbsolutePath());
            this.log.addLogEntry("Downloaded installation file to: " + f.getAbsolutePath());
            if (this.trace.isLogging(80)) {
                this.trace.log(80, "Installation: Download of application " + applicationInfo.getName() + "successfull " + urlString);
            }
            return f;
        }
        String localfile = applicationInfo.getCustomizingValueForKey("LOCALPATH");
        this.trace.log(80, "Installation: Using already downloaded application file: " + localfile);
        this.log.addLogEntry("Installation: Using already downloaded application file: " + localfile);
        return new File(localfile);
    }
}

