/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.apps.DeploymentInbox;
import com.sap.ip.me.apps.DeploymentInstallLog;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.CleanupListWriter;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JspApplicationType
implements ApplicationType {
    private final Trace trace = Trace.getInstance("MI/Deployment");
    private InstallationLog log = new InstallationLog("LOG");
    private DeploymentMessages deplLog = DeploymentMessages.getInstance();

    public void install(String source, MobileSolutionDescriptor applicationInfo) throws InstallationException {
        this.log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + source);
        this.trace.log(80, "Installation: Link sent from backend is " + source);
        String urlString = this.determineUrl(source);
        File fileIn = new File(applicationInfo.getName().concat(".war"));
        String webappsfolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "webapps" + File.separator;
        File warFile = new File(webappsfolder.concat(fileIn.getName()));
        warFile = this.downloadInstallationFile(urlString, applicationInfo, warFile);
        this.trace.log(90, "JspApplicationType.install: webappsfolder is " + webappsfolder);
        this.trace.log(90, "JspApplicationType.install: File for downloading .war file is " + warFile.getAbsolutePath());
        try {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "INSTALLING", " " + applicationInfo.getName() + " " + applicationInfo.getVersion() + ": " + applicationInfo.getDescription());
            this.evaluateWarFile(warFile.getAbsolutePath(), applicationInfo);
        }
        catch (ZipException zipex) {
            this.trace.log(50, "JspApplicationType.install: caught exception " + zipex.getMessage());
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", zipex.getMessage());
            throw new InstallationException(8, null, null);
        }
        catch (IOException ioex) {
            this.trace.log(50, "JspApplicationType.install: caught exception " + ioex.getMessage());
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", ioex.getMessage());
            throw new InstallationException(8, null, null);
        }
        this.log.sendToR3();
        this.putDeploymentInstallLogToInbox(applicationInfo);
        if (applicationInfo.getPropertyValueForKey("HOMEPAGE.INVISIBLE").equalsIgnoreCase("X")) {
            applicationInfo.setVisible(false);
        } else {
            applicationInfo.setVisible(true);
        }
    }

    public void uninstall(MobileSolutionDescriptor application) throws InstallationException {
        this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLING", " " + application.getName() + " " + application.getVersion() + " " + application.getDescription());
        String webappsfolder = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "webapps" + File.separator;
        this.trace.log(90, "JspApplicationType.uninstall: webappsfolder is " + webappsfolder);
        File jspDir = new File(webappsfolder.concat(application.getName()));
        this.trace.log(80, "JspApplicationType.uninstall: JSP directory to be deleted is " + jspDir.getAbsolutePath());
        boolean success = IOUtils.deleteDirectoryRecursively(jspDir);
        if (success) {
            this.trace.log(80, "JspApplicationType.uninstall: JSP directory  " + jspDir.getAbsolutePath() + " successfully deleted");
            File workDirectory = new File(Configuration.getInstance().getProperty("MobileEngine.InstallationPath").concat(File.separator).concat("work"));
            String[] subDirs = workDirectory.list();
            int index = 0;
            while (index < subDirs.length) {
                if (subDirs[index].indexOf(application.getName()) > -1) {
                    boolean success2 = IOUtils.deleteDirectoryRecursively(new File(workDirectory + File.separator + subDirs[index]));
                    if (success2) {
                        this.trace.log(80, "JspApplicationType.uninstall: Corresponding 'work' subdirectory " + subDirs[index] + " successfully removed");
                    } else {
                        this.trace.log(80, "JspApplicationType.uninstall: Corresponding 'work' subdirectory " + subDirs[index] + " could not be removed");
                    }
                }
                ++index;
            }
            try {
                ApplicationManager.getInstance().saveMobileSolutionDescriptors();
            }
            catch (IOException ioex) {
                this.trace.logException("Cannot write registry", (Throwable)ioex, true);
            }
        } else {
            this.deplLog.addMessage(DeploymentMessages.TYPE_DEINSTALLATION, "UNINSTALLATIONFAILURE", null);
            CleanupListWriter.writeToFile(jspDir.getAbsolutePath().concat(File.pathSeparator));
            throw new InstallationException(6, null, null);
        }
    }

    public String toString() {
        return "JSP";
    }

    private Properties readProperties(String infFile) {
        Properties props = new Properties();
        File file = new File(infFile);
        try {
            FileInputStream fis = new FileInputStream(file);
            props.load(fis);
            fis.close();
        }
        catch (IOException ex) {
            this.trace.logException(ex);
        }
        return props;
    }

    private void downloadWarFile(String url, String path) throws Exception {
        SyncSettings.updateSystemProxySettings();
        IOUtils.httpGet(url, path);
    }

    private String determineUrl(String source) throws InstallationException {
        String urlString = null;
        if (!(source.startsWith("http") || source.startsWith("HTTP") || source.toLowerCase().startsWith("file"))) {
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "FAILEDTOINST", null);
            this.deplLog.addMessage(DeploymentMessages.TYPE_INSTALLATION, "xmsg_FAILEDTODOWNLOAD", source);
            AppLog.getInstance("MI/Core").log(50, "Installation: Failed to download installation file because download link sent was: " + source);
            throw new InstallationException(7, null, null);
        }
        urlString = source;
        return urlString;
    }

    private void evaluateWarFile(String path, MobileSolutionDescriptor ai) throws ZipException, IOException {
        ZipFile zip = new ZipFile(path);
        Enumeration<? extends ZipEntry> warFileEntries = zip.entries();
        Configuration config = Configuration.getInstance();
        String baseDir = config.getProperty("MobileEngine.InstallationPath");
        String msdDescriptionFromWebConsole = ai.getDescription();
        int N = 512;
        byte[] buf = new byte[512];
        while (warFileEntries.hasMoreElements()) {
            File tempFile;
            ZipEntry warFileEntry = warFileEntries.nextElement();
            String ResourceBundleName = "";
            String language = Configuration.getInstance().getProperty("MobileEngine.Sync.Language", "").toLowerCase();
            String currentEntryName = warFileEntry.getName();
            if (currentEntryName.toLowerCase().endsWith("meta-inf/manifest.mf")) {
                currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
                tempFile = IOUtils.extractZipFile(zip, warFileEntry, baseDir + File.separator + currentEntryName);
                Properties manifestfile = new Properties();
                this.trace.log(80, "Evaluation manifest file ''{0}''", (Object)tempFile.getAbsolutePath());
                FileInputStream fis = new FileInputStream(new File(tempFile.getAbsolutePath()));
                manifestfile.load(fis);
                fis.close();
                String applClassname = manifestfile.getProperty("ApplicationClass");
                ai.setTargetClassname(applClassname);
                this.trace.log(80, "The class that implement the Application interface: ''{0}''", (Object)applClassname);
            }
            if (currentEntryName.endsWith(".properties")) {
                String desc;
                currentEntryName = currentEntryName.substring(currentEntryName.lastIndexOf("/") + 1, currentEntryName.length());
                tempFile = new File(currentEntryName);
                InputStream is = zip.getInputStream(warFileEntry);
                BufferedInputStream bis = new BufferedInputStream(is);
                FileOutputStream fos = new FileOutputStream(tempFile.getAbsolutePath());
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                int sz = (int)warFileEntry.getSize();
                int ln = 0;
                while (sz > 0 && (ln = bis.read(buf, 0, Math.min(512, sz))) != -1) {
                    bos.write(buf, 0, ln);
                    sz -= ln;
                }
                bos.flush();
                bos.close();
                fos.close();
                this.trace.log(80, "JspApplicationType.install: trying to get description out of ResourceBundle:" + tempFile.getAbsolutePath());
                this.log.addLogEntry("JspApplicationType.install: trying to get description out of ResourceBundle:" + tempFile.getAbsolutePath());
                if (currentEntryName.indexOf("_" + language) > 1) {
                    desc = this.readProperties(tempFile.getAbsolutePath()).getProperty("TITLE");
                    ai.setDescription(desc);
                    this.trace.log(80, "JspApplicationType.install: Title out of language matching ResourceBundle is " + desc);
                    this.log.addLogEntry("JspApplicationType.install: Title out of language matching ResourceBundle is " + desc);
                    if (desc != null && desc != " ") {
                        this.log.addLogEntry("JspApplicationType.install: Description is set, stopped searching for ResourceBundle");
                        this.trace.log(80, "JspApplicationType.install: Description is set, stopped searching for ResourceBundle");
                        this.trace.log(80, "JspApplicationType.install: Deletion status of " + tempFile.getAbsolutePath() + " is " + new File(tempFile.getAbsolutePath()).delete());
                        break;
                    }
                } else if (currentEntryName.indexOf("_") > 1 && currentEntryName.indexOf("language") == -1) {
                    this.trace.log(80, "JspApplicationType.install: Skipping " + currentEntryName);
                    this.log.addLogEntry("JspApplicationType.install: Skipping " + currentEntryName);
                } else {
                    desc = this.readProperties(tempFile.getAbsolutePath()).getProperty("TITLE");
                    ai.setDescription(desc);
                    if (desc != null && desc.length() != 0 && desc != " ") {
                        this.trace.log(80, "JspApplicationType.install: found a general title " + desc + " in file " + tempFile.getAbsolutePath());
                        this.log.addLogEntry("JspApplicationType.install: found a general title " + desc + " in file " + tempFile.getAbsolutePath());
                    }
                }
                this.log.addLogEntry("JspApplicationType.install(File warFile): Deletion status of " + tempFile.getAbsolutePath() + " is " + new File(tempFile.getAbsolutePath()).delete());
                this.trace.log(80, "JspApplicationType.install(File warFile): Deletion status of " + tempFile.getAbsolutePath() + " is " + new File(tempFile.getAbsolutePath()).delete());
            }
            if (!currentEntryName.toLowerCase().endsWith("merepmeta.xml")) continue;
            this.log.addLogEntry("JspApplicationType.install(File warFile): Found merepmeta.xml in .war archive of application " + ai.getName());
            this.trace.log(80, "JspApplicationType.install(File warFile): Found merepmeta.xml in .war archive of application " + ai.getName());
            SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
            ai.setUsingSmartSync(true);
            d.setMetaDataFile(ai.getName(), zip, warFileEntry);
            ConversationId convidShared = ConversationIdHandler.getInstance().getConversationId(ai, UserManagerImpl.getSharedUser());
            ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForApplication(ai);
            if (convidShared == null || cis.length <= 1) continue;
            d.processMetaData(convidShared);
        }
        if (ai.getDescription() == null || ai.getDescription().length() == 0 || ai.getDescription() == " ") {
            if ("".equals(msdDescriptionFromWebConsole) || msdDescriptionFromWebConsole == null) {
                ai.setDescription(ai.getName());
            } else {
                ai.setDescription(msdDescriptionFromWebConsole);
            }
        }
        zip.close();
    }

    private File downloadInstallationFile(String source, MobileSolutionDescriptor applicationInfo, File warFile) throws InstallationException {
        if (!applicationInfo.isInstallationFileAlreadyDownloaded()) {
            this.log.addLogEntry("Retrieving application " + applicationInfo.getName() + " from  " + source);
            try {
                this.downloadWarFile(source, warFile.getAbsolutePath());
                this.log.addLogEntry("JspApplicationType.install: downloaded installation file to: " + warFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.log.addLogEntry(e.getMessage());
                this.log.addLogEntry("JspApplicationType.install: Failed to download installation file from " + source);
                throw new InstallationException(7, null, null);
            }
            return warFile;
        }
        this.log.addLogEntry("Retrieving JSP application " + applicationInfo.getName() + " from  " + applicationInfo.getCustomizingValueForKey("LOCALPATH"));
        File newfile = new File(applicationInfo.getCustomizingValueForKey("LOCALPATH"));
        if (IOUtils.moveFileToDirectory(newfile, new File(warFile.getParent()))) {
            this.log.addLogEntry("JspApplicationType.install: copied installation file to: " + warFile.getParent().concat(File.separator).concat(newfile.getName()));
            return new File(warFile.getParent().concat(File.separator).concat(newfile.getName()));
        }
        throw new InstallationException(7, null, null);
    }

    private void putDeploymentInstallLogToInbox(MobileSolutionDescriptor applicationInfo) {
        DeploymentInstallLog d = new DeploymentInstallLog(applicationInfo.getName());
        d.appendLines(this.log.getLogEntries());
        DeploymentInbox.getInstance().setApplicationLog(d);
    }
}

