/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.services.Log;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    private String jarFileName;

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    public byte[] getResource(String name) {
        return (byte[])this.htJarContents.get(name);
    }

    private void init() {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = (Integer)this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = zis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
            }
        }
        catch (NullPointerException e) {
            Log.logException(e);
        }
        catch (FileNotFoundException e) {
            Log.logException(e);
        }
        catch (IOException e) {
            Log.logException(e);
        }
    }
}

