/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.deploy.ClassPathManager;
import com.sap.ip.me.api.logging.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;

public class JarFileManager
extends ClassPathManager {
    private static final String NSICOM = "NSIcom";
    private static final String delimiter = ";";
    private final Trace trace = Trace.getInstance("MI/Core");
    private static String jarListFileName = "listOfJars.txt";
    private static String cremeJarListFileName = "creme_listOfJars.txt";
    private static String encoding = System.getProperty("file.encoding");
    private File jarListFile;
    private File cremeJarListFile;
    private Vector currentEntries;

    public JarFileManager() {
        this.createJarListFile();
        if (Configuration.getJVMVendorName().equalsIgnoreCase(NSICOM)) {
            this.createCremeJarListFile();
        }
        this.initCurrentEntries();
    }

    public void addToClassPath(String absoluteFilePath) {
        if (this.isValidParameter(absoluteFilePath)) {
            this.addToJarList(absoluteFilePath.trim());
        }
    }

    public void removeFromClassPath(String absoluteFilePath) {
        if (this.isValidParameter(absoluteFilePath)) {
            this.removeFromJarList(absoluteFilePath.trim());
        }
    }

    private boolean isValidParameter(String s) {
        if (s == null) {
            return false;
        }
        return !"".equals(s.trim());
    }

    private void addToJarList(String jarFileAbsolutePath) {
        if (!this.isItInListOfJars(jarFileAbsolutePath)) {
            this.trace.log(80, "Adding " + jarFileAbsolutePath + "to " + this.jarListFile.getAbsolutePath());
            StringBuffer newContent = new StringBuffer(jarFileAbsolutePath).append(delimiter).append((Object)this.readJarListFile());
            this.writeFile(newContent);
            this.currentEntries.addElement(jarFileAbsolutePath);
        }
    }

    private void removeFromJarList(String jarFileAbsolutePath) {
        if (this.isItInListOfJars(jarFileAbsolutePath)) {
            this.trace.log(80, "Removing " + jarFileAbsolutePath + "from  " + this.jarListFile.getAbsolutePath());
            StringTokenizer st = new StringTokenizer(this.readJarListFile().toString(), delimiter);
            StringBuffer newFileContent = new StringBuffer();
            while (st.hasMoreTokens()) {
                String currentToken = st.nextToken();
                if (jarFileAbsolutePath.equalsIgnoreCase(currentToken)) continue;
                newFileContent.append(currentToken).append(delimiter);
            }
            this.writeFile(newFileContent);
            this.currentEntries.removeElement(jarFileAbsolutePath);
        }
    }

    private void initCurrentEntries() {
        this.currentEntries = new Vector();
        StringBuffer sb = this.readJarListFile();
        if (sb.length() > 0) {
            StringTokenizer st = new StringTokenizer(sb.toString().substring(0, sb.toString().length() - 1), delimiter);
            while (st.hasMoreTokens()) {
                this.currentEntries.addElement(st.nextToken());
            }
        }
    }

    private boolean isItInListOfJars(String fileToBeDeleted) {
        int max = this.currentEntries.size();
        int i = 0;
        while (i < max) {
            if (fileToBeDeleted.equals((String)this.currentEntries.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createCremeJarListFile() {
        Configuration config = Configuration.getInstance();
        StringBuffer sb = new StringBuffer(config.getProperty("MobileEngine.InstallationPath"));
        if (sb == null) {
            this.trace.log(80, "Cannot create file " + cremeJarListFileName + " because property " + "MobileEngine.InstallationPath" + " is not set!");
            return;
        }
        sb.append(File.separator);
        sb.append(cremeJarListFileName);
        String filename = config.getProperty("MobileEngine.Runtime.JVM.ListOfJarsFile", sb.toString());
        this.cremeJarListFile = new File(filename);
    }

    private void createJarListFile() {
        StringBuffer sb = new StringBuffer(Configuration.getInstance().getProperty("MobileEngine.InstallationPath"));
        if (sb == null) {
            this.trace.log(80, "Cannot create file " + jarListFileName + " because property " + "MobileEngine.InstallationPath" + " is not set!");
            return;
        }
        sb.append(File.separator);
        sb.append(jarListFileName);
        this.jarListFile = new File(sb.toString());
    }

    private String determineFileEncoding() throws IOException {
        FileInputStream fis = new FileInputStream(this.jarListFile.getAbsolutePath());
        try {
            int i = fis.read();
            int j = fis.read();
            fis.close();
            if (i == 255 && j == 254) {
                return "Unicode";
            }
            if (i == 254 && j == 255) {
                return "Unicode";
            }
            return "UTF8";
        }
        catch (IOException ioex) {
            fis.close();
            throw ioex;
        }
    }

    private void writeFile(StringBuffer fileContent) {
        OutputStreamWriter osw = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(this.jarListFile);
                osw = new OutputStreamWriter((OutputStream)fos, encoding);
                osw.write(fileContent.toString());
            }
            catch (IOException e) {
                this.trace.logException(e);
                Object var5_6 = null;
                this.closeWriter(osw);
            }
            Object var5_5 = null;
            this.closeWriter(osw);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeWriter(osw);
            throw throwable;
        }
        if (Configuration.getJVMVendorName().equalsIgnoreCase(NSICOM)) {
            this.writeFileForCremeVM(fileContent);
        }
    }

    private void writeFileForCremeVM(StringBuffer fileContent) {
        OutputStreamWriter osw = null;
        try {
            try {
                String filecontentString = fileContent.toString();
                boolean containSpaces = filecontentString.indexOf(32) > -1;
                StringBuffer cremeContent = new StringBuffer(fileContent.length() + 20);
                cremeContent.append("-classpath ");
                if (containSpaces) {
                    cremeContent.append("'");
                }
                cremeContent.append(filecontentString);
                if (containSpaces) {
                    cremeContent.append("'");
                }
                FileOutputStream fos = new FileOutputStream(this.cremeJarListFile);
                osw = new OutputStreamWriter((OutputStream)fos, encoding);
                osw.write(cremeContent.toString());
            }
            catch (IOException e) {
                this.trace.logException(e);
                Object var8_9 = null;
                this.closeWriter(osw);
            }
            Object var8_8 = null;
            this.closeWriter(osw);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeWriter(osw);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private StringBuffer readJarListFile() {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader in = null;
        try {
            try {
                String line;
                encoding = this.determineFileEncoding();
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.jarListFile.getAbsolutePath()), encoding);
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    void var4_5;
                    fileContent.append((String)var4_5);
                }
            }
            catch (IOException e) {
                this.trace.logException(e);
                Object var6_7 = null;
                this.closeReader(in);
            }
            Object var6_6 = null;
            this.closeReader(in);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeReader(in);
            throw throwable;
        }
        return fileContent;
    }

    private void closeReader(Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e1) {
            this.trace.logException(e1);
        }
    }

    private void closeWriter(Writer out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e1) {
            this.trace.logException(e1);
        }
    }
}

