/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.LogonListener;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UnknownApplicationTypeException;

public class InstallationSequenceInstallTrigger
implements LogonListener {
    public void userLoggedOn(User user) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        MobileSolutionDescriptor is = appManager.getInstallationSequence();
        if (is != null && !is.isInstalled()) {
            MobileSolutionDescriptor[] msds = ConversationIdHandler.getInstance().getAllMobileSolutionDescriptorsForUser(user);
            boolean start = false;
            int i = 0;
            while (i < msds.length) {
                if (msds[i].equals(is)) {
                    start = true;
                    break;
                }
                ++i;
            }
            if (start) {
                this.continueInstallation(is);
            }
        }
    }

    private void continueInstallation(MobileSolutionDescriptor is) {
        Trace t = Trace.getInstance("MI/Deployment");
        t.log(80, "Continue installation of " + is);
        try {
            ApplicationManager.getInstance().installApplication(is);
        }
        catch (InstallationException e) {
            t.logException(e);
        }
        catch (UnknownApplicationTypeException e) {
            t.logException(e);
        }
    }
}

