/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.DateFormatter;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.LogSender;
import com.sap.ip.me.sync.SyncOutboundContainer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class InstallationLog
implements InboundProcessor {
    public static final String LOGTYPE = "LOG";
    public static final String TRACETYPE = "TRACE";
    protected static final String LOG_SYNC_METHOD = "WAF_INSTALLATION_LOG";
    static final long serialVersionUID = -8296306735758335101L;
    String _deploymentID;
    String _user;
    Vector logEntries = new Vector();

    public InstallationLog() {
        User u = UserManager.getInstance().getCurrentUser();
        this._user = u == null ? "" : u.getUniqueName();
        this.setDeploymentID(ConversationIdHandler.getDeviceId());
    }

    public InstallationLog(String type) {
        User u = UserManager.getInstance().getCurrentUser();
        this._user = u == null ? "" : u.getUniqueName();
        this.setDeploymentID(ConversationIdHandler.getDeviceId());
        this.logEntries.addElement(type);
    }

    public static void sendLogToBackend() {
        LogSender.sendLogToBackend(Trace.getInstance("MI/Core"));
    }

    public void setDeploymentID(String deploymentID) {
        this._deploymentID = deploymentID;
    }

    public void addLogEntry(String logEntry) {
        this.logEntries.addElement(logEntry);
    }

    public void sendToR3() {
        try {
            String dateABAP = DateFormatter.getCurrentDateABAP();
            String timeABAP = DateFormatter.getCurrentTimeABAP();
            OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.USER_SHARED, LOG_SYNC_METHOD);
            Enumeration ent = this.logEntries.elements();
            cont.addItem("DEPLID", this._deploymentID);
            cont.addItem("USERNAME", this._user);
            cont.addItem("DATE", dateABAP);
            cont.addItem("TIME", timeABAP);
            while (ent.hasMoreElements()) {
                cont.addItem(LOGTYPE, (String)ent.nextElement());
            }
            cont.close();
        }
        catch (SyncException s) {
            Trace.getInstance("MI/Core").logException("Exception while creating WAF_INSTALLATION_LOG container", (Throwable)s, false);
        }
    }

    public static void sendInstalltionLogFileToR3(String instlogfilename, MobileSolutionDescriptor msd) {
        try {
            String dateABAP = DateFormatter.getCurrentDateABAP();
            String timeABAP = DateFormatter.getCurrentTimeABAP();
            ConversationIdHandler handler = ConversationIdHandler.getInstance();
            ConversationId[] convids = handler.getAllConversationIdsForApplication(msd);
            ConversationId convid = null;
            int i = 0;
            while (i < convids.length) {
                if (!convids[i].getUser().equals(UserManagerImpl.getSharedUser())) {
                    convid = handler.getConversationId(ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor(), convids[i].getUser());
                    break;
                }
                ++i;
            }
            OutboundContainer cont = null;
            cont = convid != null ? new SyncOutboundContainer(convid, LOG_SYNC_METHOD, "R") : OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.USER_SHARED, LOG_SYNC_METHOD);
            BufferedUTF8Reader reader = new BufferedUTF8Reader(instlogfilename);
            String line = null;
            cont.addItem("USERNAME", convid != null ? convid.getUser().getUniqueID() : "");
            cont.addItem("DEPLID", ConversationIdHandler.getDeviceId());
            cont.addItem("DATE", dateABAP);
            cont.addItem("TIME", timeABAP);
            cont.addItem(LOGTYPE, "LOG, Device id = " + ConversationIdHandler.getDeviceId());
            while ((line = reader.readLine()) != null) {
                cont.addItem(LOGTYPE, line);
            }
            reader.close();
            cont.close();
        }
        catch (SyncException s) {
            Trace.getInstance("MI/Core").logException("Exception while creating WAF_INSTALLATION_LOG container", (Throwable)s, false);
        }
        catch (IOException ioex) {
            Trace.getInstance("MI/Core").logException("Exception while reading installation log file", (Throwable)ioex, false);
        }
    }

    public String getMethodName() {
        return LOG_SYNC_METHOD;
    }

    public void process(InboundContainer in) {
        System.out.println(in);
    }

    public Vector getLogEntries() {
        return this.logEntries;
    }
}

