/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.Localization;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceImplementation;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.user.LogonException;
import com.sap.ip.me.ccms.AlertManager;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.CommunicationServer;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.InstallationLog;
import com.sap.ip.me.core.InstallationSequenceInstallTrigger;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.TempInternetCacheEraser;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.itool.InstallationSession;
import com.sap.ip.me.services.MIStartupListener;
import com.sap.ip.me.services.os.AgentManager;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import com.sap.ip.me.sync.SyncTimer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class FrameworkInitializer {
    static final String CONFIGURATION_FILENAME;
    private static final String INST_DIR_PLACEHOLDER = "%d%";
    private static boolean startbatch;
    private static CommunicationServer communicationServer;
    private String logonuser;
    private String logonpwd;

    public static void main(String[] args) {
        try {
            FrameworkInitializer s = new FrameworkInitializer();
            if (FrameworkInitializer.stopIt(args)) {
                s.initConfiguration(args);
                String runtime = Configuration.getInstance().getProperty("Runtime");
                if ("awt".equalsIgnoreCase(runtime)) {
                    s.stopAwtHome();
                } else if ("lits".equalsIgnoreCase(runtime)) {
                    s.stopLitsServer();
                } else {
                    s.stopTomcat();
                }
            } else {
                s.initializeFramework(args);
                boolean normalstartup = true;
                if (startbatch) {
                    normalstartup = !s.runWithinBatchMode();
                }
                System.out.println("Use normal startup: " + normalstartup);
                s.callStartupListener();
                if (normalstartup) {
                    s.logon();
                    String runtime = Configuration.getInstance().getProperty("Runtime");
                    if ("awt".equalsIgnoreCase(runtime)) {
                        s.startAwtHome();
                    } else if ("lits".equalsIgnoreCase(runtime)) {
                        s.startLitsServer();
                    } else {
                        s.startTomcat();
                    }
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception t) {
            System.err.println("Error while initialize the framework: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    private static boolean stopIt(String[] args) {
        boolean result = false;
        int i = 0;
        while (!result && i < args.length) {
            result = result || "-stop".equalsIgnoreCase(args[i]);
            ++i;
        }
        return result;
    }

    private void callStartupListener() {
        String startupListenerClassname = Configuration.getInstance().getProperty("MI.Startup.ListenerClassname");
        if ("".equals(startupListenerClassname) || startupListenerClassname == null) {
            return;
        }
        try {
            Class<?> c = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader().loadClass(startupListenerClassname) : Class.forName(startupListenerClassname);
            if (c != null) {
                Object o = c.newInstance();
                MIStartupListener mil = (MIStartupListener)o;
                mil.onStartup();
            }
        }
        catch (ClassNotFoundException e) {
            AppLog.getInstance("MI/Core").logException(50, e.getMessage(), null, e, true);
        }
        catch (InstantiationException e) {
            AppLog.getInstance("MI/Core").logException(50, e.getMessage(), null, e, true);
        }
        catch (IllegalAccessException e) {
            AppLog.getInstance("MI/Core").logException(50, e.getMessage(), null, e, true);
        }
        catch (ClassCastException e) {
            AppLog.getInstance("MI/Core").logException(50, e.getMessage(), null, e, true);
        }
    }

    private void initializeFramework(String[] args) {
        System.out.println("------------ Initialize framework ...");
        this.initConfiguration(args);
        System.out.println("   Configuration initialized. Installation Base = " + Configuration.getInstallationDirectory());
        this.initPaths();
        System.out.println("   Path settings adjusted");
        TimeZone timezone = Localization.getTimeZone();
        Localization.setTimeZone(timezone);
        System.out.println("   Timezone initialized; use timezone id '" + timezone.getID() + "'");
        this.initTrace();
        System.out.println("   Trace initialized. Log is " + (Trace.getInstance("MI/Core").isOn() ? "" : "not ") + "switched on.");
        this.initSingletons();
        System.out.println("   Framework singletons initialized.");
        this.initGzipDataCompressionConfiguration();
        System.out.println("   Gzip data compression configuration initialized.");
        this.initRegistry();
        System.out.println("   Registry initialized.");
        this.initDlls();
        System.out.println("   Dlls loaded.");
        this.initTimedSync();
        System.out.println("   Timed Sync initialized.");
        this.initPersistence();
        System.out.println("   Persistence initialized.");
        this.initSmartSync();
        System.out.println("   Smart Sync initialized.");
        this.initCCMS();
        System.out.println("   CCMS initialized.");
        this.initAgents();
        System.out.println("   Agents initialized.");
        CommunicationServer.initialize();
        System.out.println("   Communication server initialized.");
        ApplicationManager appman = ApplicationManager.getInstance();
        appman.registerStatusUpdater();
        appman.updateClientInstallerArchiveStates();
        System.out.println("   Client Installer Packages status updated.");
        this.initPPC2003WorkaroundForBrowserCache();
        UserManagerImpl.getUserManagerImplInstance().addLogonListener(new InstallationSequenceInstallTrigger());
        System.out.println("------------ Framework initialized");
        InstallationSession session = new InstallationSession();
        System.out.println("------------ Check if running inside installation server");
        session.run();
    }

    private void initConfiguration(String[] args) {
        Configuration config = Configuration.getInstance();
        int i = 0;
        while (i < args.length) {
            String value;
            int p = args[i].indexOf(58);
            if (p == -1) {
                p = args[i].length();
            }
            String key = args[i].substring(1, p);
            String string = value = ++p >= args[i].length() ? "" : args[i].substring(p);
            if ("home".equalsIgnoreCase(key)) {
                key = "MobileEngine.InstallationPath";
            } else if ("trace".equalsIgnoreCase(key)) {
                key = "MobileEngine.Trace.Enabled";
                value = "true";
            } else if ("batch".equalsIgnoreCase(key)) {
                key = "MobileEngine.BatchMode";
                value = "true";
                startbatch = true;
            } else if ("logon".equalsIgnoreCase(key)) {
                int p2 = value.indexOf(":");
                if (p2 == -1) {
                    p2 = value.length();
                }
                this.logonuser = value.substring(0, p2);
                if (p2 + 1 < value.length()) {
                    this.logonpwd = value.substring(p2 + 1);
                }
                key = "Autologon";
                value = "true";
            }
            config.setTemporary(key, value);
            ++i;
        }
        if (config.getProperty("MobileEngine.InstallationPath") == null) {
            System.err.println("Use ''-home:<ME installation folder>'' to start the Mobile Engine");
            System.exit(1);
        }
        config.loadConfiguration(config.getProperty("MobileEngine.InstallationPath") + CONFIGURATION_FILENAME);
    }

    private void initTrace() {
        Trace.getInstance("MI/Core");
        AppLog.getInstance("MI/Core");
    }

    private void initRegistry() {
        ApplicationManager.getInstance();
    }

    private void initAgents() {
        AgentManager.getInstance();
    }

    private void startTomcat() {
        try {
            Class<?> tomcatMainclass = null;
            if (this.getClass().getClassLoader() != null) {
                tomcatMainclass = this.getClass().getClassLoader().loadClass("org.apache.tomcat.startup.Tomcat");
            } else {
                this.getClass();
                tomcatMainclass = Class.forName("org.apache.tomcat.startup.Tomcat");
            }
            Method mainMethod = tomcatMainclass.getMethod("main", new String[1].getClass());
            mainMethod.invoke(null, new Object[]{new String[0]});
        }
        catch (Exception ex) {
            System.err.println("Cannot start Tomcat: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private void stopTomcat() {
        try {
            Class<?> tomcatMainclass = null;
            if (this.getClass().getClassLoader() != null) {
                tomcatMainclass = this.getClass().getClassLoader().loadClass("org.apache.tomcat.startup.Tomcat");
            } else {
                this.getClass();
                tomcatMainclass = Class.forName("org.apache.tomcat.startup.Tomcat");
            }
            Method mainMethod = tomcatMainclass.getMethod("main", new String[1].getClass());
            mainMethod.invoke(null, new Object[]{new String[]{"-stop"}});
        }
        catch (Exception ex) {
            System.err.println("Cannot stop Tomcat: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private void startLitsServer() {
        try {
            Class<?> tomcatMainclass = null;
            if (this.getClass().getClassLoader() != null) {
                tomcatMainclass = this.getClass().getClassLoader().loadClass("com.sapmarkets.web.server.Startup");
            } else {
                this.getClass();
                tomcatMainclass = Class.forName("com.sapmarkets.web.server.Startup");
            }
            Method mainMethod = tomcatMainclass.getMethod("main", new String[1].getClass());
            mainMethod.invoke(null, new Object[]{new String[0]});
        }
        catch (Exception ex) {
            System.err.println("Cannot start liTS-Server: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private void stopLitsServer() {
        String fname = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "run.txt";
        try {
            PrintWriter pout = new PrintWriter(new FileOutputStream(fname, false));
            pout.print("0");
            pout.flush();
            pout.close();
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace(System.err);
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
        }
    }

    private void startAwtHome() {
        try {
            Class<?> awtMainClass = null;
            if (this.getClass().getClassLoader() != null) {
                awtMainClass = this.getClass().getClassLoader().loadClass("com.sap.ip.me.awtapps.home.HomeFrame");
            } else {
                this.getClass();
                awtMainClass = Class.forName("com.sap.ip.me.awtapps.home.HomeFrame");
            }
            Method mainMethod = awtMainClass.getMethod("main", new String[1].getClass());
            mainMethod.invoke(null, new Object[]{new String[0]});
        }
        catch (Exception ex) {
            System.err.println("Cannot start awtHome: " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private void stopAwtHome() {
        System.err.println("Shutdown of ME-AWT is not supported yet.");
    }

    private void initPaths() {
        String topdir;
        String wwwroot;
        Configuration config = Configuration.getInstance();
        boolean usingTomDirs = config.getBoolean("Init.UsingTomcatDirs", true);
        Properties p = System.getProperties();
        if (usingTomDirs) {
            String value = config.getProperty("tomcat.userdir");
            if (value == null) {
                value = config.getProperty("MobileEngine.InstallationPath") + File.separator + "webapps" + File.separator + "me";
                config.setTemporary("tomcat.userdir", value);
            }
            ((Hashtable)p).put("user.dir", value);
            value = config.getProperty("tomcat.home");
            if (value == null) {
                value = config.getProperty("MobileEngine.InstallationPath");
                config.setTemporary("tomcat.home", value);
            }
            ((Hashtable)p).put("tomcat.home", value);
            ((Hashtable)p).put("running_on_tomcat", "yes");
            wwwroot = "WEB-INF" + File.separator + "wwwroot";
            topdir = config.getProperty("MobileEngine.InstallationPath") + File.separator + "webapps" + File.separator + "me" + File.separator + "WEB-INF";
        } else {
            topdir = config.getProperty("MobileEngine.InstallationPath");
            wwwroot = "wwwroot";
        }
        config.setTemporary("MobileEngine.Runtime.WafTopDir", topdir);
        config.setTemporary("MobileEngine.Runtime.WwwRoot", wwwroot);
        System.setProperties(p);
    }

    private void initDlls() {
        Trace trace = Trace.getInstance("MI/Core");
        Configuration config = Configuration.getInstance();
        String instdir = config.getProperty("MobileEngine.InstallationPath");
        String installerLibrary = config.getProperty("MI.NatInst.Library", "");
        if (installerLibrary.length() > 0) {
            if (installerLibrary.startsWith("%MI_HOME%")) {
                installerLibrary = Configuration.getInstallationDirectory() + installerLibrary.substring("%MI_HOME%".length());
                installerLibrary = installerLibrary.replace('/', File.separatorChar);
            }
            try {
                Runtime.getRuntime().load(installerLibrary);
                trace.log(70, "MI OS installer lib ({0}) loaded successfully", (Object)installerLibrary);
                System.out.println("    MI OS installer lib (" + installerLibrary + ") loaded successfully.");
            }
            catch (UnsatisfiedLinkError error) {
                trace.logException(60, "MI native installer could not be loaded", error, true);
                System.out.println("    MI OS installer lib (" + installerLibrary + ") could NOT be loaded.");
            }
            catch (Exception error) {
                trace.logException(60, "MI native installer could not be loaded", error, true);
                System.out.println("    MI OS installer lib (" + installerLibrary + ") could NOT be loaded.");
            }
        }
        Vector keys = config.getKeysWithPrefix("MobileEngine.Startup.LoadDlls.");
        int size = keys.size();
        int i = 0;
        while (i < size) {
            String key = (String)keys.elementAt(i);
            String value = config.getProperty(key);
            StringTokenizer t = new StringTokenizer(value, ",");
            while (t.hasMoreElements()) {
                String dllname = t.nextToken();
                if (dllname.startsWith(INST_DIR_PLACEHOLDER)) {
                    dllname = instdir + dllname.substring(INST_DIR_PLACEHOLDER.length());
                }
                trace.log(70, "Load dll: ''{0}'' (from key ''{1}'')", (Object)dllname, (Object)key);
                try {
                    if (dllname.indexOf(47) >= 0 || dllname.indexOf(92) >= 0) {
                        Runtime.getRuntime().load(dllname);
                    } else {
                        System.loadLibrary(dllname);
                    }
                    trace.log(90, "Dll loaded.");
                }
                catch (Exception th) {
                    AppLog.getInstance("MI/Core").logException("Cannot load the library", (Throwable)th, true);
                }
            }
            ++i;
        }
        trace.log(70, "Libraries are loaded");
    }

    private void initTimedSync() {
        Configuration config = Configuration.getInstance();
        if (config.getBoolean("MobileEngine.Sync.TimedSyncActive", false) && config.getProperty("MobileEngine.Sync.TimedSyncTimeInterval") != null) {
            Long timeIntervalForSyncTimer = Long.valueOf(config.getProperty("MobileEngine.Sync.TimedSyncTimeInterval"));
            SyncTimer st = new SyncTimer(timeIntervalForSyncTimer);
            st.start();
            Trace.getInstance("MI/Core").log(70, "Timed Sync initialized. Synchronization every {0} minutes ", (Object)new Double((double)timeIntervalForSyncTimer.longValue() / 60000.0));
        }
    }

    private void initGzipDataCompressionConfiguration() {
        Configuration config = Configuration.getInstance();
        Trace trace = Trace.getInstance("MI/Core");
        if (!config.getBoolean("MobileEngine.Datacompression.Gzip", false)) {
            trace.log(90, "GzipDataCompressionConfiguration: GzipDataCompression is switched off.");
            return;
        }
        trace.log(90, "GzipDataCompressionConfiguration: GzipDataCompression is switched on.");
    }

    private void initPersistence() {
        PersistenceImplementation.getImplementation();
    }

    private void initSmartSync() {
        SmartSyncAdapter sa = (SmartSyncAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.SmartSyncAdapterImpl");
        sa.initializeSmartSyncFramework();
    }

    private void initCCMS() {
        AlertManager.getInstance();
    }

    private void initSingletons() {
        UserManagerImpl.getUserManagerImplInstance();
        SecurityManager.getInstance();
        ApplicationManager.getInstance();
        ConversationIdHandler.getInstance();
        SyncEventRegistry.getInstance();
        InstallationLog instLog = new InstallationLog();
        InboundProcessorRegistry.getInstance().register(instLog);
    }

    private void logon() {
        if (this.logonuser != null && this.logonpwd != null) {
            this.logonUser();
        } else {
            String user = Configuration.getInstance().getProperty("logonuser", "");
            String pw = Configuration.getInstance().getProperty("logonpw", "");
            if (!"".equals(user) && !"".equals(pw)) {
                this.logonuser = user;
                this.logonpwd = pw;
                this.logonUser();
            }
        }
    }

    private void logonUser() {
        System.out.print("Try to log in user '");
        System.out.print(this.logonuser);
        System.out.println("'");
        try {
            UserManagerImpl.getUserManagerImplInstance().logOnUser(this.logonuser, this.logonpwd);
        }
        catch (LogonException auth) {
            System.out.println("Cannot login user");
            auth.printStackTrace(System.out);
        }
    }

    private boolean runWithinBatchMode() {
        boolean success = false;
        Properties p = new Properties();
        try {
            FileInputStream fin = new FileInputStream(Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "batchstartup.properties");
            p.load(fin);
            this.logonuser = p.getProperty("User", this.logonuser);
            this.logonpwd = p.getProperty("Password", this.logonpwd);
            String application = p.getProperty("Application");
            if (this.logonuser != null && this.logonpwd != null && application != null) {
                this.logon();
                success = ApplicationManager.getInstance().startBatchApplication(application) != null;
            }
        }
        catch (Exception ex) {
            System.out.println("Cannot run batchmode because of " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        return success;
    }

    private void initPPC2003WorkaroundForBrowserCache() {
        Configuration config = Configuration.getInstance();
        String folder = config.getProperty("DeleteFolderAfterLogon", "");
        if (!folder.equals("")) {
            System.out.println("Delete folder '" + folder + "' afer each login");
            TempInternetCacheEraser t = new TempInternetCacheEraser();
            t.userLoggedOn(null);
            UserManagerImpl.getUserManagerImplInstance().addLogonListener(t);
        }
    }

    static {
        startbatch = false;
        communicationServer = null;
        StringBuffer sb = new StringBuffer(30);
        sb.append(File.separatorChar);
        sb.append("settings");
        sb.append(File.separatorChar);
        sb.append("MobileEngine.config");
        CONFIGURATION_FILENAME = sb.toString();
    }
}

