/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.MEVersion;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.UserManagerImpl;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeviceConfiguration {
    public static final String ATTRIBUTE_OS_NAME = "OSNAME";
    public static final String ATTRIBUTE_OS_VERSION = "OSVERSION";
    public static final String ATTRIBUTE_OEMID = "OEMID";
    public static final String ATTRIBUTE_STORAGE = "STORAGE";
    public static final String ATTRIBUTE_MEMORY = "MEMORY";
    public static final String ATTRIBUTE_PROCESSOR = "PROCESSOR";
    public static final String ATTRIBUTE_RUNTIME = "RUNTIME";
    public static final String ATTRIBUTE_JVM_VENDOR = "JVM_VENDOR";
    public static final String ATTRIBUTE_OS_ARCHITECTURE = "OSARCHITECTURE";
    public static final String ATTRIBUTE_JAVA_VERSION = "JAVA_VERSION";
    public static final String ATTRIBUTE_USER_TIMEZONE = "USER_TIMEZONE";
    public static final String NO_INFO_AVAILABLE = "No information available";
    public static final String ATTRIBUTE_FW_FULLNAME = "MI_FULLNAME";
    public static final String ATTRIBUTE_USERS_ON_DEVICE = "USERS_ON_DEVICE";
    public static final String ATTRIBUTE_INSTALLATION_TOOLKIT_IMAGE = "INSTALLATION_IMAGE";
    public static final String ATTRIBUTE_DB_INFO = "DATABASE_FULLNAME";
    private static Hashtable genericInfo = new Hashtable();

    public static void setInformation(String attributeName, String attributeValue) {
        if (attributeName == null) {
            return;
        }
        if (attributeValue == null) {
            return;
        }
        genericInfo.put(attributeName, attributeValue);
    }

    public static Hashtable getGenericInfo() {
        return genericInfo;
    }

    public String getUserTimezone() {
        String ret = Configuration.getInstance().getProperty("MobileEngine.Sync.Timezone");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getJVMVendorName() {
        String ret = System.getProperty("java.vendor");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getOperatingSystemName() {
        String ret = System.getProperty("os.name");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getOperatingSystemVersion() {
        String ret = System.getProperty("os.version");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getOperatingSystemArchitecture() {
        String ret = System.getProperty("os.arch");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getMERuntime() {
        String ret = Configuration.getInstance().getProperty("Runtime").toUpperCase();
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getJavaVersion() {
        String ret = System.getProperty("java.version");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getProcessor() {
        String ret = System.getProperty("sun.cpu.isalist");
        return ret != null ? ret : NO_INFO_AVAILABLE;
    }

    public String getOEMId() {
        return "DUMMY_OEMID";
    }

    public String getStorage(boolean free) {
        return "DUMMY_STORAGE";
    }

    public String getMemory(boolean free) {
        return "DUMMY_MEMORY";
    }

    public String getFrameworkInfos() {
        return MEVersion.getFullName();
    }

    public String getAllUsersOnDevice() {
        Enumeration e = UserManagerImpl.getUserManagerImplInstance().getAllUsers();
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            User u = (User)e.nextElement();
            sb.append(u.getUniqueName());
            if (!e.hasMoreElements()) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String getInstallationToolkitImage() {
        return Configuration.getInstance().getBoolean("MobileEngine.Installation.InstallationToolkit", false) ? "YES" : "NO";
    }
}

