/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.MEResourceBundle;
import java.util.MissingResourceException;
import java.util.Vector;

public class DeploymentMessages {
    public static final String APP_DOWNLOAD = "DOWNLOADING";
    public static final String APP_INSTALL = "INSTALLING";
    public static final String APP_DEINSTALL = "UNINSTALLING";
    public static final String APP_INSTALL_FAILURE = "FAILEDTOINST";
    public static final String APP_DOWNLOAD_FAILURE = "xmsg_FAILEDTODOWNLOAD";
    public static final String APP_DEINSTALL_FAILURE = "UNINSTALLATIONFAILURE";
    public static final Object TYPE_INSTALLATION = new Object();
    public static final Object TYPE_DEINSTALLATION = new Object();
    public static final Object TYPE_ASSIGNMENT = new Object();
    public static final Object TYPE_UNASSIGNMENT = new Object();
    public static final String APP_ASSIGN = "xmsg_APP_ASSIGN";
    public static final String APP_UNASSIGN = "xmsg_APP_UNASSIGN";
    public static final String APP_ASSIGN_FAIL = "xmsg_APP_ASSIGN_FAIL";
    public static final String APP_UNASSIGN_FAIL = "xmsg_APP_UNASSIGN_FAIL";
    protected static final String APP_MWB_NOT_AVAILABLE = "xmsg_MWBNOTAVAILABLE";
    protected static final String APP_LANGUAGE_NOT_SUPPORTED = "xmsg_LANGUAGENOTSUPPORTED";
    private static final String GENERAL_INSTALL = "NEWAPPS";
    private static final String GENERAL_DEINSTALL = "REMOVEAPPS";
    private static final String GENERAL_RESTART = "AFTERINSTALLATION";
    private static final String resourceBundleName = "com/sap/ip/me/awtapps/home/mobile_engine";
    private static DeploymentMessages instance = null;
    private boolean isRestartRequired = false;
    private boolean isToBeDisplayed = false;
    private boolean isInstalledMessageSet = false;
    private boolean isDeinstalledMessageSet = false;
    private Vector messages;
    private MEResourceBundle bundle = new MEResourceBundle("com/sap/ip/me/awtapps/home/mobile_engine");

    private DeploymentMessages() {
        this.messages = new Vector();
    }

    public static DeploymentMessages getInstance() {
        if (instance == null) {
            instance = new DeploymentMessages();
        }
        return instance;
    }

    public String[] getMessages() {
        if (this.messages.size() == 0) {
            return null;
        }
        if (this.isRestartRequired) {
            this.messages.addElement(this.bundle.getString(GENERAL_RESTART));
        }
        Object[] messageString = new String[this.messages.size()];
        this.messages.copyInto(messageString);
        return messageString;
    }

    public void refreshMessages() {
        instance = null;
    }

    public boolean hasToBeDisplayed() {
        return this.isToBeDisplayed;
    }

    public void addMessage(Object deploymentType, String languageKey, String message) {
        if (!this.isToBeDisplayed) {
            this.isToBeDisplayed = true;
        }
        if ((deploymentType.equals(TYPE_INSTALLATION) || deploymentType.equals(TYPE_DEINSTALLATION)) && !this.isRestartRequired) {
            this.isRestartRequired = true;
        }
        if (languageKey != null) {
            if (deploymentType.equals(TYPE_INSTALLATION)) {
                if (!this.isInstalledMessageSet) {
                    this.addLanguageMessage(GENERAL_INSTALL);
                    this.isInstalledMessageSet = true;
                }
            } else if (deploymentType.equals(TYPE_DEINSTALLATION) && !this.isDeinstalledMessageSet) {
                this.addLanguageMessage(GENERAL_DEINSTALL);
                this.isDeinstalledMessageSet = true;
            }
            this.addMessage(languageKey, message);
        }
    }

    public void addMessage(String message) {
        if (!this.isToBeDisplayed) {
            this.isToBeDisplayed = true;
        }
        if (message != null) {
            this.messages.addElement(message);
        }
    }

    private void addLanguageMessage(String languageKey) {
        if (languageKey != null) {
            try {
                this.messages.addElement(this.bundle.getString(languageKey));
            }
            catch (MissingResourceException exc) {
                Trace.getInstance("MI/Deployment").log(60, "Exception while adding language key '" + languageKey + "' to DeploymentMessages (parameter not found in ResourceBundle)");
            }
        } else {
            Trace.getInstance("MI/Deployment").log(60, "Exception while adding language key to DeploymentMessages (cannot add null key)");
        }
    }

    private void addMessage(String languageKey, String message) {
        block5: {
            if (languageKey != null) {
                try {
                    if (message != null) {
                        this.messages.addElement(this.bundle.getString(languageKey) + " " + message);
                        break block5;
                    }
                    this.addLanguageMessage(languageKey);
                }
                catch (MissingResourceException exc) {
                    Trace.getInstance("MI/Deployment").log(60, "Exception while adding language key '" + languageKey + "' to DeploymentMessages (parameter not found in ResourceBundle)");
                }
            } else {
                Trace.getInstance("MI/Deployment").log(60, "Exception while adding language key to DeploymentMessages (cannot add null key)");
            }
        }
    }
}

