/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.CipherHandler;

public class DBPasswordHandler {
    private String password;
    private static final String EMPTY_STRING = "";
    private static final AppLog appLog = AppLog.getInstance("MI/Core");
    private static final Trace trace = Trace.getInstance("MI/Core");

    protected DBPasswordHandler(CipherHandler cipherHandler) {
        Configuration config = Configuration.getInstance();
        this.password = config.getProperty("MobileEngine.Persist.Jdbc.DbUserPassword");
        boolean isPasswordEncoded = false;
        if (this.password == null || this.password.length() == 0) {
            this.password = config.getProperty("MobileEngine.Persist.Jdbc.EncodedDbUserPassword");
            if (this.password == null || this.password.length() == 0) {
                appLog.log(60, "There is no database user password available.");
                this.password = EMPTY_STRING;
                return;
            }
            isPasswordEncoded = true;
        }
        if (!isPasswordEncoded) {
            String encodedPassword = cipherHandler.encrypt(this.password);
            config.setDefaultProperty("MobileEngine.Persist.Jdbc.EncodedDbUserPassword", encodedPassword);
            config.setDefaultProperty("MobileEngine.Persist.Jdbc.DbUserPassword", EMPTY_STRING);
        } else {
            try {
                this.password = cipherHandler.decrypt(this.password);
            }
            catch (Exception e) {
                appLog.log(50, "Errors occurred during the database user password decoding procedure. Contact the support team.");
                trace.logException(50, "Decryption failed. The empty string was assigned as password.", null, e, true);
                this.password = EMPTY_STRING;
            }
        }
    }

    public String getPassword() {
        return this.password;
    }
}

