/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.LogonListener;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ConversationIdHandler
implements LogonListener {
    private static final ConversationId[] EMPTY_CONVIDARRAY = new ConversationId[0];
    private static final MobileSolutionDescriptor[] EMPTY_MSDARRAY = new MobileSolutionDescriptor[0];
    private static final String CONV_ID_FILENAME = Configuration.getInstance().getProperty("MobileEngine.InstallationPath") + File.separator + "settings" + File.separator + "convids.sys";
    private static final String FRAMEWORK_CONVID_PREFIX = "MI";
    private final Hashtable convIdsForApplication = new Hashtable();
    private static ConversationIdHandler instance;
    private static ConversationId frameworkshared;

    public ConversationIdHandler() {
        if (instance != null) {
            throw new RuntimeException("ConversationIdHandler already initialized");
        }
        this.load();
        this.generateFrameworkConversationIds();
        UserManagerImpl.getUserManagerImplInstance().addLogonListener(this);
    }

    public static ConversationIdHandler getInstance() {
        return instance;
    }

    public static ConversationId getSharedFrameworkConversationId() {
        if (frameworkshared == null) {
            frameworkshared = ConversationIdHandler.getInstance().getConversationId(ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor(), UserManagerImpl.getSharedUser());
        }
        return frameworkshared;
    }

    public ConversationId getCurrentConversationId() {
        User currentUser = UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
        if (currentUser == null) {
            currentUser = UserManagerImpl.getSharedUser();
        }
        return this.getConversationIdforCurrentApplication(currentUser);
    }

    public ConversationId getCurrentConversationId(VisibilityType visibility) {
        if (VisibilityType.SEPARATED.equals(visibility)) {
            return this.getCurrentConversationId();
        }
        return this.getConversationIdforCurrentApplication(UserManagerImpl.getSharedUser());
    }

    public ConversationId[] getAllConversationIds() {
        int size = this.getNumberOfConversationIds();
        ConversationId[] result = new ConversationId[size];
        int i = 0;
        Enumeration appsVectors = this.convIdsForApplication.elements();
        while (appsVectors.hasMoreElements()) {
            Vector appsVector = (Vector)appsVectors.nextElement();
            Enumeration convids = appsVector.elements();
            while (convids.hasMoreElements()) {
                result[i] = (ConversationId)convids.nextElement();
                ++i;
            }
        }
        return result;
    }

    public int getNumberOfConversationIds() {
        int size = 0;
        Enumeration appsVectors = this.convIdsForApplication.elements();
        while (appsVectors.hasMoreElements()) {
            Vector appsVector = (Vector)appsVectors.nextElement();
            size += appsVector.size();
        }
        return size;
    }

    public ConversationId getConversationId(MobileSolutionDescriptor msd, User user) {
        if (msd == null || user == null) {
            return null;
        }
        Vector users = (Vector)this.convIdsForApplication.get(msd.getId());
        if (users == null) {
            return null;
        }
        ConversationId result = null;
        boolean found = false;
        Enumeration e = users.elements();
        while (e.hasMoreElements() && !found) {
            result = (ConversationId)e.nextElement();
            if (!result.getUser().equals(user)) continue;
            found = true;
        }
        if (found) {
            return result;
        }
        return null;
    }

    public ConversationId getConversationId(String id) {
        ConversationId[] convIDs = this.getAllConversationIds();
        int i = 0;
        while (i < convIDs.length) {
            if (convIDs[i].getId().equals(id) || convIDs[i].getServerCommunicationId().equals(id)) {
                return convIDs[i];
            }
            ++i;
        }
        return null;
    }

    public static void setDeviceId(String newDeviceId) {
        if (newDeviceId == null) {
            return;
        }
        newDeviceId = newDeviceId.trim();
        String oldId = ConversationIdHandler.getDeviceId();
        if (newDeviceId.length() == 0 || newDeviceId.equals(oldId)) {
            return;
        }
        Trace trace = Trace.getInstance("MI/Core");
        boolean installationtoolkitimage = Configuration.getInstance().getBoolean("MobileEngine.Installation.InstallationToolkit", false);
        if (oldId.length() == 0) {
            trace.log(70, "Set initial device id: " + newDeviceId);
        } else if (installationtoolkitimage) {
            AppLog.getInstance("MI/Core").log(70, "Overwrite old device id {0} with new device id {1} because it is an installation image", (Object)oldId, (Object)newDeviceId);
        } else {
            AppLog.getInstance("MI/Core").log(50, "Cannot overwrite old device id " + oldId + " with new device id " + newDeviceId);
            newDeviceId = oldId;
        }
        Configuration.getInstance().setDefaultProperty("MobileEngine.Sync.Deviceid", newDeviceId);
    }

    public static String getDeviceId() {
        return Configuration.getInstance().getProperty("MobileEngine.Sync.Deviceid", "");
    }

    public void save() {
        try {
            File f = new File(CONV_ID_FILENAME);
            File dir = new File(f.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BufferedUTF8Writer pout = new BufferedUTF8Writer(f);
            Enumeration vectors = this.convIdsForApplication.elements();
            Vector idvector = null;
            Enumeration ids = null;
            ConversationId id = null;
            while (vectors.hasMoreElements()) {
                idvector = (Vector)vectors.nextElement();
                ids = idvector.elements();
                while (ids.hasMoreElements()) {
                    id = (ConversationId)ids.nextElement();
                    pout.write(id.getId());
                    pout.write("&&");
                    pout.newLine();
                }
            }
            pout.flush();
            pout.close();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Cannot save conversation ids file: " + ioex.getMessage());
        }
    }

    public void saveAll() {
        try {
            File f = new File(CONV_ID_FILENAME);
            File dir = new File(f.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BufferedUTF8Writer pout = new BufferedUTF8Writer(f);
            Enumeration vectors = this.convIdsForApplication.elements();
            Vector idvector = null;
            Enumeration ids = null;
            ConversationId id = null;
            while (vectors.hasMoreElements()) {
                idvector = (Vector)vectors.nextElement();
                ids = idvector.elements();
                while (ids.hasMoreElements()) {
                    id = (ConversationId)ids.nextElement();
                    try {
                        id.save();
                        pout.write(id.getId());
                        pout.write("&&");
                        pout.newLine();
                    }
                    catch (InstallationException instEx) {
                        Trace.getInstance("MI/Sync").logException("Cannot save conversation id " + id.toString(), (Throwable)instEx, true);
                    }
                }
            }
            pout.flush();
            pout.close();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Cannot save conversation ids file: " + ioex.getMessage());
        }
    }

    public ConversationId[] getAllConversationIdsForUser(User user) {
        if (user == null) {
            return EMPTY_CONVIDARRAY;
        }
        Vector<ConversationId> resVector = new Vector<ConversationId>();
        Enumeration appsVectors = this.convIdsForApplication.elements();
        ConversationId currentId = null;
        while (appsVectors.hasMoreElements()) {
            Vector appsVector = (Vector)appsVectors.nextElement();
            Enumeration convids = appsVector.elements();
            while (convids.hasMoreElements()) {
                currentId = (ConversationId)convids.nextElement();
                if (!currentId.getUser().equals(user)) continue;
                resVector.addElement(currentId);
            }
        }
        Object[] result = new ConversationId[resVector.size()];
        resVector.copyInto(result);
        return result;
    }

    public MobileSolutionDescriptor[] getAllMobileSolutionDescriptorsForUser(User user) {
        if (user == null) {
            return EMPTY_MSDARRAY;
        }
        Vector<MobileSolutionDescriptor> resVector = new Vector<MobileSolutionDescriptor>();
        Enumeration appsVectors = this.convIdsForApplication.elements();
        ConversationId currentId = null;
        while (appsVectors.hasMoreElements()) {
            Vector appsVector = (Vector)appsVectors.nextElement();
            Enumeration convids = appsVector.elements();
            while (convids.hasMoreElements()) {
                currentId = (ConversationId)convids.nextElement();
                if (!currentId.getUser().equals(user)) continue;
                resVector.addElement(currentId.getMsd());
            }
        }
        Object[] result = new MobileSolutionDescriptor[resVector.size()];
        resVector.copyInto(result);
        return result;
    }

    public ConversationId[] getAllConversationIdsForApplication(MobileSolutionDescriptor msd) {
        if (msd == null) {
            return EMPTY_CONVIDARRAY;
        }
        Vector idVector = (Vector)this.convIdsForApplication.get(msd.getId());
        if (idVector == null) {
            return EMPTY_CONVIDARRAY;
        }
        ConversationId[] result = new ConversationId[idVector.size()];
        int i = 0;
        Enumeration convids = idVector.elements();
        while (convids.hasMoreElements()) {
            result[i] = (ConversationId)convids.nextElement();
            ++i;
        }
        return result;
    }

    public ConversationId addConversationId(ConversationId newConversationId) throws InstallationException {
        if (newConversationId == null || newConversationId.getId() == null) {
            throw new InstallationException(0, null, null);
        }
        ConversationId result = newConversationId;
        if (this.getConversationId(newConversationId.getId()) == null) {
            result = this.addConversationIdWithoutSave(newConversationId);
            this.save();
        }
        return result;
    }

    public void removeConversationId(String convId) throws InstallationException {
        Enumeration vectors = this.convIdsForApplication.elements();
        Vector idvector = null;
        Enumeration ids = null;
        ConversationId id = null;
        while (vectors.hasMoreElements()) {
            idvector = (Vector)vectors.nextElement();
            ids = idvector.elements();
            while (ids.hasMoreElements()) {
                id = (ConversationId)ids.nextElement();
                if (!id.getId().equals(convId)) continue;
                idvector.removeElement(id);
                id.delete();
                this.save();
                return;
            }
        }
    }

    public void userLoggedOn(User user) {
        MobileSolutionDescriptor frameworkapp = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
        ConversationId convId = null;
        if (this.getConversationId(frameworkapp, user) == null) {
            try {
                convId = new ConversationId(this.generateFrameworkIdForUser(user), frameworkapp, user);
                this.addConversationId(convId);
            }
            catch (InstallationException instEx) {
                String message = "Error while generating framework conversation id for user " + user;
                AppLog.getInstance("MI/Core").logException(10, message, instEx, false);
                throw new RuntimeException(message);
            }
        }
    }

    public void completeConvIdsForSharedUser() {
        if (!Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true)) {
            MobileSolutionDescriptor[] msds = ApplicationManager.getInstance().getMobileSolutionDescriptors();
            User sharedUser = UserManagerImpl.getSharedUser();
            int i = 0;
            while (i < msds.length) {
                if (this.getConversationId(msds[i], sharedUser) == null) {
                    try {
                        ConversationId convId = new ConversationId(msds[i].getId() + sharedUser.getUniqueName(), msds[i], sharedUser, false);
                        this.addConversationId(convId);
                    }
                    catch (InstallationException e) {
                        String message = "Conversation id for shared user could not be created for application " + msds[i];
                        AppLog.getInstance("MI/Core").logException(10, message, e, true);
                        throw new RuntimeException(message);
                    }
                }
                ++i;
            }
        }
    }

    void _removeAllConversationIds() {
        ConversationId[] ids = this.getAllConversationIds();
        int i = 0;
        while (i < ids.length) {
            ids[i].delete();
            ++i;
        }
        this.convIdsForApplication.clear();
        this.save();
    }

    void generateFrameworkConversationIds() {
        Enumeration enumeration = UserManagerImpl.getUserManagerImplInstance().getAllUsers();
        User u = null;
        MobileSolutionDescriptor frameworkapp = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
        ConversationId convId = null;
        AppLog applog = AppLog.getInstance("MI/Core");
        while (enumeration.hasMoreElements()) {
            u = (User)enumeration.nextElement();
            convId = this.getConversationId(frameworkapp, u);
            if (convId != null) continue;
            try {
                convId = new ConversationId(this.generateFrameworkIdForUser(u), frameworkapp, u);
                this.addConversationId(convId);
            }
            catch (InstallationException instEx) {
                String message = "Error while generating framework conversation id for user " + u;
                applog.logException(message, (Throwable)instEx, false);
                throw new RuntimeException(message);
            }
        }
        u = UserManagerImpl.getSharedUser();
        convId = this.getConversationId(frameworkapp, u);
        if (convId == null && u != null) {
            try {
                convId = new ConversationId(this.generateFrameworkIdForUser(u), frameworkapp, u, false);
                this.addConversationId(convId);
            }
            catch (InstallationException instEx) {
                String message = "Error while generating framework conversation id for shared user";
                applog.logException(message, (Throwable)instEx, false);
                throw new RuntimeException(message);
            }
        }
    }

    private ConversationId getConversationIdforCurrentApplication(User currentUser) {
        if (currentUser == null) {
            throw new IllegalStateException("Cannot get current conversation id because there is no current user");
        }
        ApplicationManager appman = ApplicationManager.getInstance();
        MobileSolutionDescriptor msd = appman.getCurrentMSD();
        return this.getConversationId(msd, currentUser);
    }

    public void load() {
        try {
            File f = new File(CONV_ID_FILENAME);
            BufferedUTF8Reader pin = new BufferedUTF8Reader(f);
            String line = null;
            this.convIdsForApplication.clear();
            ConversationId convid = null;
            int end = -1;
            while ((line = pin.readLine()) != null) {
                end = line.indexOf("&&");
                if (end < 0) continue;
                String id = line.substring(0, end);
                convid = new ConversationId(id);
                this.addConversationIdWithoutSave(convid);
            }
            pin.close();
        }
        catch (Exception t) {
            String message = "Cannot load conversation ids from persistence";
            AppLog.getInstance("MI/Core").logException(10, message, t, true);
            this.convIdsForApplication.clear();
            throw new RuntimeException(message);
        }
    }

    private ConversationId addConversationIdWithoutSave(ConversationId newConversationId) throws InstallationException {
        if (newConversationId.getMsd() == null) {
            throw new InstallationException(1, null, null);
        }
        if (newConversationId.getUser() == null) {
            throw new InstallationException(2, null, null);
        }
        ConversationId old = this.getConversationId(newConversationId.getMsd(), newConversationId.getUser());
        if (old != null) {
            boolean isNewProtocolActive = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true);
            if (old.isGeneratedOnServer() || !newConversationId.isGeneratedOnServer() && isNewProtocolActive) {
                throw new InstallationException(3, new Object[]{old.toString(), newConversationId.toString()}, null);
            }
            old.setServerCommunicationId(newConversationId.getServerCommunicationId());
            newConversationId.delete();
            return old;
        }
        Vector users = (Vector)this.convIdsForApplication.get(newConversationId.getMsd().getId());
        if (users == null) {
            Vector<ConversationId> v = new Vector<ConversationId>();
            v.addElement(newConversationId);
            this.convIdsForApplication.put(newConversationId.getMsd().getId(), v);
        } else {
            users.addElement(newConversationId);
        }
        return newConversationId;
    }

    private String generateFrameworkIdForUser(User u) {
        String username = u.getUniqueID();
        StringBuffer idBuffer = new StringBuffer(FRAMEWORK_CONVID_PREFIX.length() + username.length() * 4);
        idBuffer.append(FRAMEWORK_CONVID_PREFIX);
        int i = 0;
        while (i < username.length()) {
            char currentchar = username.charAt(i);
            idBuffer.append(Integer.toHexString(currentchar));
            ++i;
        }
        return idBuffer.toString();
    }

    static {
        frameworkshared = null;
        instance = (ConversationIdHandler)Configuration.getInstance().getSingletonInstanceForType("MobileEngine.Reg.ConvIdImplementation");
    }
}

