/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.core;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public final class ConversationId
implements Serializable {
    private static final Trace trace = Trace.getInstance("MI/Core");
    private String id;
    private String serverCommunicationId;
    private User user = null;
    private MobileSolutionDescriptor msd = null;
    private int sequenceNoIn = 0;
    private int sequenceNoOut = 1;
    private String conversationIdFilename = null;
    private transient boolean frameworkConversationId = false;
    private boolean generatedOnServer = false;
    private String lastContainerId = null;

    public ConversationId(String id, MobileSolutionDescriptor msd, User user) throws InstallationException {
        this(id, msd, user, false);
    }

    public ConversationId(String id, MobileSolutionDescriptor msd, User user, boolean isGeneratedOnServer) throws InstallationException {
        if (id == null || "".equals(id)) {
            throw new InstallationException(0, null, null);
        }
        if (msd == null) {
            throw new InstallationException(1, null, null);
        }
        if (user == null) {
            throw new InstallationException(2, null, null);
        }
        this.frameworkConversationId = msd.getName().toUpperCase().startsWith("MOBILEENGINE") && "".equals(msd.getNamespace());
        this.id = id;
        this.serverCommunicationId = id;
        this.msd = msd;
        this.user = user;
        this.generatedOnServer = isGeneratedOnServer;
        this.lastContainerId = null;
        this.save();
    }

    ConversationId(String id) throws InstallationException {
        if (id == null || "".equals(id)) {
            throw new InstallationException(0, null, null);
        }
        this.id = id;
        this.serverCommunicationId = id;
        this.load();
    }

    public String getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public MobileSolutionDescriptor getMsd() {
        return this.msd;
    }

    public int getSequenceNoIn() {
        return this.sequenceNoIn;
    }

    public void increaseSequenceNoIn() throws InstallationException {
        this.sequenceNoIn = this.sequenceNoIn == Integer.MAX_VALUE ? 1 : ++this.sequenceNoIn;
        this.save();
    }

    public void increaseSequenceNoOut() throws InstallationException {
        this.increaseSequenceNoOut(false);
    }

    public void increaseSequenceNoOut(boolean inTransactionalContext) throws InstallationException {
        this.sequenceNoOut = this.sequenceNoOut == Integer.MAX_VALUE ? 1 : ++this.sequenceNoOut;
        if (!inTransactionalContext) {
            this.save();
        }
    }

    public int getSequenceNoOut() {
        return this.sequenceNoOut;
    }

    public boolean isFrameworkConversationId() {
        return this.frameworkConversationId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append(this.id).append(" / ").append(this.serverCommunicationId);
        buffer.append(" (User: ").append(this.user == null ? "(null)" : this.user.getUniqueName());
        buffer.append(", MSD: ").append(this.msd).append(")");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof ConversationId && this.id.equals(((ConversationId)other).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isGeneratedOnServer() {
        return this.generatedOnServer;
    }

    public boolean isSyncComplete() {
        boolean result;
        boolean bl = result = this.lastContainerId == null || this.lastContainerId.length() == 0;
        if (result) {
            trace.log(90, "Conversation id is complete: " + this.serverCommunicationId);
        } else {
            trace.log(90, "Wait for container " + this.lastContainerId + "; Incomplete conversation id " + this.serverCommunicationId);
        }
        return result;
    }

    public void setLastSyncContainerId(String newLastContainerId) {
        if (newLastContainerId == null) {
            trace.log(70, "Reset last container id for conversation id " + this.serverCommunicationId);
        } else {
            trace.log(70, "Set last container id " + newLastContainerId + " for conversation id " + this.serverCommunicationId);
        }
        this.lastContainerId = newLastContainerId;
        try {
            this.save();
        }
        catch (InstallationException instEx) {
            Trace.getInstance("MI/Core").logException("Cannot update conversation id file", (Throwable)instEx, true);
        }
    }

    public String getLastSyncContainerId() {
        return this.lastContainerId == null ? "" : this.lastContainerId;
    }

    public boolean isSharedConversationId() {
        return UserManagerImpl.getSharedUser().equals(this.user);
    }

    public String getServerCommunicationId() {
        return this.serverCommunicationId;
    }

    public void setServerCommunicationId(String serverCommunicationId) {
        if (!this.serverCommunicationId.equals(serverCommunicationId)) {
            this.serverCommunicationId = serverCommunicationId;
            if (!this.id.equals(this.serverCommunicationId)) {
                this.generatedOnServer = true;
            }
            try {
                this.save();
            }
            catch (InstallationException ex) {
                AppLog.getInstance("MI/Deployment").logException(50, "Cannot set server communication id " + serverCommunicationId + "; check the device installation", ex, true);
            }
        }
    }

    void _setSequenceNoOut(int out) {
        this.sequenceNoOut = out;
    }

    void _setSequenceNoIn(int in) {
        this.sequenceNoIn = in;
    }

    void delete() {
        File f = new File(this.getFilename());
        if (f.exists()) {
            f.delete();
        }
    }

    private String getFilename() {
        if (this.conversationIdFilename == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(Configuration.getInstance().getProperty("MobileEngine.InstallationPath"));
            sb.append(File.separator).append("settings");
            sb.append(File.separator).append("covIds");
            sb.append(File.separator).append(this.id).append(".cid");
            this.conversationIdFilename = sb.toString();
        }
        return this.conversationIdFilename;
    }

    void load() throws InstallationException {
        try {
            File f = new File(this.getFilename());
            BufferedUTF8Reader pin = new BufferedUTF8Reader(f);
            String line = null;
            String username = null;
            String msdId = null;
            int start = 0;
            int end = -1;
            line = pin.readLine();
            if (line != null && (end = line.indexOf("&&")) >= 0) {
                this.id = line.substring(0, end);
                start = end + 2;
                end = line.indexOf("&&", start);
                this.serverCommunicationId = line.substring(start, end);
                start = end + 2;
                end = line.indexOf("&&", start);
                msdId = line.substring(start, end);
                this.msd = ApplicationManager.getInstance().getMobileSolutionDescriptorById(msdId);
                if (this.msd == null) {
                    throw new InstallationException(5, new Object[]{"invalid mobile solution descriptor"}, null);
                }
                start = end + 2;
                end = line.indexOf("&&", start);
                username = line.substring(start, end);
                this.user = UserManagerImpl.getUserManagerImplInstance().getUser(username);
                if (this.user == null) {
                    throw new InstallationException(5, new Object[]{"user unknown"}, null);
                }
                start = end + 2;
                end = line.indexOf("&&", start);
                this.sequenceNoIn = Integer.parseInt(line.substring(start, end));
                start = end + 2;
                end = line.indexOf("&&", start);
                this.sequenceNoOut = Integer.parseInt(line.substring(start, end));
                start = end + 2;
                end = line.indexOf("&&", start);
                this.frameworkConversationId = Boolean.valueOf(line.substring(start, end));
                start = end + 2;
                end = line.indexOf("&&", start);
                this.generatedOnServer = Boolean.valueOf(line.substring(start, end));
                start = end + 2;
                this.lastContainerId = (end = line.indexOf("&&", start)) != -1 ? line.substring(start, end) : null;
            }
            pin.close();
        }
        catch (IOException ioex) {
            Trace.getInstance("MI/Core").logException("Cannot load conversation id from file", (Throwable)ioex, false);
            throw new InstallationException(5, new Object[]{ioex.getMessage()}, ioex);
        }
    }

    void save() throws InstallationException {
        File f = new File(this.getFilename());
        try {
            File dir = new File(f.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            BufferedUTF8Writer pout = new BufferedUTF8Writer(f);
            pout.write(this.id);
            pout.write("&&");
            pout.write(this.serverCommunicationId);
            pout.write("&&");
            pout.write(this.getMsd().getId());
            pout.write("&&");
            pout.write(this.getUser().getUniqueName());
            pout.write("&&");
            pout.write("" + this.getSequenceNoIn());
            pout.write("&&");
            pout.write("" + this.getSequenceNoOut());
            pout.write("&&");
            pout.write("" + this.isFrameworkConversationId());
            pout.write("&&");
            pout.write("" + this.isGeneratedOnServer());
            pout.write("&&");
            if (this.lastContainerId != null && this.lastContainerId.length() > 0) {
                pout.write(this.lastContainerId);
                pout.write("&&");
            }
            pout.newLine();
            pout.flush();
            pout.close();
        }
        catch (Exception ex) {
            Trace.getInstance("MI/Core").logException("Cannot save conversation id to file: " + ex.getMessage(), (Throwable)ex, false);
            throw new InstallationException(4, new Object[]{f.getAbsolutePath()}, ex);
        }
    }
}

